<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Fonctions pour serie aleatoire
	@package serie_aleatoire
	@modulegroup fonctions
*/
/**
	Fonctions de conversion de type de serie aleatoire pour compatibilit entre le script et les schmas (public et contraites)
	Convertit  le type s'il y a lieu pour les fonctions plpgsql
	@param integer : numero du type
	@return integer :
*/
function get_serie_aleatoire_type_old_new($old_type){
	if(VERSION_BASE>VERSION){
		switch($old_type){
			case 0 : return 1;
			case 1 : return 2;
			case 2 : return 3;
		}
	}
	else
		return $old_type;
}

/**
	Fonctions de conversion de type de serie aleatoire pour compatibilit entre  les schmas (public et contraites) et le script 
	Convertit  le type s'il y a lieu pour le script
	@param integer : numero du type
	@return integer :
*/
function get_serie_aleatoire_type_new_old($new_type){
	if(VERSION_BASE>VERSION){
		switch($new_type){
			case 1 : return 0;
			case 2 : return 1;
			case 3 : return 2;
		}
	}
	else
		return $new_type;
}

/**
	Fonction de mise en forme de la configuration d'une serie aleatoire multiserie 
	pour compatibilit avec le script
	@param ressource : resultat requete
	@return array : tableau des resultats
*/
function mise_en_forme_configuration_serie_aleatoire($res){
	$tab=array();
	if(VERSION_BASE>VERSION){
		$tab_temp=array();
		
		$nb_rec=pg_num_rows($res);
		for($i=0;$i<$nb_rec;$i++){
			$row= pg_fetch_row($res,$i);
			/*
			echo "<pre>";
			print_r($row);
			echo "</pre><hr>";
			*/
			//$tab_temp[$row[1]] .=get_evaluation_type_new_old($row[3]).":".$row[2].",";
			
				$tab_temp[$row[1]] .=get_evaluation_type_new_old($row[3]).":".$row[2];
			/*
			echo "<pre>";
			print_r($tab_temp);
			echo "</pre>";
			*/
			if($i<$nb_rec -1)
				$tab_temp[$row[1]] .=",";
			
		}
		/*
		echo "tabtemp<br><pre>";
			print_r($tab_temp);
			echo "</pre><hr>";
		*/
		
		
		
		while(list($cle,$val)=each($tab_temp)){
			//echo "cle=$cle et val=$val<br>";
			$tab_row=array();
			$tab_row[]=$row[0];
			$tab_row[]=$cle;
			$tab_row[]=$val;
			$tab[$cle]=$tab_row;
			
		}
		/*
		echo "tab<br><pre>";
		print_r($tab);
		echo "</pre>";
		*/
		
	
	}
	else{
		$nb_rec=pg_num_rows($res);
		for($i=0;$i<$nb_rec;$i++){
			$row=pg_fetch_row($res,$i);
			/*
			echo "<pre>";
			print_r($row);
			echo "</pre><hr>";
			*/
			$tab[$row[1]]=$row;
		}
	}
	return $tab;
}

/**
	Insertion de la configuration d'une serie aleatoire
	@param array : $_GET
*/
function insertion_configuration_serie_aleatoire($tab){
	//print_r($tab);
	// fonction conversion type ex: si 'blanc' retourne 3
	function conversion_type($chaine_type){
		$type_retour=0;
		//echo "chaine_type=$chaine_type<br>";
		switch($chaine_type){
			case 'blanc' : $type_retour=3;
			break;
			case 'sondage' : $type_retour=2;
			break;
			case 'qcm' : $type_retour=1;
			break;
			case 'qrc' : $type_retour=4;
			break;
			case 'src' : $type_retour=5;
			break;
		}
		return $type_retour;
	}
	reset($tab);
	
	if($tab["mode"]==1)
		$filtre="serie";
	else
		$filtre="theme";
	//echo "filtre=$filtre<br>";
	if(VERSION_BASE>VERSION){
		$tab_chaine_type=array("qcm","sondage","blanc","qrc","src");
		$serie=$tab["id"];
		// Construction de la chaine "{{$serie,$serie_source,$nbexo,$type}, {$serie,$serie_source,$nbexo,$type}}
		$chaine="_int4'{";
		while(list($nom,$valeur)=each($tab)){
			//echo "nom=$nom<br>";
			if(substr($nom,0,5)==$filtre){
				$continu=1;
				while($continu){
					//echo "coucou<br>";
					//lecture suivant
					$val=each($tab);
					$tab_type=explode("_",$val[0]);
					if(in_array($tab_type[0],$tab_chaine_type)){
						//$tab_type=explode("_",$val[0]);
						$num_type=conversion_type($tab_type[0]);
						//echo "num_type=$num_type<br>";
						if($val[1]>0 && $num_type>0){
							//echo "coucou<br>";
							$chaine .="{".$valeur.",".$val[1].",".$num_type."},";
						}
					}
					else{
						$continu=0;
						prev($tab);
										
					}
				}
			}
					
		}
		
		//echo "chaine=$chaine<br>";
		$chaine=substr($chaine,0,-1);
		$chaine.="}'";
		//echo "chaine=$chaine<br>";
		if($filtre=='serie')
			set_serie_aleatoire_multiserie_configuration($serie,$chaine);
		else
			set_serie_aleatoire_multitheme_configuration($serie,$chaine);		
	
	}
	else{
		//echo "coucou<br>";
		$id=$tab["id"]; 
		 extract($tab);
		//print_r($tab);
		while(list($nom,$valeur)=each($tab)){
			//echo "nom=$nom et valeur=$valeur<br>";
			if(substr($nom,0,5)==$filtre){
				$tabconfig=array(); 			
				//lecture suivant
				$val=each($tab);
				//print_r($val);
				$tabval=explode("_",$val[0]);
				//print_r($tabval);
				//echo "blanc=$blanc et tabval[0]=$tabval[0] et tabval[1]=$tabval[1] et valeur=$valeur<br>".$tab["blanc"];
				if($tabval[0]=='blanc' && $tab["blanc"]==1 && $tabval[1]==$valeur){
					if($val[1]>0)
							$tabconfig[]="f:$val[1]";
					$val=each($tab);
				}
				$tabval=explode("_",$val[0]);
				
				if($tabval[0]=='qcm'){
					if($tabval[1]==$valeur)
						if($val[1]>0 && $tab["qcm"]==1)
							$tabconfig[]="q:$val[1]";
					$val=each($tab);
				}
				$tabval=explode("_",$val[0]);
				if($tabval[0]=='qrc'){
					if($tabval[1]==$valeur)
						if($val[1]>0 && $qrc==1)
							$tabconfig[]="m:$val[1]";
					$val=each($tab);
				}
				$tabval=explode("_",$val[0]);
				if($tabval[0]=='sondage'){
					if($tabval[1]==$valeur)
						if($val[1]>0 && $sondage==1)
							$tabconfig[]="s:$val[1]";
					$val=each($tab);
				}
				$tabval=explode("_",$val[0]);
				if($tabval[0]=='src'){
					if($tabval[1]==$valeur)
						if($val[1]>0 && $src==1)
							$tabconfig[]="o:$val[1]";
					$val=each($tab);
				}
				$tabval=explode("_",$val[0]);
				if($tabval[0]=='glisser' ){
					if($val[1]>0 && $glisser==1)
						$tabconfig[]="d:$val[1]";
				}
				else
					prev($tab);
				//print_r($tabconfig);
				if(count($tabconfig)>0){
					$liste_exo=implode(",",$tabconfig);
					// on enregistre ds serie_aleatoire
					$mode=$tab["mode"];
					$theme=$tab["theme"];
					if($mode==1)
						$sql="insert into serie_aleatoire values($id,$theme,$valeur,'$liste_exo',$mode)";
                    else
						$sql="insert into serie_aleatoire values($id,$valeur,0,'$liste_exo',$mode)";
				}
				// NOTE en commentaire le temps du debug
				//echo "sql=$sql<br>";
                $ins=pg_query($sql) ;
			}
		}
	}
}
?>