<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Fonctions pour obtenir les entit�s de la plate-forme.
	
       @package serie_aleatoire
       @modulegroup plpgsql
       @module plpgsql_serie_aleatoire
*/
/**
	Obtenir les infos d'une serie aleatoire (OLD)
	@param integer : numero de la serie
	@return integer : resultat requete (id,libelle,bareme,chrono)
*/
function get_serie_aleatoire_old($serie){
	$sql="select id,titre,bareme,chrono from serie_exo where id=$serie";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Obtenir les infos d'une serie aleatoire 
	@param integer : numero de la serie
	@return integer : resultat requete (id,libelle,bareme,chrono)
*/
function get_serie_aleatoire($serie){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_serie_aleatoire($serie) as (id int4,libelle varchar,bareme int4,chrono int4,type int4,date_creation timestamp)";
		//$sql="select * from contraintes.af_get_serie($serie) as (id int4,libelle varchar,bareme int4,chrono int4,date_creation timestamp)";
		$res=pg_query($sql);
	}
	else
		$res=get_serie_aleatoire_old($serie);
	return $res;
}

/**
	Enregistre une serie aleatoire (OLD)
	@param string : titre de la serie
	@param integer : numero theme
	@param integer : numero bareme
	@param integer : valeur chrono
	@param integer : type serie aleatoire
*/
function set_serie_aleatoire_old($titre,$theme,$bareme,$chrono,$type){
	
	$sql="insert into serie_exo(titre,theme,bareme,chrono) VALUES('$titre',$theme,$bareme,$chrono)";
	//echo "sql=$sql<br>";
	$ins=pg_query($sql);
	$oid=pg_getlastoid($ins);
	$res=pg_query("select id from serie_exo where oid=$oid;");
	return pg_fetch_result($res,0,0);
	
}
/**
	Enregistre une serie aleatoire
	@param string : titre de la serie
	@param integer : numero theme
	@param integer : numero bareme
	@param integer : valeur chrono
	@param integer : type serie aleatoire
*/
function set_serie_aleatoire($titre,$theme,$bareme,$chrono,$type){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_serie_aleatoire('$titre',$bareme,$chrono,$type)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
		if($type!=3)
			set_categorie_element_theme(19,$theme,pg_fetch_result($res,0,0));
		return pg_fetch_result($res,0,0);
	}
	else
		return set_serie_aleatoire_old($titre,$theme,$bareme,$chrono,$type);
	
}

/**
	Obtenir les series (series sources ) d'une serie aleatoire multiserie (OLD)
	@param integer : numero de la serie aleatoire
	@return integer : resultat requete
*/
function get_serie_aleatoire_series_sources_old($serie){
	$sql="select distinct serie from serie_aleatoire where num_serie=$serie and mode=1";
	return pg_query($sql);
}
/**
	Obtenir les series (series sources ) d'une serie aleatoire multiserie 
	@param integer : numero de la serie aleatoire
	@return integer : resultat requete
*/
function get_serie_aleatoire_series_sources($serie){
	 if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_serie_aleatoire_series_sources($serie) as (serie_source int4)";
		$res=pg_query($sql);
	 }
	 else
		$res=get_serie_aleatoire_series_sources_old($serie);
	 return $res;
}

/**
	Supprimer une serie aleatoire (OLD)
	@param integer : le numero de la serie
	@return integer : resultat requete
*/
function del_serie_aleatoire_old($serie){
	$sql="delete from serie_aleatoire where num_serie=$serie";
	$del=pg_query($sql);
	$sql="delete from serie_exo where id=$serie";
	$del=pg_query($sql);
	return $del;
}
/**
	Supprimer une serie aleatoire 
	@param integer : le numero de la serie
	@return integer : resultat requete
*/
function del_serie_aleatoire($serie){
	if(VERSION_BASE>VERSION){
		$res=del_etape($serie);
	}
	else
		$res=del_serie_aleatoire_old($serie);
	return $res;
}

/**
	Obtenir la configuration d'une serie aleatoire multiserie (OLD)
	@param integer : numero serie
	@return integer : resultat requete
*/
function get_serie_aleatoire_series_associations_old($serie){
	$sql="select num_serie,serie,nbexo_par_type from serie_aleatoire where num_serie=$serie and mode=1";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
 /**
	Obtenir la configuration d'une serie aleatoire multiserie
	@param integer : numero serie
	@return integer : resultat requete
*/
function get_serie_aleatoire_series_associations($serie){
	 if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_serie_aleatoire_series_associations($serie) as (serie int4,serie_source int4,nb_evaluation int4,type_evaluations int4)";
		$res=pg_query($sql);
	 }
	 else
		$res=get_serie_aleatoire_series_associations_old($serie);
	 return $res;
}

/**
	Obtenir la configuration d'une serie aleatoire multitheme (OLD)
	@param integer : numero serie
	@return integer : resultat requete
*/
function get_serie_aleatoire_themes_associations_old($serie){
	$sql="select num_serie,theme,nbexo_par_type from serie_aleatoire where num_serie=$serie and mode=2";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
 /**
	Obtenir la configuration d'une serie aleatoire multitheme
	@param integer : numero serie
	@return integer : resultat requete
*/
function get_serie_aleatoire_themes_associations($serie){
	 if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_serie_aleatoire_themes_associations($serie) as (serie int4,serie_source int4,nb_evaluation int4,type_evaluations int4)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	 }
	 else
		$res=get_serie_aleatoire_themes_associations_old($serie);
	 return $res;
}

/**
	Supprimer la configuration d'une serie aleatoire multiserie ou multitheme (OLD)
	@param integer : le numero de la serie
	@param integer : le numero du mode
	@return integer : resultat requete
*/
function del_serie_aleatoire_configuration_old($serie,$mode){
	$sql="delete from serie_aleatoire where num_serie=$serie";
	return pg_query($sql);
}
/**
	Supprimer la configuration d'une serie aleatoire multiserie ou multitheme 
	@param integer : le numero de la serie
	@param integer : le numero du mode
	@return integer : resultat requete
*/
function del_serie_aleatoire_configuration($serie,$mode){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_serie_aleatoire_configuration($serie,$mode)";
		//echo "sql=$sql<br>";
		return pg_query($sql);
	}
	else
		return del_serie_aleatoire_configuration_old($serie,$mode);
}

/**
	Enregistrer la configuration pour une serie aleatoire multiserie 
	@param string : les donn�es � ins�rer
	@return integer : resultat requete
*/	
function set_serie_aleatoire_multiserie_configuration($serie,$chaine){
	$sql="select * from contraintes.af_set_serie_aleatoire_multiserie_configuration($serie,$chaine)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Enregistrer la configuration pour une serie aleatoire multitheme
	@param string : les donn�es � ins�rer
	@return integer : resultat requete
*/	
function set_serie_aleatoire_multitheme_configuration($serie,$chaine){
	$sql="select * from contraintes.af_set_serie_aleatoire_multitheme_configuration($serie,$chaine)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Obtenir les series aleatoires pour un type  (OLD)
	@param integer : numero type
	@return integer : resultat requete
*/
function get_series_aleatoires_type_old($type){
	$sql="select id,titre,lower(titre) as ordre from serie_exo where id in 
				(select distinct num_serie from serie_aleatoire where mode=$type) order by ordre";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Obtenir les series aleatoires pour un type  
	@param integer : numero type
	@return integer : resultat requete
*/
function get_series_aleatoires_type($type){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_series_aleatoires_type($type) as (id int4,libelle varchar)";
		return pg_query($sql);
	}
	else
		$res=get_series_aleatoires_type_old($type);
	return $res;
}


/**
	Obtenit les themes d'une serie aleatoire multitheme (OLD)
	@param integer : numero de la serie
	@return integer : resultat requete
*/
function get_serie_aleatoire_multitheme_themes_old($serie){
	$sql="select num_themedir,nom_theme,lower(nom_theme) as ordre from themedir where num_themedir in 
				(select theme from serie_aleatoire where num_serie=$serie) order by ordre";
	return pg_query($sql);
}
/**
	Obtenit les themes d'une serie aleatoire multitheme 
	@param integer : numero de la serie
	@return integer : resultat requete
*/
function get_serie_aleatoire_multitheme_themes($serie){
	if(VERSION_BASE>VERSION){
		
		return get_categorie_element_themes(19,$serie);
	}
	else
		$res=get_serie_aleatoire_multitheme_themes_old($serie);
	return $res;
}

/**
	V�rifie si une serie existante est configuree en mode aleatoire (OLD)
	@param integer : serie
	@param integer : formation
	@param integer : parcours
	@return integer : res req
*/
function is_serie_aleatoire_melangee_old($serie,$formation,$parcours){
	$sql="select count(*)  from gestserie where num_serie=$serie and num_cal=$formation";
	$res=pg_query($sql);
	if( pg_fetch_result($res,0)==0)
		return 'f';
	return 't';
}
/**
	V�rifie si une serie existante est configuree en mode aleatoire 
	@param integer : serie
	@param integer : formation
	@param integer : parcours
	@return integer : res req
*/
function is_serie_aleatoire_melangee($serie,$formation,$parcours){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_is_serie_aleatoire_melangee($serie,$formation,$parcours)";
//		echo "$sql<br>";
		$res=pg_fetch_result(pg_query($sql),0,0);
	}
	else
		$res=is_serie_aleatoire_melangee_old($serie,$formation,$parcours);
	return $res=='t';
}

/**
	Enregistre une serie existante en mode aleatoire (OLD)
	@param integer : serie
	@param integer : formation
	@param integer : parcours
	@return integer : res req
*/
function set_serie_aleatoire_melangee_old($serie,$formation,$parcours){
	$sql="insert into gestserie values($serie,$formation,'t',0,0)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Enregistre une serie existante en mode aleatoire
	@param integer : serie
	@param integer : formation
	@param integer : parcours
	@return integer : res req
*/
function set_serie_aleatoire_melangee($serie,$formation,$parcours){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_serie_aleatoire_melangee($serie,$formation,$parcours)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=set_serie_aleatoire_melangee_old($serie,$formation,$parcours);
	return $res;
}

/**
	Supprime le mode aleatoire pour une serie existante (OLD)
	@param integer : serie
	@param integer : formation
	@param integer : parcours
	@return integer : res req
*/
function del_serie_aleatoire_melangee_old($serie,$formation,$parcours){
	$sql="delete from gestserie where num_serie=$serie and num_cal=$formation and aleatoire='t'";
	return pg_query($sql);
}
/**
	Supprime le mode aleatoire pour une serie existante 
	@param integer : serie
	@param integer : formation
	@param integer : parcours
	@return integer : res req
*/
function del_serie_aleatoire_melangee($serie,$formation,$parcours){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_serie_aleatoire_melangee($serie,$formation,$parcours)";
		$res=pg_query($sql);
	}
	else
		$res=del_serie_aleatoire_melangee_old($serie,$formation,$parcours);
	return $res;
}

/**
*   Obtenir les evaluations d'une serie aleatoire. 
*
*   @param integer $serie le numero de la serie
*   @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, type int4 )
*/
function get_serie_aleatoire_evaluations($formation,$parcours,$individu,$serie) {
	//if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_serie_aleatoire_evaluations($serie,$formation,$parcours,$individu) AS (id int4, libelle varchar, serie int4, pere int4, type int4 )";                                                                            
		//echo "$sql<br>";
		$res = pg_query($sql);
	/*
	} 
	else
		$res = get_serie_evaluations_old($serie);
	*/
	return $res;
} 


/**
*   Obtenir les evaluations d'une serie aleatoire. 
*
*   @param integer $serie le numero de la serie
*   @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4,type int4 )
*/
function get_serie_aleatoire_multiserie_evaluations($formation,$parcours,$individu,$serie) {
	//if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_serie_aleatoire_multiserie_evaluations($serie,$formation,$parcours,$individu) AS (id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4,type int4 )";                                                                            
		//echo "$sql<br>";
		$res = pg_query($sql);
	/*
	} 
	else
		$res = get_serie_evaluations_old($serie);
	*/
	return $res;
}


/**
*   Obtenir les evaluations d'une serie aleatoire. 
*
*   @param integer $serie le numero de la serie
*   @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4,type int4 )
*/
function get_serie_aleatoire_multiserie_evaluation($formation,$parcours,$individu,$serie,$evaluation) {
	//if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_serie_aleatoire_multiserie_evaluation($serie,$formation,$parcours,$individu,$evaluation) AS (id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4,type int4 )";                                                                            
		//echo "$sql<br>";
		$res = pg_query($sql);
	/*
	} 
	else
		$res = get_serie_evaluations_old($serie);
	*/
	return $res;
}

/**
*  Remplir la table serie_aleatoire_evaluations pour une serie aleatoire multiserie
* @param integer : serie
* @param integer : formation
* @param integer : parcours
* @param integer : individu
*/
function set_serie_aleatoire_multiserie_evaluations($serie,$formation,$parcours,$individu){
	// recup configuration
	//$res=get_serie_aleatoire_series_associations($serie);
	$sql="select * from contraintes.af_set_serie_aleatoire_multiserie_evaluations($serie,$formation,$parcours,$individu)";
	//echo "sql=$sql<br>";
	$res=pg_query($sql);
	return pg_fetch_result($res,0,0)=='t';;

}

/**
*  Remplir la table serie_aleatoire_evaluations pour une serie aleatoire multitheme
* @param integer : serie
* @param integer : formation
* @param integer : parcours
* @param integer : individu
*/
function set_serie_aleatoire_multitheme_evaluations($serie,$formation,$parcours,$individu){
	// recup configuration
	//$res=get_serie_aleatoire_series_associations($serie);
	$sql="select * from contraintes.af_set_serie_aleatoire_multitheme_evaluations($serie,$formation,$parcours,$individu)";
	//echo "sql=$sql<br>";
	$res=pg_query($sql);
	return pg_fetch_result($res,0,0)=='t';;

}

/**
*  Remplir la table serie_aleatoire_evaluations pour une serie aleatoire melangee
* @param integer : serie
* @param integer : formation
* @param integer : parcours
* @param integer : individu
*/
function set_serie_aleatoire_melangee_evaluations($serie,$formation,$parcours,$individu){
	// recup configuration
	//$res=get_serie_aleatoire_series_associations($serie);
	$sql="select * from contraintes.af_set_serie_aleatoire_melangee_evaluations($serie,$formation,$parcours,$individu)";
	//echo "sql=$sql<br>";
	$res=pg_query($sql);
	return pg_fetch_result($res,0,0)=='t';;

}

/**
	Obtenir la somme des chronos des �valuations d'une serie
	@param integer : le numero de la serie
	@return integer : la dur�e totale des chrono en secondes
*/
function get_serie_aleatoire_multiserie_somme_chronos($formation,$parcours,$individu,$serie){
	 if(VERSION_BASE>VERSION){
		$sql="SELECT * FROM contraintes.af_get_serie_aleatoire_multiserie_somme_chronos($serie,$formation,$parcours,$individu)";
//		echo "$sql<br>";
		$res=pg_query($sql);
    }
    return $res;
}

function get_serie_aleatoire_multiserie_somme_points($formation,$parcours,$individu,$serie){
	 if(VERSION_BASE>VERSION){
		$sql="SELECT * FROM contraintes.af_get_serie_aleatoire_multiserie_somme_points($serie,$formation,$parcours,$individu)";
//		echo "$sql<br>";
		$res=pg_query($sql);
    }
    return $res;
}

?>