<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Fonctions series bloquantes
	@package serie_bloquante
	@modulegroup fonctions
*/

/**
 * Obtenir les actions autorises sur une srie.
 * 2: la serie est deja configure
 * 1: elle est configurable 
 * 0: elle n'est pas configurable
 * 
 * @param integer identifiant de la srie
 * @param integer le code de retour de l'action
 */
function get_serie_bloquante_actions($serie,$formation,$parcours){
	//initialisation , tout est permis
    $action=0;
	// test si la serie est deja configure
	if(check_serie_bloquante_configuree($serie,$formation,$parcours)=='t'){
		$action=2;
		// test si la serie  deja des resultats
		//echo "serie=$serie et form=$formation et parc=$parcours<br>";
		/*
		$res=get_etape_resultats($serie);
		if( (pg_num_rows($res)>0) && pg_fetch_result($res,0,0) ){
    	//rien n'est permis
    	$action_serie=0;
    	}
    	*/
	}
		
	else{
		// test si la serie est configurable en mode bloquant
		// recup des evaluation de la serie
		$res=get_serie_evaluations($serie);
		$nb=pg_num_rows($res);
		$tab_eval=array('q','f','m',1,3,4);
		for($i=0;$i<$nb;$i++){
			$row=pg_fetch_row($res,$i);
			//print_r($row);
			if(in_array($row[8],$tab_eval)){
				$action=1;
				break;
			}
		}
	}
	return $action;
}

?>
