<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/



/**
      @package serie_bloquante
      @modulegroup plpgsql
      @module plpgsql_serie_bloquante
*/

/**
	Test si une serie est deja configuree en mode bloquant (OLD)
	@param integer : serie
	@param integer : formation
	@param integer : parcours
	@return bool : true si configuree,false sinon
*/
function check_serie_bloquante_configuree_old($serie,$formation,$parcours){
	$sql="select count(*)  from serie_bloquante where num_serie=$serie and num_cal=$formation";
	$res=pg_query($sql);
	if( pg_fetch_result($res,0)==0)
		return 'f';
	return 't';
}
/**
	Test si une serie est deja configuree en mode bloquant 
	@param integer : serie
	@param integer : formation
	@param integer : parcours
	@return bool : true si configuree,false sinon
*/
function check_serie_bloquante_configuree($serie,$formation,$parcours){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_is_serie_bloquante_configuree($serie,$formation,$parcours)";
		//echo "sql=$sql<br>";
		$res=sql2Bool(pg_fetch_result(pg_query($sql),0,0));
	}
	else
		$res=check_serie_bloquante_configuree_old($serie,$formation,$parcours);
	return $res;
}

/**
	Obtenir la configuation d'une serie bloquante (OLD)
	
	@param integer $serie serie
	@param integer $formation formation
	@param integer $parcours parcours
	@return integer Resultat de la requete (serie int4,formation int4,parcours int4,seuil int4,etape_retour int4,tentatives int4,correction bool,blocage_parcours bool)
*/
function get_serie_bloquante_configuration_old($serie,$formation,$parcours){
	$sql="select distinct num_serie,num_cal,$parcours,seuil,etape_retour,tentative,correction,blocage_parcours from serie_bloquante where num_cal=$formation and num_serie=$serie";
	
	return pg_query($sql);
}

/**
	Obtenir la configuation d'une serie bloquante 
	
	@param integer $serie serie
	@param integer $formation formation
	@param integer $parcours parcours
	@return integer Resultat de la requete (serie int4,formation int4,parcours int4,seuil int4,etape_retour int4,tentatives int4,correction bool,blocage_parcours bool)
*/
function get_serie_bloquante_configuration($serie,$formation,$parcours){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_serie_bloquante_configuration( $serie,$formation,$parcours) 
					as (serie int4,formation int4,parcours int4,seuil int4,etape_retour int4,tentatives int4,correction bool,blocage_parcours bool)";
		//echo "$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=get_serie_bloquante_configuration_old($serie,$formation,$parcours);
	return $res;
}

/**
	Enregistre la configuration d'une serie bloquante (OLD)
	@param integer : serie
	@param integer : formation
	@param integer : parcours
	@param integer : seuil
	@param integer : etape retour
	@param integer : tentatives
	@param bool : correction
	@param bool : blocage parcours
	@return integer : res req
*/
function set_serie_bloquante_configuration_old($serie,$formation,$parcours,$seuil,$etape_retour,$tentative,$correction,$blocage_parcours){
	$sql="insert into serie_bloquante(num_cal,num_serie,seuil,etape_retour,tentative,correction,blocage_parcours) 
				values($formation,$serie,$seuil,$etape_retour,$tentative,'$correction','$blocage_parcours')";
	return pg_query($sql);
}
/**
	Enregistre la configuration d'une serie bloquante 
	@param integer : serie
	@param integer : formation
	@param integer : parcours
	@param integer : seuil
	@param integer : etape retour
	@param integer : tentatives
	@param bool : correction
	@param bool : blocage parcours
	@return integer : res req
*/
function set_serie_bloquante_configuration($serie,$formation,$parcours,$seuil,$etape_retour,$tentative,$correction,$blocage_parcours){
	 if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_set_serie_bloquante_configuration($serie,$formation,$parcours,$seuil,$etape_retour,$tentative,$correction,$blocage_parcours)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	 }
	 else
		$res=set_serie_bloquante_configuration_old($serie,$formation,$parcours,$seuil,$etape_retour,$tentative,$correction,$blocage_parcours);
	 return $res;
}

/**
	Met  jour la configuration d'une serie bloquante (OLD)
	@param integer : serie
	@param integer : formation
	@param integer : parcours
	@param integer : seuil
	@param integer : etape retour
	@param integer : tentatives
	@param bool : correction
	@param bool : blocage parcours
	@return integer : res req
*/
function maj_serie_bloquante_configuration_old($serie,$formation,$parcours,$seuil,$etape_retour,$tentative,$correction,$blocage_parcours){
	// recup num_etape de etape retour
	$sql="select num_etape from gestparcours where g_num_parcours=$parcours and attach_fic='$etape_retour'";
	$res=pg_query($sql);
	$etape_retour =pg_fetch_result($res,0,0);
	$sql="update serie_bloquante 
				set seuil=$seuil,etape_retour='$etape_retour',tentative=$tentative,correction='$correction',blocage_parcours='$blocage_parcours' 
				where num_cal=$formation and num_serie=$serie";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Met  jour la configuration d'une serie bloquante 
	@param integer : serie
	@param integer : formation
	@param integer : parcours
	@param integer : seuil
	@param integer : tentatives
	@param integer : etape retour
	@param bool : correction
	@param bool : blocage parcours
	@return integer : res req
*/
function maj_serie_bloquante_configuration($serie,$formation,$parcours,$seuil,$etape_retour,$tentative,$correction,$blocage_parcours){
	 if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_maj_serie_bloquante_configuration($serie,$formation,$parcours,$seuil,$etape_retour,$tentative,$correction,$blocage_parcours)";
		$res=pg_query($sql);
	 }
	 else
		$res=maj_serie_bloquante_configuration_old($serie,$formation,$parcours,$seuil,$etape_retour,$tentative,$correction,$blocage_parcours);
	 return $res;
}

/**
	Supprime la configuration d'une serie bloquante (OLD)
	@param integer : serie
	@param integer : formation
	@param integer : parcours
	@return integer : res req
*/
function del_serie_bloquante_configuration_old($serie,$formation,$parcours){
	$sql="delete from serie_bloquante where num_cal=$formation and num_serie=$serie";
	return pg_query($sql);
}
 /**
	Supprime la configuration d'une serie bloquante 
	@param integer : serie
	@param integer : formation
	@param integer : parcours
	@return integer : res req
*/
function del_serie_bloquante_configuration($serie,$formation,$parcours){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_del_serie_bloquante_configuration($serie,$formation,$parcours)";
		$res=pg_query($sql);
	}
	else
		$res=del_serie_bloquante_configuration_old($serie,$formation,$parcours);
	return $res;
}

/**
	Obtenir le nb de tentative effectu�e pour un identifiant de resultat
	@param integer : id resultat
	@return integer : le nb de tentative
*/
function get_serie_bloquante_tentative($formation, $individu, $parcours,$etape ){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_serie_bloquante_tentative($formation, $individu, $parcours,$etape) AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval, tentative int4)";
		//echo "$req<br>";
        $res=pg_query($req);
    }
    return $res;
}

?>