<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

class SerieGeneree extends SerieAleatoire{
	

	function SerieGeneree($id, $formation=0,$parcours=0,$individu=0 ,$libelle="Etape Serie Generee", $date_creation="",$bareme=0,$chrono=0){
		if(func_num_args()==4){
			parent::SerieAleatoire($id,$formation,$parcours,$individu);
		}else{
			
		}
		parent::SerieAleatoire($id,$formation,$parcours,$individu, $libelle, $date_creation,$bareme,$chrono);
	}

//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------
	
	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * Ne vrifie rien.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verify(&$message){
		
		return true;
	}

//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------	

	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		$res_parent=parent::verifyInsert(&$message);
		$verif=SerieGeneree::verify(&$message);
		return $verif && $res_parent && true;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		$res_parent=parent::verifyUpdate(&$message);
		$verif=SerieGeneree::verify(&$message);
		return $verif && $res_parent && true;
	}

	/**
	* Fonction qui insre un enregistrement du positionnement en base.
	* On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne false
	* @return integer  identifiant de l'enregistrement cr ou false
	*/
	function insertToDB($theme,&$message){
		if(SerieGeneree::verifyInsert(&$message)){
			$this->id=set_serie_aleatoire(addslashes($this->libelle), $theme,int2Sql($this->bareme), int2Sql($this->chrono),TYPE_SERIE_ALEATOIRE_GENEREE);
			return $this->id;
		}
	}
}
?>