<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoSondage.
 * Un DoSondage sert  grer l'avancement des Evaluations de type Sondage.
 * 
 * @package sondage
 */
class DoSondage extends DoQuestionReponse{
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param integer $resultat identifiant rsultat associ au Sondage (identifiant rsultat de la Srie par exemple)
	 * @param integer $evaluation identifiant du Sondage
	 * @param integer $indice Indice de l'valuation.
	 * @param object EvaluationFactory &$obj_EvaluationFactory Fabrique servant  la cration des objets associs  l'avancement
	 */		
	function DoSondage($resultat,$evaluation,$indice,&$obj_EvaluationFactory){
		parent::DoQuestionReponse($resultat,$evaluation,TYPE_EVALUATION_SONDAGE,$indice,$obj_EvaluationFactory);
	}
	
	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	/**
	 * Obtenir le Sondage associ  l'objet d'avancement
	 * @return object Sondage  Le Sondage
	 */	
	function &getSondage(){
		return parent::getQuestionReponse();
	}
	
	/**
	 * Traitement des donnes du formulaire soumis par le Stagiaire.
	 * @param array $valeurs_soumises Le $HTTP_POST_VARS du fomulaire
	 */
	function validerFormulaire($valeurs_soumises){
		$cle_nom="choixreponse";
		$src_nom="reponse";
		
		$choix_valides=array();
		while(list($cle,$val)=each($valeurs_soumises)){
			//enregistre une rponse saisie
	        if(substr($cle, 0, strlen($cle_nom))==$cle_nom){
				$v=substr($cle, strlen($cle_nom)+1, strlen($cle));
				$this->obj_resultat->init($v,$val, 1);
				$choix_valides[]=$val;
	        }
	        //enregistre une rponse non saisie
	        elseif((substr($cle, 0, strlen($src_nom))==$src_nom) && !in_array(substr($cle, strlen($src_nom)+1, strlen($cle)),$choix_valides)){
				$v=substr($cle, strlen($src_nom)+1, strlen($cle));
				$this->obj_resultat->init($val,$v, 0);
				$choix_valides[]=$v;
	        }
	    }
	}
}
?>
