<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe Sondage.
 *	Un Sondage est un objet driv de QuestionReponse. 
 *	Il correspond  l'association d'une Question et de plusieurs rponses.
 *
 *	@package sondage
 */
class Sondage extends QuestionReponse{

	/**
	 * Construit un Sondage.
	 * Le Sondage peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant du Sondage
	 * @param string $libelle Libell
	 * @param string $date_creation date de cration (format SQL)
	 * @param boolean $radio indique si le Sondage doit tre affich sous forme de radio(true) ou de checkbox(false)
	 */		
	function Sondage($id, $libelle="Sondage", $date_creation="",$radio=true){
		messageDebug("Sondage::Sondage($id, $libelle, $date_creation,$radio)");
		if(func_num_args()==1){
			$res_evaluation = get_sondage($id);
			$row_evaluation=pg_fetch_row($res_evaluation,0);
			$libelle=$row_evaluation[1];
			$date_creation=$row_evaluation[3];
			$radio=sql2Bool($row_evaluation[4]);
		}else{
		}
		parent::QuestionReponse($id, $libelle, TYPE_EVALUATION_SONDAGE, $date_creation,$radio);
	}

//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------

	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		
		$res_parent=parent::verifyInsert(&$message);
		$verif=$this->verify(&$message);
		
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		
		$res_parent=parent::verifyUpdate(&$message);
		$verif=$this->verify(&$message);
		
		return $res_parent && $verif && true;
	}
	
	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * Le nombre de questions doit tre gal  1, le champ radio doit tre  'f' 
	 * et le type  TYPE_EVALUATION_SONDAGE.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verify(&$message){
		$attributs_ok=true;				
		if(count($this->questions)!=1){
			$message.="[questions]";
			$attributs_ok=false;
		}
		if($this->radio!='t'){
			$message.="[radio]";
			$attributs_ok=false;
		}
		if($this->type!=TYPE_EVALUATION_SONDAGE){
			$message.="[type]";
			$attributs_ok=false;
		}
		return $attributs_ok;
	}

	/**
	* Fonction qui insre le Sondage en base.
	* Affecte l'identifiant du Sondage.
	* @param integer $theme Identifiant du Theme dans lequel on enregistre le Sondage
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return integer Identifiant du Sondage cr ou false
	*/
	function insertToDB($theme, &$message) {
		
		if(empty($theme)){
			die("Erreur Qcm::insertToDB($theme, &$message=\"\"): Le thme est maquant.");
		}
	
		if($this->verifyInsert(&$message)){
			$this->id=set_sondage(addslashes($this->libelle), $this->questions,$this->reponses,$theme);
			return $this->id;
		}
		else{
			return false;
		}
	}
	
	/**
	* Fonction qui met a jour le Sondage en base.
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return boolean true si la mise  jour  t effectue, false sinon
	*/
	function updateToDB(&$message) {
		if($this->verifyUpdate(&$message)){
			return maj_sondage($this->id,addslashes($this->libelle), addslashes($this->question_commune), $this->radio);
		}else{
			return false;
		}
	}
	
	/**
	 * Obtenir le nom des attributs requis pour la creation d'un QCM.
	 * @return array Noms des attributs.
	 */
	function getRequiredVars(){
		return Array("libelle_sondage", "theme_sondage"); 
	}
	
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attibut peu avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		switch($var_name){
			case "juste_reponse":
				return Array(true, false);
			default:
				return null;
		}
	}	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
		
	/**
	 * Obtenir l'icone associe aux Qcm.
	 * @return string URL de l'icone.
	 */	
	function getIcone(){
		global $serverback;
		return "http://$serverback/images/txt.gif";
	}

	/**
	 * Obtenir l'icone associe au type Qcm.
	 * @return string URL de l'icone.
	 */		
	function getIconeType(){
		return get_evaluation_type_icone($this->type);
	}
	
	function isNotable(){
		return false;
	}
}
?>