<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package sondage
 * @modulegroup plpgsql
 * @module plpgsql_sondage
 */

/**
    Enregistre une question/reponse de sondage (OLD)
    @param string : le libelle du sondage //inutilis dans le old
    @param integer : le numro de question
    @param integer : le numro de rponse


    @param integer : le numero de mdia rponse

    @param integer : largeur media rponse
    @param integer : hauteur media rponse
    @param integer : ordre (pour les rponses)
    @return integer : 1
*/
function set_sondage_deprecated_old($question, $reponse,  $rmedia,$rlargeur, $rhauteur, $ordre) {
	$sql = "insert into proposition_sondage(num_sondage,num_proposition,pmedia,plargeur,phauteur,ordre)
	            values($question,$reponse,$rmedia,$rlargeur,$rhauteur,$ordre)";
	//echo "sql=$sql<br>";
	$ins = pg_query($sql);
	return $ins;
}
/**
    Enregistre une question/reponse de qcm
    @param string : le libelle du qcm
    @param integer : le numro de question
    @param integer : le numro de rponse


    @param integer : le numero de mdia rponse


    @param integer : largeur media rponse
    @param integer : hauteur media rponse
    @param integer : ordre (pour les rponses)
    @return integer : 1
*/
function set_sondage_deprecated($libelle,$question,$reponse,$qmedia,$rmedia,$qlargeur,$qhauteur,$rlargeur,$rhauteur,$ordre,$theme,$typesondage){
	global $id_categorie_sondage;
    if (VERSION_BASE > VERSION) {
        //creation du qcm
        if($ordre=='NULL'){
			$id_sondage=set_evaluation($libelle,2);
			$res1=set_question_reponse_deprecated($id_sondage,2,$typesondage);
			// enregistre dans theme_categorie
			set_categorie_element_theme($id_categorie_sondage,$theme,$id_sondage);
		}
		else{
			// determine l'existence du sondage avec le numero de question (couple evaluation / question ==> UNIQUE)
			$sondages=get_question_reponse_element_evaluations($question);
			$id_sondage=pg_fetch_result($sondages,0,0);
		}
		// enregistre l'association
		$res1b=set_question_reponse_association_element($id_sondage,$question,$reponse,$ordre);
		
		// creation du media pour la question (on ne le fait que pour la premiere reponse)
		if($qmedia!='NULL' && $ordre=='NULL'){
			$res3=set_question_reponse_element_media($id_sondage,$question,$qmedia,$qhauteur,$qlargeur);
		}
		
		// creation du media pour la reponse
		if($rmedia!='NULL'){
			$res3=set_question_reponse_element_media($id_sondage,$reponse,$rmedia,$rhauteur,$rlargeur);
		}
		
		return $id_sondage;
	}
	else
		$res = set_sondage_deprecated_old($question, $reponse, $rmedia, $rlargeur, $rhauteur, $ordre);
    return $res;
}

/**
       Obtenir les numeros de proposition et le libell d'un sondage donn (OLD)

	Les informations obtenues sont:
	num_proposition | libelle_prop

      @param integer: identifiant en base du sondage
*/
function get_sondage_propositions_old($sondage)
{
    $req="select num_proposition,libelle_prop from proposition , proposition_sondage
               where num_sondage=$sondage and num_proposition=num_prop";
    $res=pg_query($req);
    return $res ;
}

/**
       Obtenir les numeros de proposition et le libell d'un sondage donn

	Les informations obtenues sont:
	num_proposition | libelle_prop

      @param integer: identifiant en base du sondage
      @return interger: resultat de la requete :(question_reponse int4, question int4, reponse int4, pere int4)
*/
function get_sondage_propositions($sondage)
{
    if(VERSION_BASE>VERSION)
    {
           //return get_question_reponse_association_elements($sondage);
           
           // recup le numero d'valuation
			$evaluations=get_question_reponse_element_evaluations($sondage);
			if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondage,ce qui n'est pas permis dans la version actuelle de la plate-forme");
	
			$evaluation=pg_fetch_result($evaluations,0,0);
			
			//$evaluation=$sondage;
			$sql="select * from contraintes.af_get_sondage_propositions($evaluation) as (question_reponse int4,question int4,reponse int4)";
			//echo "sql=$sql<br>";
			return pg_query($sql);
    }
    else
            $res=get_sondage_propositions_old($sondage);

    return $res ;
}


/**
    Obtenir les infos des propositions d'un sondage donn (OLD)

	Les informations obtenues sont:
	num_proposition | libelle_prop

      @param integer: identifiant en base du sondage
*/
function get_sondage_propositions_infos_old($sondage)
{
    $req="select distinct  num_proposition,libelle_prop, inter_html, 's', 'TRUE' from proposition , proposition_sondage
               where num_sondage=$sondage and num_proposition=num_prop";
    //echo $req;
    $res=pg_query($req);
    return $res ;
}

/**
    Obtenir les infos des propositions d'un sondage

    @param integer : le numro du sondage
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_sondage_propositions_infos($sondage) {
	if (VERSION_BASE > VERSION) {
		return get_question_reponse_elements_infos($sondage, 2, 'TRUE');
	} else
		return get_sondage_propositions_infos_old($sondage);
}

/**
       Obtenir le nombre de rponses  une proposition d'un sondage dans une formation (OLD)

	Les informations obtenues sont:
	count(*)

      @param integer: identifiant en base de la serie
      @param integer: identifiant en base de la proposition
      @param integer: identifiant en base de la formation
*/
function get_sondage_nbreponses_formation_old($serie,$proposition,$formation)
{
    $req="select count(*) from res_serie_exo where id_serie='$serie' and id_formation='$formation' and reponse='$proposition'";
    $res=pg_query($req);
    return $res ;
}

/**
       Obtenir le nombre de rponses  une propositon d'un sondage dans une formation
       pour un utilisateur donn (le nombre sera gal  0 ou 1) (OLD)

	Les informations obtenues sont:
	count(*)

      @param integer: identifiant en base de la serie
      @param integer: identifiant en base de la proposition
      @param integer: identifiant en base de la formation
      @param integer: identifiant en base du stagiaire
*/
function get_sondage_nbreponses_stagiaire_old($serie,$proposition,$formation,$stagiaire)
{
    $req="select count(*) from res_serie_exo where id_serie='$serie' and id_formation='$formation' and reponse='$proposition' and id_stag='$stagiaire'";
    $res=pg_query($req);
    return $res ;
}

/**
    Obtenir les infos d'un sondage (OLD)

        @param integer : le numero de la question

        @return integer : le resultat de la requete
*/
function get_sondage_infos_old($question){
    $sql="select * from proposition_sondage where num_sondage=$question";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos d'un sondage

        @param integer : le numero de la question
        @param integer : le numero de sondage
        @return integer : le resultat de la requete
*/
function get_sondage_infos($question,$id_sondage=0){
    if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_get_question_sondage_reponses($question,$id_sondage) as (id_question int4,id_reponse int4)";
        $res=pg_query($sql);
    }
    else
        $res=get_sondage_infos_old($question);
    return $res;
}

/**
	Enregistre une nouvelle question de sondage (OLD)
	
	@param string : le libelle de la question
    
    @param integer : le numro du theme
    @param integr : le numero de media
    @param integer : la largeur
    @param integer ; la hauteur
    @param char : le type de sondage
    @param bool : interpretation html
    @return integer : le numro de la nouvelle question
*/
function set_sondage_question_old($libelle, $theme,$media,$largeur,$hauteur,$typesondage,$inter_html){
	$sql="insert into question_sondage (question,theme,qmedia,largeur,hauteur,type_sondage,inter_html)
                values('$libelle',$theme,$media,$largeur,$hauteur,'$typesondage','$inter_html');";
	//echo "sql=$sql<br>";
        $ins=pg_query($sql);
        $oid=pg_getlastoid($ins);
        $sql="select num_sondage from question_sondage where oid=$oid";
        $res=pg_query($sql);
        $row=pg_fetch_row($res,0);
        return $row[0];
    
}
/**
	Enregistre une nouvelle question de sondage 
	
	@param string : le libelle de la question
    
    @param integer : le numro du theme
    @param integr : le numero de media
    @param integer : la largeur
    @param integer ; la hauteur
    @param char : le type de sondage
    @param bool : interpretation html
    @return integer : le numro de la nouvelle question
*/
function set_sondage_question($libelle, $theme,$media,$largeur,$hauteur,$typesondage,$inter_html){
	if(VERSION_BASE>VERSION){
		$res=set_question_sondage($libelle, $theme,$media,$largeur,$hauteur,$typesondage,$inter_html);
		return $res;
	}
	else
		return set_sondage_question_old($libelle,$theme,$media,$largeur,$hauteur,$typesondage,$inter_html);
}

/**
	Enregistre une nouvelle proposition de sondage (OLD)
	
	@param string : le libelle de la proposition
    @param bool: intepretation html? 
    @param integer : le numro du theme
    @return integer : le numro de la nouvelle proposition
*/
function set_sondage_proposition_old($libelle,$html, $theme){
	 $sql="insert into proposition (libelle_prop,theme) values('$libelle','$theme');";
        $ins=pg_query($sql);
        $oid=pg_getlastoid($ins);
        $sql="select num_prop from proposition where oid=$oid";
        $res=pg_query($sql);
        $row=pg_fetch_row($res,0);
        return $row[0];
}
/**
	Enregistre une nouvelle proposition de sondage 
	
	@param string : le libelle de la proposition
    @param bool: intepretation html? 
    @param integer : le numro du theme
    @return integer : le numro de la nouvelle proposition
*/
function set_sondage_proposition($libelle,$html, $theme){
	if(VERSION_BASE>VERSION){
		$res=set_proposition($libelle,$html, $theme);
		return $res;
	}
	else
		return set_sondage_proposition_old($libelle,$html, $theme);
	
}

/**
	Obtenir les infos d'une question de sondage
	
	@param integer : le numero de sondage
	@return integer : le resultat de la requete (id int4,libelle varchar,interpretation_html bool,type int4,reponse bool)
*/
function get_sondage_question($sondage){
	if(VERSION_BASE>VERSION){
		$questions=get_question_reponse_questions($sondage);
		if(pg_num_rows($questions)>1)
			print("Erreur : Un sondage utilise plusieurs question, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$question=pg_fetch_result($questions,0,0);
		$res=get_question_sondage_question_sondage($question);
	
	}
	else
		$res=get_question_sondage_question_sondage($sondage);
	return $res;
}


 /**
	Supprimer un sondage (OLD)
	@param integer : le numero de la question de sondage
	@return bool : t si suppression OK , f sinon
*/
function del_sondage_old($question){
	$sql="delete from proposition_sondage where num_sondage=$question)";
	$del=pg_query($sql);
	return $del;
}
/**
	Supprimer un sondage 
	@param integer : le numero de la question de sondage
	@return bool : t si suppression OK , f sinon
*/
function del_sondage($question){
	if(VERSION_BASE>VERSION){
		$evaluations=get_question_reponse_element_evaluations($question);
		 // On teste si une association question / sondage est unique
		//  l'avenir ,une question pourra ter utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondages,ce qui n'est pas permis dans la version actuelle de la plateforme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		$res=del_evaluation($evaluation);
	}
	else
		$res=del_sondage_old($question);
	return $res;
}

/**
	Supprime une proposition de question de sondage (OLD)
	@Note : Ne supprime pas la proposition en base
	@param integer : le numero de la question de sondage
	@param integer : le numero de la proposition
	@return bool : t si suppression ok, f sinon
*/
function del_sondage_proposition_old($question,$proposition){
	$sql="delete from proposition_sondage where num_sondage=$question and num_proposition=$proposition";
	$del=pg_query($sql);
	return $del;
}
/**
	Supprime une proposition de question de sondage 
	@Note : Ne supprime pas la proposition en base
	@param integer : le numero de la question de sondage
	@param integer : le numero de la proposition
	@return bool : t si suppression ok, f sinon
*/
function del_sondage_proposition($question,$proposition){
	if(VERSION_BASE>VERSION){
		$evaluations=get_question_reponse_element_evaluations($question);
		 // On teste si une association question / sondage est unique
		//  l'avenir ,une question pourra ter utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondages,ce qui n'est pas permis dans la version actuelle de la plateforme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		return del_question_reponse_association_element($evaluation,$proposition);			
	}
	else
		$res=del_sondage_proposition_old($question,$proposition);
	return $res;
}

/**
	Obtenir les infos d'un sondage  (OLD)
	@param integer : numero du sondage
	@return integer : resultat de la requete (id int4, libelle varchar, type int4, date_creation timestamp, radio bool)
*/
function get_sondage_old($sondage){
	print("get_sondage_old A IMPLEMENTER");
}
 /**
	Obtenir les infos d'un sondage  
	@param integer : numero du sondage
	@return integer : resultat de la requete (id int4, libelle varchar, type int4, date_creation timestamp, radio bool) 
*/
function get_sondage($sondage){
	if(VERSION_BASE>VERSION){
		return get_question_reponse($sondage);
	}

}

/**
    Enregistre un sondage. (OLD)
	@param string $libelle Le libelle du sondage
    @param array $questions Les identifiants de question
    @param array $reponses Les identifiants de question
    @param array $justes Les identifiants de question
    @param integer $theme Identifiant du theme
    @return integer Le numero du nouveau qcm 
*/
function set_sondage_old($libelle, $questions, $reponses,  $theme) {
	//echo "libelle=$libelle et theme=$theme<br>";
	// boucle sur le nb de reponses
	while(list($cle,$rep)=each($reponses)){
		$cle++;
		$res=set_sondage_deprecated_old($questions[0],$rep,'NULL','NULL','NULL',$cle);
	}
	return $questions[0];
}

/**
    Enregistre un sondage.
	@param string $libelle Le libelle du sondage
    @param array $questions Les identifiants de question
    @param array $reponses Les identifiants de question
    @param array $justes Les identifiants de question
    @param integer $theme Identifiant du theme
    @return integer Le numero du nouveau qcm 
*/
function set_sondage($libelle, $questions, $reponses,  $theme) {
//	echo "set_qcm($libelle, $questions, $reponses, $justes, $theme) <br>";
	if (VERSION_BASE > VERSION) {
		$sql_questions=int_array_to_plpgsql_array($questions);
		$sql_reponses=int_array_to_plpgsql_array($reponses);
		$sql_justes = "'{";
		$i = 0;
		$nb_i = count($justes);
		/*
		while ($tab = each($justes)) {
			$sql_justes .= "{" . $tab[1][0] . "," . $tab[1][1] . "}";
			if ($i < $nb_i -1)
				$sql_justes .= ",";
			$i++;
		}
		*/
		$sql_justes .= "}'";
		$sql = "select * from contraintes.af_set_sondage('$libelle', ".TYPE_EVALUATION_SONDAGE.", 'FALSE', $sql_questions, $sql_reponses) ";
		//echo "$sql<br>";
		$res = pg_query($sql);
		$num=pg_fetch_result($res,0,0);
		$res2 = set_categorie_element_theme(27,$theme,$num);
		return $num;
	} 
	else{
		//print ("La fonction set_sondage($libelle, $questions, $reponses,  $theme) n'existe pas pour la version " .VERSION);
		$res=set_sondage_old($libelle,$questions, $reponses,$theme);
		return $questions[0];
		
	}
}

/**
	Obtenir les themes qui ont des sondages
 *
 *	@return integer : le resultat de la requete
*/
/*
function get_plateforme_sondage_themes() {
	
		$sql = "select * from contraintes.af_get_sondage_themes()";
		$res = pg_query($sql);
	
	return $res;
}
*/
?>