<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe Src.
 *	Un Src est un objet driv de Qsrc. 
 *	Il correspond  l'association de plusieurs Questions et de plusieurs Choix.
 *
 *	@package src
 */
class Src extends Qsrc{

	/**
	 * Construit un Src.
	 * Le Src peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant du Src
	 * @param string $libelle Libell
	 * @param integer $type_qsrc Type de Qsrc
	 * @param string $date_creation date de cration (format SQL)
	 * @param boolean $radio true, affiche le Qrc sous forme de radio, false sous la forme de checkbox
	 * @param string $question_commune indique si le Qrc doit tre affich sous forme de radio(true) ou de checkbox(false)
	 * @param integer $bareme identifiant du Bareme
	 * @param integer $chrono Chrono, en secondes
	 * @param integer $media identifiant du Mdia
	 * @param integer $chrono_gen Chrono total, en secondes
	 */	
	function Src($id=null, $libelle="SRC", $type_qsrc=0,$date_creation=null, $radio=true, $question_commune="", $bareme = 0, $chrono = 0, $media = 0, $chrono_gen = 0){	
		messageDebug("Src::Src($id, $libelle, $date_creation, $radio,$question_commune, $bareme, $chrono , $media, $chrono_gen)");
		if($id==0){
			parent::Qsrc(0, $libelle, TYPE_EVALUATION_SRC, $date_creation);
			$this->radio=(bool)$radio;
			$this->question_commune=$question_commune;
			return;
		}elseif(func_num_args()==1){
			$res_evaluation = get_src($id);
			$row_evaluation=pg_fetch_row($res_evaluation,0);
			$libelle=$row_evaluation[1];
			$date_creation=$row_evaluation[4];
			$question_commune=$row_evaluation[2];
			$radio=(bool)sql2Bool($row_evaluation[5]);
		}
		parent::Qsrc($id, $libelle, TYPE_EVALUATION_SRC, $date_creation, $radio,$question_commune, $bareme, $chrono , $media, $chrono_gen);
		$this->initSrc($question_commune);
	}

//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------

	/**
	 * Initialise les attributs propres au Src.
	 * @param string $question_commune Question commune
	 */			
	function initSrc($question_commune){
		return parent::initQsrc($question_commune);
	}

//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------

	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		
		$res_parent=parent::verifyInsert(&$message);
		$verif=$this->verify(&$message);
		
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		
		$res_parent=parent::verifyUpdate(&$message);
		$verif=$this->verify(&$message);
		
		return $res_parent && $verif && true;
	}
	
	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * Le nombre de questions doit tre gal  1, le champ radio doit tre  't' 
	 * et le type  TYPE_EVALUATION_SRC.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verify(&$message){
		$attributs_ok=true;				
		if($this->type!=TYPE_EVALUATION_SRC){
			$message.="[type]";
			$attributs_ok=false;
		}
		return $attributs_ok;
	}
	
	/**
	* Fonction qui insre le Src en base.
	* Affecte l'identifiant du Src.
	* @param integer $theme Identifiant du Theme dans lequel on enregistre le Src
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return integer Identifiant du Src cr ou false
	*/
	function insertToDB($theme,&$message,$no_verify=false) {
		//vrification donnes et insertion
		if($no_verify||Src::verifyInsert(&$message)){
			
			//creation des tableaux de questions et de rponses
			foreach($this->obj_questions as $i => $question){
				$tab_questions[]=$question->getId();
			}
			
			foreach($this->obj_reponses as $i => $reponse){
				$tab_reponses[]=$reponse->getId();
			}
			//cration du SRC
			$this->id=set_src(set_ams_libelle($this->libelle), $this->type,  set_ams_libelle(nl2br2($this->question_commune)),$tab_questions, $tab_reponses, bool2Sql((bool)$this->radio),$theme);
			
			$this->insertMediaToDb(&$message);
			
			return $this->id;
		}
		else{
			return false;
		}
	}	
	
	/**
	* Fonction qui insre le Src en base.
	* Affecte l'identifiant du Src.
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return integer Identifiant du Src cr ou false
	*/
	function updateToDB(&$message,$no_verify=false) {
		//vrification donnes et mise  jour
		if($no_verify||Src::verifyUpdate(&$message)){
			
			//creation des tableaux de questions et de rponses
			foreach($this->obj_questions as $i => $question){
				$tab_questions[]=$question->getId();
			}
			
			foreach($this->obj_reponses as $i => $reponse){
				$tab_reponses[]=$reponse->getId();
			}
			$res_maj=maj_src($this->id,set_ams_libelle($this->libelle), set_ams_libelle(nl2br2($this->question_commune)),$tab_questions, $tab_reponses, bool2Sql((bool)$this->radio));
			
			$this->updateMediaToDB(&$message);
			
			return $this->id;
		}
		else{
			return false;
		}
	}
	
	/**
	 * Obtenir le nom des attributs requis pour la creation d'un QCM.
	 * @return array Noms des attributs.
	 */
	function getRequiredVars(){
		return Array("libelle_src", "theme_src","libelle_question_commune"); 
	}
	
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attibut peu avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		switch($var_name){
			case "juste_reponse":
				return Array(true, false);
			case "interpretationHTML_question":
				return Array(true, false);	
			case "interpretationHTML_reponse":
				return Array(true, false);	
			default:
				return null;
		}
	}		
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	
	/**
	 * Obtenir l'icone associe aux Qcm.
	 * @return string URL de l'icone.
	 */	
	function getIcone(){
		global $serverback;
		return "http://$serverback/images/txt.gif";
	}

	/**
	 * Obtenir l'icone associe au type Qcm.
	 * @return string URL de l'icone.
	 */		
	function getIconeType(){
		return get_evaluation_type_icone($this->type);
	}
	
	function isNotable(){
		return false;
	}
}
?>