<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * 
 * @package src
 * @modulegroup plpgsql
 * @module plpgsql_src
 */
 
/**
 * Obtenir les informations concernant un src.
 * 
 * @param integer le numro du src
 * @return integer le resultat de la requete : (id int4, libelle varchar,  question_commune varchar, type int4, date_creation timestamp)
 */
function get_src($src){
	if (VERSION_BASE > VERSION) {
		return get_qsrc($src);
	} else {
		die(" get_src($src) A implmenter.<br/>");
	}	
}

/**
    Enregistre un src. (OLD)
	@param string $libelle Le libelle du qcm
    @param array $questions Les identifiants de question
    @param array $reponses Les identifiants de question
    @param array $justes Les identifiants de question
    @param integer $theme Identifiant du theme
    @return integer Le numero du nouveau qcm 
*/
function set_src_old($libelle, $type, $question_commune, $questions, $reponses,$radio, $theme) {
	// insertion dans serie_exo
	$id_src=set_serie_old($libelle,$theme,'NULL',-1,0);
	// insertion dans test
	if($radio)
		$type_reponse='r';
	else
		$type_reponse='c';
	$sql="insert into test (id_test, type_test, media_test, longueur_media, largeur_media,chrono,type_reponse,question_commune)
			VALUES ($id_src,'$type',NULL,NULL,NULL, -1,'$type_reponse','$question_commune')";
	//echo "sql=$sql<br>";
	$ins = pg_query($sql) ;
	// association qrc reponses et insertion ds test_rep_nbexogen
	while(list($cle,$rep)=each($reponses)){
		$cle++;
		$sql="insert into asso_test_reponse (id_test, id_reponse, niveau, ordre, num_bareme, media_reponse, longueur_media, largeur_media)
				VALUES ($id_src,$rep,0,$cle,0,NULL,NULL,NULL)" ;
		//echo "sql=$sql<br>";
		$ins=pg_query($sql) ;
		$sql="insert into test_rep_nbexogen(id_test,id_reponse,type_exercice,nb_a_generer,taille_chapeau)
				values($id_qrc,$rep,'q',0,0)";
		$ins=pg_query($sql);
		$sql="insert into test_rep_nbexogen(id_test,id_reponse,type_exercice,nb_a_generer,taille_chapeau)
				values($id_qrc,$rep,'f',0,0)";
		$ins=pg_query($sql);
	}
	// insertion dans quest_rep et asso_exo_serie
	while(list($cle,$quest)=each($questions)){
		$tab_question[0]=$quest;
		$res=set_sondage_old($libelle,$tab_question,$reponses,$theme);
		$ordre=$cle + 1;
		$sql="insert into asso_exo_serie (id_serie, id_exo, type_exo, ordre, point, bareme, chrono, commentaire)
				VALUES ($id_src, $quest, '$type', $ordre, 1, 0,0,'')" ;
		pg_query($sql) ;				
	}
	return $id_src;
}

/**
    Enregistre un src.
	@param string $libelle Le libelle du qcm
    @param array $questions Les identifiants de question
    @param array $reponses Les identifiants de question
    @param array $justes Les identifiants de question
    @param integer $theme Identifiant du theme
    @return integer Le numero du nouveau qcm 
*/
function set_src($libelle, $type, $question_commune, $questions, $reponses,$radio, $theme) {
	if (VERSION_BASE > VERSION) {
		$sql_questions=int_array_to_plpgsql_array($questions);
		$sql_reponses=int_array_to_plpgsql_array($reponses);
		$sql = "select * from contraintes.af_set_src('$libelle', $type,'$question_commune', $radio, $sql_questions, $sql_reponses ) ";
//		echo "$sql<br>";
		$res = pg_query($sql);
		$num=pg_fetch_result($res,0,0);
		$res2 = set_categorie_element_theme(23,$theme,$num);
		return $num;
	} 
	else
		/*
		print ("La fonction set_src($libelle, $type, $question_commune, $questions, $reponses,$radio, $theme) n'existe pas pour la version " .
		VERSION);
		*/
		return set_src_old($libelle, $type, $question_commune, $questions, $reponses,$radio, $theme);
}

/**
    Mise  jour d'un src.
    
    @param integer $src Identifiant du src
	@param string $libelle Le libelle du qcm
	@param string $libelle Question commune du src
    @param array $questions Les identifiants de question
    @param array $reponses Les identifiants de question
    @param boolean $radio Radio ou checkbox
    @return boolean Le rsultat de la fonction
*/
function maj_src($src,$libelle,  $question_commune, $questions, $reponses,$radio) {
	if (VERSION_BASE > VERSION) {
		$sql_questions=int_array_to_plpgsql_array($questions);
		$sql_reponses=int_array_to_plpgsql_array($reponses);
		$sql = "select * from contraintes.af_maj_src($src,'$libelle', '$question_commune', $radio, $sql_questions, $sql_reponses ) ";
//		echo "$sql<br>";
		$res = pg_query($sql);
		return pg_fetch_result($res,0,0)=='t';
	} else
		print ("La fonction maj_src($src,$libelle,  $question_commune, $questions, $reponses,$radio) n'existe pas pour la version " .
		VERSION);
}
?>