<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**

@package stagiaire
@modulegroup plpgsql
@module plpgsql_stagiaire
*/

//////////////////// PENSEZ A RESPECTER LES COMMENTAIRES PHPDOC SVP!!!!!    //////////////////////////////////

/**
* Retourne l'avancement d'un stagiaire pour une formation donne.  (OLD)
*
* @param integer : stagiaire
* @param integer : parcours
*
* @return integer : Retourne l'avancement et l'tape libre
*/
function get_avancement_stagiaire_old($user,$cal)
{

            $req="select avancement,etape_libre from gestionparcours where gp_num_user='$user' and num_cal='$cal'";
            $res=pg_query($req);

            return $res;
}

//////////////////// PENSEZ A RESPECTER LES COMMENTAIRES PHPDOC SVP!!!!!    //////////////////////////////////

/**
*   Retourne l'avancement d'un stagiaire pour une formation donne.
*
*   @param integer :  stagiaire
*   @param integer : parcours
*
*   @return integer :  l'avancement et l'tape libre
*/
function get_avancement_stagiaire($user,$cal)
{
            if(VERSION_BASE>VERSION)
            {
                        $req="select * from _af_get_avancement_stagiaire($user,$cal) as (avancement integer,etape_libre integer)";
                        $res=pg_query($req);
            }
            else
                        $res=get_avancement_stagiaire_old($user,$cal);
            return $res;
}

//////////////////// PENSEZ A RESPECTER LES COMMENTAIRES PHPDOC SVP!!!!!    //////////////////////////////////

/**
*   Affecter l'avancement d'un stagiaire pour une formation donne.   (OLD)
*
*   @param integer : numero du stagiaire
*   @param integer : numero du calendrier
*   @param integer : numero de l'tape ou en est le stagiare
*   @param string : chaine des tapes libres effectues
*
*   @return integer : 0 OK, 1 ERREUR
*/
function set_avancement_stagiaire_old($stagiaire, $groupe, $calendrier, $parcours, $avancement,  $etape_libre, $avancement_libre)
{
            //debug
            //echo "stagiaire=$stagiaire et parc=$parcours et cal=$calendrier<br>";

            $req="   ";
             //  test si le user est dej ds gestionparcours
             $restest=pg_query("
                        select * from gestionparcours
                        where gp_num_groupe='$groupe'
                        and gp_num_user='$stagiaire'
                        and gp_num_parcours='$parcours'
                        and num_cal='$calendrier';
                        ");

             if(pg_numrows($restest)==0){

                        $res=pg_query("insert into gestionparcours values($parcours,$groupe,$stagiaire,0,0,'0','$calendrier');");
             }
             else{
                        $res=pg_query("
					update gestionparcours
							SET 		 avancement=$avancement ,
										etape_libre=$etape_libre ,
										avancement_libre=$avancement_libre
							WHERE		gp_num_groupe=$groupe
							and gp_num_user=$stagiaire
							and gp_num_parcours=$parcours
							and num_cal=$calendrier;
                            ");
             }

            return $res;
}

/**
*   Affecter l'avancement d'un stagiaire pour une formation donne.
*
*   @param integer : numero du stagiaire
*   @param integer : numero du calendrier
*   @param integer : numero de l'tape ou en est le stagiare
*   @param string : chaine des tapes libres effectues
*
*   @return integer : 0 OK, 1 ERREUR
*/
function set_avancement_stagiaire($stagiaire, $groupe, $calendrier, $parcours, $avancement,  $etape_libre, $avancement_libre)
{
            if(VERSION_BASE>VERSION )
            {
                        $req="select * from _af_set_avancement_stagiaire($stagiaire, $groupe, $calendrier, $parcours, $avancement,  '$etape_libre', $avancement_libre);";
                        //echo $req;
                        $res=pg_query($req);
            }
            else
                        $res=set_avancement_stagiaire_old($stagiaire, $groupe, $calendrier, $parcours, $avancement,  $etape_libre, $avancement_libre);
            return $res;
}

//////////////////// PENSEZ A RESPECTER LES COMMENTAIRES PHPDOC SVP!!!!!    //////////////////////////////////

/**
*   Obtenir la liste des formations d'un stagiaire d'un groupe qui a des valuations corriges   (OLD)
*
*    @param  integer : numro de groupe
*    @param integer : numro de stagiaire
*
*   @return integer :  les numros et noms de formations
*/
function get_formations_stagiaire_evaluation_finie_old($groupe,$user)
{
            $req="select distinct r.num_cal, nom_cal
            from resexouser r, calendrier c, gestionnaire
            where g_num_gest_g='$groupe'
            and surtotal <> 0
            and r.num_cal <>0
            and num_user='$user'
            and r.num_cal=c.num_cal
            and c.num_cal=g_num_cal
            group by r.num_cal, nom_cal
            union
            select distinct id_formation, nom_cal
            from res_serie,calendrier c, gestionnaire
            where g_num_gest_g='$groupe'
            and score >=0
            and date_fin>0
            and id_stag='$user'
            and id_formation=num_cal
            and num_cal=g_num_cal
            group by id_formation,nom_cal
            order by nom_cal";
            return(pg_query($req));
}

//////////////////// PENSEZ A RESPECTER LES COMMENTAIRES PHPDOC SVP!!!!!    //////////////////////////////////

/**
*   Obtenir la liste des formations d'un stagiaire d'un groupe qui a des valuations corriges
*
*    @param  integer : numro de groupe
*    @param integer : numro de stagiaire
*
*   @return integer : les numros et noms de formations
*/
function get_formations_stagiaire_evaluation_finie($groupe,$user)
{
            if(VERSION_BASE>VERSION)
            {
                        $req="select * from _af_get_formations_stagiaire_evaluation_finie($groupe,$user) AS (num_cal integer, nom_cal varchar)";
                        $res = pg_query($req);
            }
            else
                        $res=get_formations_stagiaire_evaluation_finie_old($groupe,$user);
            return ($res);
}

//////////////////// PENSEZ A RESPECTER LES COMMENTAIRES PHPDOC SVP!!!!!    //////////////////////////////////

/**
*   Obtenir le nombre de sries valides par un stagiaire d'une formation (OLD)
*
*    @param  integer : numro de formation
*    @param integer : numro de stagiaire
*
*   @return integer : le nombre de sries valides
*/
function get_nb_series_finies_old($form,$stag)
{
            $req="select count(*)
                        from res_serie
                        where id_formation='$form'
                        and id_stag='$stag'
                        and score >=0
                        and date_fin>0";
            return(pg_query($req));
}


//////////////////// PENSEZ A RESPECTER LES COMMENTAIRES PHPDOC SVP!!!!!    //////////////////////////////////

/**
*   Obtenir le nombre de sries valides par un stagiaire d'une formation
*
*    @param  integer : numro de formation
*    @param integer : numro de stagiaire
*
*   @return integer :    le nombre de sries valides
*/
function get_nb_series_finies($form,$stag)
{
            if(VERSION_BASE>VERSION)
            {
                        $req="select _af_get_nb_series_finies($form,$stag)";
                        $res = pg_query($req);
            }
            else
                        $res=get_nb_series_finies_old($form,$stag);
            $nb = pg_fetch_row($res,0);
            return $nb[0];
}

//////////////////// PENSEZ A RESPECTER LES COMMENTAIRES PHPDOC SVP!!!!!    //////////////////////////////////

/**
*   Obtenir le nombre d'exercices valids par un stagiaire d'une formation  (OLD)
*
*    @param  integer : numro de formation
*    @param integer : numro de stagiaire
*
*   @return integer :   le nombre d'exercices valids
*/
function get_nb_exos_finis_old($form,$stag)
{
            $req="select count(*)
            from resexouser
            where num_cal='$form'
            and  num_user='$stag'";
            return(pg_query($req));
}

//////////////////// PENSEZ A RESPECTER LES COMMENTAIRES PHPDOC SVP!!!!!    //////////////////////////////////


/**
*   Obtenir le nombre d'exercices valids par un stagiaire d'une formation
*
*    @param  integer : numro de formation
*    @param integer : numro de stagiaire
*
*   @return integer :  le nombre d'exercices valids
*/
function get_nb_exos_finis($form,$stag)
{
            if(VERSION_BASE>VERSION)
            {
                        $req="select _af_get_nb_exos_finis($form,$stag)";
                        $res = pg_query($req);
            }
            else
                        $res=get_nb_exos_finis_old($form,$stag);
            $nb = pg_fetch_row($res,0);
            return $nb[0];
}

//////////////////// PENSEZ A RESPECTER LES COMMENTAIRES PHPDOC SVP!!!!!    //////////////////////////////////
/**
*   Obtenir les infos sur le suivi presentiel (OLD)
*
*   Renvoie les infos du suivi presentiel pour un stagiaire, une formation
*   et une grille donns. le stagiaire est null par dfaut
*    @param  integer : numro de formation
*    @param integer : numro de stagiaire
*    @param integer : numro de grille
*
*   @return integer :  Les infos du suivi presentiel (table comment_presentiel)
*/
function get_infos_presentiel_stagiaire_old($numcal,$numuser,$numgrille,$numtitrecapa,$numcapa)
{
            $req="select * from comment_presentiel where num_cal='$numcal' ";

            if($numuser!="null")
            {
                        $req.=" and num_user='$numuser' and num_grille='$numgrille'";
                        if($numtitrecapa !="null")
                                    $req.=" and num_titrecapacite='$numtitrecapa'";
                        if($numcapa !="null")
                                    $req.=" and num_capacite='$numcapa'";
            }
            else
            {

                        $req.=" and num_grille='$numgrille'";
                        if($numtitrecapa !="null")
                                    $req.=" and num_titrecapacite='$numtitrecapa'";
                        if($numcapa !="null")
                                    $req.=" and num_capacite='$numcapa'";
            }
            $req.=" and notesur<>0";

            return(pg_query($req));
}




/**
*   Obtenir les infos sur le suivi presentiel
*
*   Renvoie les infos du suivi presentiel pour un stagiaire, une formation
*   et une grille donns. le stagiaire est null par dfaut
*    @param  integer : numro de formation
*    @param integer : numro de stagiaire
*    @param integer : numro de grille
*
*   @return integer :  Les infos du suivi presentiel (table comment_presentiel)
*/
function get_infos_presentiel_stagiaire($numcal,$numuser,$numgrille,$numtitrecapa,$numcapa)
{

            if(empty($numuser)) $numuser="null";
            if(empty($numtitrecapa)) $numtitrecapa="null";
            if(empty($numcapa)) $numcapa="null";
            if(VERSION_BASE > VERSION)
            {
                        $req = "select * from _af_get_infos_presentiel_stagiaire($numcal,$numuser,$numgrille,$numtitrecapa,$numcapa) as (num_cal integer,  num_user integer, num_grille integer, num_titrecapacite integer, num_capacite integer, num_date integer, comment character varying, note integer, notesur integer)";
                        $res=pg_query($req);
            }
            else
                        $res=get_infos_presentiel_stagiaire_old($numcal,$numuser,$numgrille,$numtitrecapa,$numcapa);
            return $res;
}

/**
*   Supprimmer les resultats et correction des exotlc d'un stagiaire (OLD).
*
*   Supprime resultat et correction des exotlc (pas les fichier) pour
*   le stagiaire et la formation donne.
*   Si le numero d'exercice est prcis et diffrent de null,
*   seuls les enregistrements de l'exercice sont effacs.
*
*    @param  integer : numro de stagiaire
*    @param integer : numro de formation
*    @param integer : numro de l'exercice (obligatoire ou null)
*
*   @return integer :  toujour gal a 1
*/
function del_exotlc_stagiaire_old($stagiaire, $formation, $exo)
{
    $delete1="  DELETE FROM resexouser
                        WHERE num_user=$stagiaire
                        AND num_cal=$formation" ;
    if($exo!="null")$delete1.=" and num_exo=$exo";

    $delete2="  delete from COMMENTUSERRUB
                        where num_user=$stagiaire
                        and num_cal=$formation";
    if($exo!="null")$delete2.=" and num_exo=$exo";

    $delete3="  DELETE FROM gestexotlc
                        WHERE gesttlc_user=$stagiaire
                        AND num_cal=$formation" ;
    if($exo!="null")$delete3.=" and num_exo=$exo";

    pg_query($delete1);
    pg_query($delete2);
    pg_query($delete3);

    return(1);
}



 /**
*   Supprimmer les resultats et correction des exotlc d'un stagiaire.
*
*   Supprime resultat et correction des exotlc (pas les fichier) pour
*   le stagiaire et la formation donne.
*   Si le numero d'exercice est prcis et diffrent de null,
*   seuls les enregistrements de l'exercice sont effacs.
*
*    @param  integer : numro de stagiaire
*    @param integer : numro de formation
*    @param integer : numro de l'exercice (facultatif)
*
*   @return integer :  toujour gal a 1
*/
function del_exotlc_stagiaire($stagiaire, $formation, $exo="null")
{

            if(VERSION_BASE > VERSION)
            {
                        $req = "select * from _af_del_exotlc_stagiaire($stagiaire, $formation, $exo) ";
                        //echo $req;
                        $res=pg_query($req);
            }
            else
                        $res=del_exotlc_stagiaire_old($stagiaire, $formation, $exo);
            return $res;
}

/**
*   Supprimmer les resultats et correction des series bloquantes d'un stagiaire (OLD).
*
*   Supprime resultat et correction des series bloquantes pour
*   le stagiaire et la formation donne.
*   Si le numero de serie est prcis et diffrent de null,
*   seuls les enregistrements de cette serie sont effacs.
*
*    @param  integer : numro de stagiaire
*    @param integer : numro de formation
*    @param integer : numro de la serie (obligatoire ou null)
*
*   @return integer :  1 trouv, 0 non trouv
*/
function del_series_bloquantes_stagiaire_old($stagiaire, $formation, $serie)
{
    $delete1="DELETE FROM stockresultserie
                        WHERE num_user=$stagiaire
                        AND num_cal=$formation" ;
    if($serie!="null")$delete1.=" and num_exo=$exo";

    return (pg_query($delete1));
}


/**
*   Supprimmer les resultats et correction des series bloquantes d'un stagiaire.
*
*   Supprime resultat et correction des series bloquantes pour
*   le stagiaire et la formation donne.
*   Si le numero de serie est prcis et diffrent de null,
*   seuls les enregistrements de cette serie sont effacs.
*
*    @param  integer : numro de stagiaire
*    @param integer : numro de formation
*    @param integer : numro de la serie (obligatoire ou null)
*
*   @return integer :  1 trouv, 0 non trouv
*/
function del_series_bloquantes_stagiaire($stagiaire, $formation, $serie="null")
{

            if(VERSION_BASE > VERSION)
            {
                        $req = "select * from _af_del_series_bloquantes_stagiaire($stagiaire, $formation, $serie) ";
                        $res=pg_query($req);
            }
            else
                        $res=del_series_bloquantes_stagiaire_old($stagiaire, $formation, $serie);
            return $res;
}

/**
*   Rinitialiser l'avancement d'un stagiaire (OLD).
*
*   Supprime tous enregistrements des resultats et  descorrections de tous les exercices, quels que soit leur type,
*   d'un stagiaire pour une formation donne.
*
*    @param  integer : numro du stagiaire
*    @param integer : numro du groupe du stagiaire
*    @param integer : numro de la formation
*
*   @return integer :  toujours 1
*/
function del_avancement_stagiaire_old($stagiaire, $groupe, $formation)
{

    // On efface les enregistrement pour des exercices  tlcharger
    del_exotlc_stagiaire($stagiaire,$formation);

    // On efface les enregistrements de sries d'exercice
    $delete3="DELETE FROM res_serie WHERE id_stag=$stagiaire AND id_formation=$formation" ;
    $delete4="DELETE FROM res_serie_exo WHERE id_stag=$stagiaire AND id_formation=$formation" ;
    $sql="delete from stockresultserie where num_user='$stagiaire' and num_cal='$formation';";
    $del=pg_query($sql);

    // On efface les enregistrements de questionnaires
    $delete5="DELETE FROM gestionqst WHERE gqst_num_user=$stagiaire AND num_cal=$formation" ;
    $delete6="DELETE FROM gestionqst WHERE gqst_num_user=$stagiaire AND num_cal=$formation" ;
    $sql="delete from stockresultqcm where num_user=$stagiaire and num_cal=$formation" ;
    $del=pg_query($sql);


    // les listes
    $sql="delete from res_liste_test where id_stag=$stagiaire and id_formation=$formation;";
    $del=pg_query($sql);
     $sql="delete from res_liste where id_stag=$stagiaire and id_formation=$formation;";
    $del=pg_query($sql);


    // On efface les enregistrements temporaires de sries bloquantes
    del_series_bloquantes_stagiaire($stagiaire, $formation);


    pg_query($delete3);
    pg_query($delete4);
    pg_query($delete5);
    pg_query($delete6);

    // On remet zro ses avancements dans le parcours
    $parcours=get_parcours_formation($formation);

    set_avancement_stagiaire($stagiaire, $groupe ,  $formation, $parcours, 0, '0', 0);

    return (1);
}


/**
*   Supprimmer les resultats et correction des series bloquantes d'un stagiaire.
*
*   Supprime resultat et correction des series bloquantes pour
*   le stagiaire et la formation donne.
*   Si le numero de serie est prcis et diffrent de null,
*   seuls les enregistrements de cette serie sont effacs.
*
*    @param  integer : numro de stagiaire
*    @param integer : numro de formation
*    @param integer : numro de la serie (obligatoire ou null)
*
*   @return integer :  toujours 1
*/
function del_avancement_stagiaire($stagiaire, $groupe, $formation)
{

            if(VERSION_BASE > VERSION)
            {
                        $req = "select * from _af_del_avancement_stagiaire($stagiaire, $groupe, $formation) ";
                        $res=pg_query($req);
            }
            else
                        $res=del_avancement_stagiaire_old($stagiaire, $groupe, $formation);
            return $res;
}

/**
*   Obtenir les formations d'un stagiaire pour une priode (OLD)
*
*   @param integer : le numero du stagiaire
*   @param integer : le numero de la priode 1=pass 2=prsent 3=futur>
*   @return integer : l'entier resultat de la requete
*/
function get_formations_stagiaire_periode_old($stagiaire,$periode){
    switch($periode){
        case 1: $condition=" AND D2.jour < current_date ";
        break;
        case 2: $condition=" AND NOT (D1.jour > current_date OR D2.jour < current_date) ";
        break;
        case 3: $condition=" AND D1.jour > current_date ";
        break;
    }
    $sql="SELECT DISTINCT  g_num_gest_g,U.nom, U.prenom, C.nom_cal as formation, C.num_cal, D1.jour as debut, D2.jour as fin
                                FROM gestionnaire G, utilisateurs U, calendrier C, dates D1, dates D2
                                WHERE U.num_user=G.g_num_user
                                AND C.num_cal=G.g_num_cal
                                AND D1.num_date=C.datedeb
                                AND D2.num_date=C.datefin
                                $condition
                                AND G.g_num_gest_g  IN (SELECT g_num_gest_g FROM gestionnaire WHERE g_num_gest_g IN
                                (SELECT gu_num_gest_gr FROM gestionutil WHERE gu_num_user=$stagiaire))";


    return (pg_query($sql));

}
/**
*   Obtenir les formations d'un stagiaire pour une priode
*
*   @param integer : le numero du stagiaire
*   @param integer : le numero de la priode 1=pass 2=prsent 3=futur>
*   @return integer : l'entier resultat de la requete
*/
function get_formations_stagiaire_periode($stagiaire,$periode){
    if (VERSION_BASE > VERSION) {
        // Appel de la fonction plpgsql  crer : _af_get_formation_selection_periode("stagiaire",$stagiare,$periode)
        $sql="A IMPLEMENTER";
        $res=pg_query($sql);
    }
    else
        $res=get_formations_stagiaire_periode_old($stagiaire,$periode);
    return $res;
}

/**
*   Obtenir les formations d'un stagiaire (OLD)
*
*   @param integer : le numero du stagiaire
*   @return integer : l'entier resultat de la requete
*/
function get_formations_stagiaire_old($stagiaire){
  
    $sql=" (select   num_cal AS num_formation, nom_cal AS nom_formation, datedeb, datefin,  langue, lower(nom_cal) AS ordre
                from calendrier
                where num_cal in
                (select g_num_cal from gestionnaire  where g_num_gest_g in
                (select distinct gu_num_gest_gr from gestionutil where gu_num_user='$stagiaire')) 
                
                )ORDER BY ordre";

    return (pg_query($sql));

}
/**
*   Obtenir les formations d'un stagiaire 
*
*   @param integer : le numero du stagiaire
*   @param integer : le numero de la p\x{00E9}riode 1=pass\x{00E9} 2=pr\x{00E9}sent 3=futur>
*   @return integer : l'entier resultat de la requete
*/
function get_formations_stagiaire($stagiaire){
    if (VERSION_BASE > VERSION) {
        // Appel de la fonction plpgsql \x{00E0} cr\x{00E9}er : _af_get_formation_selection_periode("stagiaire",$stagiare,$periode)
        $sql="A IMPLEMENTER";
        $res=pg_query($sql);
    }
    else
        $res=get_formations_stagiaire_old($stagiaire);
    return $res;
}


/**
	Obtenir les resultats d'un stagiare pour un exercice et une fomation.(OLD)
	
	Les informations obtenues sont:
	g_num_exotlc | gesttlc_exo | gesttlc_rub | gesttlc_srub | gesttlc_user | resultat | notesur | num_cal
	
  	@param integer: identifiant en base stagiaire
  	@param integer: identifiant en base de l'exercice a telecharger
  	@param integer: identifiant en base de la formation
	@return integer: l'entier resultat de la requete
*/
function get_stagiaire_exotlc_resultats_old($stagiaire, $exercice, $formation){

		$req="select * from GESTEXOTLC where gesttlc_user='$stagiaire' and gesttlc_exo='$exercice' and num_cal='$formation';";
        //echo $req."<br>";
        $res=pg_query($req);
		
        
        return $res;

}

/**
	Obtenir les resultats d'un stagiare pour un exercice et une fomation.
	
	Les informations obtenues sont:
	g_num_exotlc | gesttlc_exo | gesttlc_rub | gesttlc_srub | gesttlc_user | resultat | notesur | num_cal
	
  	@param integer: identifiant en base stagiaire
  	@param integer: identifiant en base de l'exercice a telecharger
  	@param integer: identifiant en base de la formation
	@return integer: l'entier resultat de la requete
*/
function get_stagiaire_exotlc_resultats($stagiaire, $exercice, $formation){

            if(VERSION_BASE>VERSION)
            {
                     

            }
            else
                      $res= get_stagiaire_exotlc_resultats_old($stagiaire, $exercice, $formation);

            return ($res);
}


/**
	Obtenir les resultats d'un stagiare pour un exercice et une fomation.(OLD)
	
	Les informations obtenues sont:
	
	
  	@param integer: identifiant en base stagiaire
  	@param integer: identifiant en base de la formation
	@return integer: l'entier resultat de la requete
*/
function get_stagiaire_exotlcs_resultats_old($stagiaire,  $formation){

		$req="	select distinct num_exo, titre from EXOTLC E, GESTEXOTLC G
             		where E.num_exo=G.gesttlc_exo 
                    and gesttlc_user='$stagiaire' 
                    and num_cal='$formation' order by titre;";
        //echo $req."<br>";
        $res=pg_query($req);
		
        
        return $res;

}

/**
	Obtenir les resultats d'un stagiaire pour les exotlcs d'une formation
	
	Obtenir les tous les exercices pour lesquels
	un stagiaire  eut des resultats , dans une  fomation donnee.
	
	Les informations obtenues sont:
	
	
  	@param integer: identifiant en base stagiaire
  	@param integer: identifiant en base de la formation
	@return integer: l'entier resultat de la requete
*/
function get_stagiaire_exotlcs_resultats($stagiaire,  $formation){

            if(VERSION_BASE>VERSION)
            {
                     

            }
            else
                      $res= get_stagiaire_exotlcs_resultats_old($stagiaire,  $formation);

            return ($res);
}

/**
	Obtenir les resultats des sous criteres d'un stagiare pour un exercice , une fomation et un critirere donn.(OLD)
	
	Les informations obtenues sont:
	g_num_exotlc | gesttlc_exo | gesttlc_rub | gesttlc_srub | gesttlc_user | resultat | notesur | num_cal
	
  	@param integer: identifiant en base stagiaire
  	@param integer: identifiant en base de l'exercice a telecharger
  	@param integer: identifiant en base de la formation
  	@param integer: identifiant en base du critere
	@return integer: l'entier resultat de la requete
*/
function get_stagiaire_exotlc_sous_criteres_old($stagiaire, $exercice, $formation, $critere){

		$req="select * from GESTEXOTLC where
		gesttlc_rub='$critere'and gesttlc_exo='$exercice' and gesttlc_user='$stagiaire' and num_cal='$formation' order by gesttlc_srub;";
        //echo $req."<br>";
        $res=pg_query($req);
		
        
        return $res;

}

/**
	Obtenir les resultats des sous criteres d'un stagiare pour un exercice , une fomation et un critirere donn.

	Les informations obtenues sont:
	g_num_exotlc | gesttlc_exo | gesttlc_rub | gesttlc_srub | gesttlc_user | resultat | notesur | num_cal

  	@param integer: identifiant en base stagiaire
  	@param integer: identifiant en base de l'exercice a telecharger
  	@param integer: identifiant en base de la formation
  	@param integer: identifiant en base du critere
	@return integer: l'entier resultat de la requete
*/
function get_stagiaire_exotlc_sous_criteres($stagiaire, $exercice, $formation, $critere){

            if(VERSION_BASE>VERSION)
            {
                     

            }
            else
                      $res= get_stagiaire_exotlc_sous_criteres_old($stagiaire, $exercice, $formation, $critere);

            return ($res);
}

function get_stagiaire_formation_groupe_old($stagiaire, $formation){
	
	$req="	SELECT distinct id, nom 
				FROM classe, gestionnaire, gestionutil
				WHERE gu_num_user=$stagiaire
				AND gu_num_gest_gr=g_num_gest_g
				AND g_num_gest_g=id
				AND g_num_cal=$formation ";
	$res=pg_query($req);
	//echo $req;
	return $res;
	
}

function get_stagiaire_formation_groupe($stagiaire, $formation){

            if(VERSION_BASE>VERSION)
            {
                     

            }
            else
                      $res= get_stagiaire_formation_groupe_old($stagiaire, $formation);

            return ($res);
}




/**
	Obtenir les series notees d'une formation pour un stagiaire donn (OLD)

	Les informations obtenues sont:
	id_serie

  	@param integer: identifiant en base du stagiaire
  	@param integer: identifiant en base de la formation
*/
function get_stagiaire_series_notees_formation_old($stagiaire,$formation)
{
        $req = "select distinct id_serie from res_serie where id_formation='$formation' and score>=0 and date_fin>0 and id_stag='$stagiaire' order by id_serie";
        $res = pg_query($req);
        return $res ;
}

/**
	Obtenir les series notees d'une formation pour un stagiaire donn

	Les informations obtenues sont:
	id_serie

  	@param integer: identifiant en base du stagiaire
  	@param integer: identifiant en base de la formation
*/
function get_stagiaire_series_notees_formation($stagiaire,$formation)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_stagiaire_series_notees_formation_old($stagiaire,$formation);

    return $res ;
}


/**
	Obtenir les exercices d'une formation pour un stagiaire donn (OLD)

	Les informations obtenues sont:
	num_exo | titre | mode_rendu

  	@param integer: identifiant en base du stagiaire
  	@param integer: identifiant en base de la formation
*/
function get_stagiaire_exercices_telecharges_formation_old($stagiaire,$formation)
{
    $req="select num_exo, titre, mode_rendu from exotlc
              where num_exo in(select distinct gesttlc_exo from gestexotlc where num_cal=$formation and gesttlc_user=$stagiaire)";
    $res=pg_query($req);
    return $res ;
}

/**
	Obtenir les exercices d'une formation pour un stagiaire donn

	Les informations obtenues sont:
	num_exo | titre | mode_rendu

  	@param integer: identifiant en base du stagiaire
  	@param integer: identifiant en base de la formation
*/
function get_stagiaire_exercices_telecharges_formation($stagiaire,$formation)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_stagiaire_exercices_telecharges_formation_old($stagiaire,$formation);

    return $res ;
}

/**
	Obtenir les scores d'un exercice d'une formation pour un stagiaire donn (OLD)

	Les informations obtenues sont:
	resultat | notesur

  	@param integer: identifiant en base du stagiaire
  	@param integer: identifiant en base de la formation
      	@param integer: identifiant en base de l'exercice
*/
function get_stagiaire_scores_exercice_formation_old($stagiaire,$formation,$exercice)
{
    $req="select resultat, notesur from gestexotlc where gesttlc_exo=$exercice and num_cal=$formation and gesttlc_user=$stagiaire";
    $res=pg_query($req);
    return $res ;
}

/**
	Obtenir les scores d'un exercice d'une formation pour un stagiaire donn

	Les informations obtenues sont:
	resultat | notesur

  	@param integer: identifiant en base du stagiaire
  	@param integer: identifiant en base de la formation
      	@param integer: identifiant en base de l'exercice
*/
function get_stagiaire_scores_exercice_formation($stagiaire,$formation,$exercice)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_stagiaire_scores_exercice_formation_old($stagiaire,$formation,$exercice);

    return $res ;
}


/**
	Obtenir le nom et prenom ainsi que le score d'un stagiaire pour une serie et une formation donne (OLD)

	Les informations obtenues sont:
	nom prenom | score

  	@param integer: identifiant en base de la formation
      	@param integer: identifiant en base de la serie
*/
function get_stagiaires_score_serie_formation_old($formation,$serie)
{
    $req="select textcat(textcat(nom,text' '),prenom),score from utilisateurs,res_serie
               where id_serie=$serie and id_formation=$formation and score >=0 and date_fin>0
               and num_user=id_stag order by nom";
    $res=pg_query($req);
    return $res ;
}

/**
	Obtenir le nom et prenom ainsi que le score d'un stagiaire pour une serie et une formation donne

	Les informations obtenues sont:
	nom prenom | score

  	@param integer: identifiant en base de la formation
      	@param integer: identifiant en base de la serie
*/
function get_stagiaires_score_serie_formation($formation,$serie)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_stagiaires_score_serie_formation_old($formation,$serie);

    return $res ;
}

/**
	Obtenir le nom et prenom ainsi que le score d'un stagiaire pour un exercice a telecharger et une formation donne (OLD)

	Les informations obtenues sont:
	nom prenom | score | surtotal

  	@param integer: identifiant en base de la formation
      	@param integer: identifiant en base de l'exercice
*/
function get_stagiaires_score_exercice_formation_old($formation,$exercice)
{
    $req="select textcat(textcat(nom,text' '),prenom),score,surtotal from utilisateurs U, resexouser R
               where num_exo=$exercice and num_cal=$formation and date_correction>0 and score>=0
               and U.num_user=R.num_user order by nom";
    $res=pg_query($req);
    return $res ;
}

/**
	Obtenir le nom et prenom ainsi que le score d'un stagiaire pour un exercice a telecharger et une formation donne

	Les informations obtenues sont:
	nom prenom | score | surtotal

  	@param integer: identifiant en base de la formation
      	@param integer: identifiant en base de l'exercice
*/
function get_stagiaires_score_exercice_formation($formation,$exercice)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_stagiaires_score_exercice_formation_old($formation,$exercice);

    return $res ;
}

/**
	Obtenir les listes de test d'une formation pour un stagiaire donn (OLD)

	Les informations obtenues sont:
	id_list_test

      @param integer: identifiant en base du stagiaire
      @param integer: identifiant en base de la formation
*/
function get_stagiaire_liste_test_formation_old($stagiaire,$formation)
{
    $req="select id_liste_test from liste_test where id_liste_test
               in (select id_liste from res_liste where id_formation=$formation and id_stag=$stagiaire)";
    $res=pg_query($req);
    return $res ;
}

/**
	Obtenir les listes de test d'une formation pour un stagiaire donn

	Les informations obtenues sont:
	id_list_test

      @param integer: identifiant en base du stagiaire
      @param integer: identifiant en base de la formation
*/
function get_stagiaire_liste_test_formation($stagiaire,$formation)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_stagiaire_liste_test_formation_old($stagiaire,$formation);

    return $res ;
}


/**
	Obtenir les formations ayant au moins une valuation en table pour un stagiaire donn (OLD)

	Les informations obtenues sont:
	num_cal

      @param integer: identifiant en base du stagiaire
*/
function get_stagiaire_formations_evaluees_old($stagiaire)
{
    $req="select num_cal from calendrier, dates
               where num_cal IN (select distinct id_formation from res_serie
                                              where id_stag=$stagiaire and date_fin>0 and score>=0)
               UNION
               select num_cal from calendrier, dates
               where num_cal IN (select distinct num_cal from resexouser where date_correction>0
                                                and num_user=$stagiaire)   ";

               //and datedeb=num_date order by jour";
    $res=pg_query($req);
    return $res ;
}

/**
	Obtenir les formations ayant au moins une valuation en table pour un stagiaire donn

	Les informations obtenues sont:
	num_cal

      @param integer: identifiant en base du stagiaire
*/
function get_stagiaire_formations_evaluees($stagiaire)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_stagiaire_formations_evaluees_old($stagiaire);

    return $res ;
}

function get_stagiaire_exotlc_rendu_formation_old($stagiaire, $exercice, $formation){
	$req="	select * 
				from reception_exostlc 
				where num_stag=$stagiaire
				AND num_cal=$formation 
				AND num_exo=$exercice;";
	
	return pg_query($req);
}

function get_stagiaire_exotlc_rendu_formation($stagiaire, $exercice, $formation){
	
    if(VERSION_BASE>VERSION)
    {
            print("A implementer...");
    }
    else{
	
		$res=get_stagiaire_exotlc_rendu_formation_old($stagiaire, $exercice, $formation);
		
	}
	
	return $res;
}

/**
	Obtenir les exotlc corriges pour un stagiaire pour une formation
	@param integer : stagiaire
	@param integer : formation
	@return integer : res req
*/
function get_stagiaire_exotlcs_corriges_formation($stagiaire,$formation){
	$sql="select * from contraintes.af_get_stagiaire_exotlcs_corriges_formation($stagiaire,$formation) 
	as(id int4, libelle_pour_parcours varchar, libelle_etape  varchar,libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool,libelle_type_original varchar, modifiable bool,indice int4)"; 
	
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
?>