<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
  fonctions_graph.php :
   Fichier de fonctions permettant de gnrer des images graphiques
 
   @author  Elyes FEKI (efeki@afide.fr)
   @since  feb 2005                                          
   @package statistiques
   @modulegroup fonctions
 
*/

/**
 *  Fonction qui cre des couleurs hexadcimales
 *
 * @param image : image  traiter
 * @param hexa : code de la couleur hexadecimale
 *
 * @return : nouvelle image avec couleur modifie
 **/
function ajouter_hexcouleur($img, $couleur)
{
    $rouge = HexDec(substr($couleur, 0, 2));
    $vert = HexDec(substr($couleur, 2, 2));
    $bleu = HexDec(substr($couleur, 4, 2));

    return imagecolorallocate($img, $rouge, $vert, $bleu);
}


/**
 *  Fonction qui gnre un camembert pour la rpartition des notes
 *
 * @param array : tableau de notes
 **/
function genererCamembert($tab)
{
    global $FORM_18,$FORM_19,$MSG_913;
    global $num_grp,$id_serie,$num_cal ;

    $donnees=array();

    for($i=0;$i<11;$i++)
    {
        $donnees[$i]=0;
        reset($tab);
        while(list($id,$val)=each($tab))
        {
            if($val != "X" && $i != 10 && $val >= (float)(2*$i) && $val <= (float)(2*($i+1)))
            {
                if($val != (2*($i+1)) || ($val == (2*($i+1)) && $val == 20))
                {
                    $donnees[$i]++;
                }
            }
            if($i == 10 && $val =="X")
            {
                $donnees[10]++;
            }
        }
    }
    $options = array('', 1, '', 1, 3);

    $nom_fic=$num_cal."_".$num_grp."_".$id_serie."_repart_.png";
    $x=500;
    $y=250;
    $tabLegende=array("$FORM_18 0 $FORM_19 2",
                                     "$FORM_18 2 $FORM_19 4",
                                     "$FORM_18 4 $FORM_19 6",
                                     "$FORM_18 6 $FORM_19 8",
                                     "$FORM_18 8 $FORM_19 10",
                                     "$FORM_18 10 $FORM_19 12",
                                     "$FORM_18 12 $FORM_19 14",
                                     "$FORM_18 14 $FORM_19 16",
                                     "$FORM_18 16 $FORM_19 18",
                                     "$FORM_18 18 $FORM_19 20",
                                     "$MSG_913");

    $texte="000000";
    $premier_plan = "FF0000";
    $arriere_plan="FFFFFF";
    $couleurs[1] = array("cc3399","ffff33","ff6633","cc0033","99ff66","0033ff",
                                      "ff0099","ffebcd","8a2be2","a52a2a","ffffff","d2691e");

    /*
       --- Dessin d'un graphique en camembert ---
           => Requis : librairie GD, PHP 4 et les fonctions graphiques, du mme auteur.
       Version : 27/05/2001
       Auteur : BICHLER Olivier - http://www.guidewebmaster.net - <webmaster@guidewebmaster.net>
           Inspir du script de Cedric Fronteau <charlie@nexen.net>. */

    if(!isset($margey)) $margey=10;
    if(!isset($margex)) $margex=10;

    $total = 0;
    $nb_valeurs = sizeof($donnees);
    for($i=0;$i<$nb_valeurs;$i++)
        $total+= $donnees[$i];

    $img = imagecreate($x, $y);
    $maroon = ImageColorAllocate($img,100,0,0);
    $white = ImageColorAllocate($img,255,255,255);
    $red = ImageColorAllocate($img,255,0,0);
    $blue = ImageColorAllocate($img,0,0,255);
    $grey = ImageColorAllocate($img,200,200,200);
    $black = ImageColorAllocate($img,0,0,0);
    $img_couleurs["texte"] = ajouter_hexcouleur($img, $texte);
    $img_couleurs["premier_plan"] = ajouter_hexcouleur($img, $premier_plan);
    $img_couleurs["arriere_plan"] = ajouter_hexcouleur($img, $arriere_plan);
    imagefill($img, 0, 0, $white);

    $diametre = min($x, $y);
    $centre_x = floor($diametre / 2);
    $centre_y = floor($diametre / 2) + (int) (($y - $diametre) / 2);
    $debut = 0;
    $tabCouleur=array();

    for($i=0;$i<$nb_valeurs;$i++,$debut=$fin)
    {
        $couleur = ajouter_hexcouleur($img, $couleurs[1][$i]);
        $tabCouleur[$i]=$couleur;

        if($donnees[$i]!=0)
        {
            /* Dessin de l'arc */
            $fin = round($debut + $donnees[$i] / $total * 360);
            imagearc($img, $centre_x, $centre_y, $diametre, $diametre, $debut, $fin, $couleur);

            /* Dessin des lignes dlimitants l'arc */
            $ligne1_x = round(cos(deg2rad($debut)) * $diametre / 2 + $centre_x);
            $ligne1_y = round(sin(deg2rad($debut)) * $diametre / 2 + $centre_y);
            $ligne2_x = round(cos(deg2rad($fin)) * $diametre / 2 + $centre_x);
            $ligne2_y = round(sin(deg2rad($fin)) * $diametre / 2 + $centre_y);

            imageline($img, $centre_x, $centre_y, $ligne1_x, $ligne1_y, $couleur);
            imageline($img, $centre_x, $centre_y, $ligne2_x, $ligne2_y, $couleur);

            $valeur_pc = round(($donnees[$i] / $total) * 100)."%";
            $milieu = floor(($fin - $debut) / 2 + $debut);
            $py = round(sin(deg2rad($milieu)) * ($diametre / 3) + $centre_y);
            $px = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x);
            imagefilltoborder($img, $px, $py, $couleur, $couleur);

            if ($debut > 90 && $debut < 180)
            {
                $py = round(sin(deg2rad($milieu)) * ($diametre / 3) + $centre_y - (imagefontheight($options[3]) / 2));
                $px = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x);
                $px_pc = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x);
            }
            else
            {
                $py = round(sin(deg2rad($milieu)) * ($diametre / 3) + $centre_y - (imagefontheight($options[3]) / 2));
                $px = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x - (imagefontwidth($options[3]) * strlen($donnees[$i]) / 2));
                $px_pc = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x - (imagefontwidth($options[3]) * strlen($valeur_pc) / 2));
            }

            if ($options[4] == 1)
            {
                imagestring($img, $options[3], $px, $py, $donnees[$i], $img_couleurs["texte"]);
            }
            elseif ($options[4] == 2)
            {
                imagestring($img, $options[3], $px_pc, $py, $valeur_pc, $img_couleurs["texte"]);
            }
            elseif ($options[4] == 3)
            {
                imagestring($img, $options[3], $px, $py + (imagefontheight($options[3]) / 2), $donnees[$i], $img_couleurs["texte"]);
                imagestring($img, $options[3], $px_pc, $py - (imagefontheight($options[3]) / 2), $valeur_pc, $img_couleurs["texte"]);
            }

            imageline($img, $centre_x, $centre_y, $ligne1_x, $ligne1_y, $img_couleurs["premier_plan"]);
            imageline($img, $centre_x, $centre_y, $ligne2_x, $ligne2_y, $img_couleurs["premier_plan"]);
        }

        imagearc($img, $centre_x, $centre_y, $diametre, $diametre, 0, 360, $img_couleurs["premier_plan"]);
    }

    //Legende
    if(!isset($taillefont)) $taillefont=3;
    //On calcule la chaine la plus longue
    $chaine_la_plus_longue=0;
    while(list($id,$chaine)=each($tabLegende))
    {
        $tmp=imagefontwidth($taillefont) * strlen($chaine);
        if($chaine_la_plus_longue<$tmp)$chaine_la_plus_longue=$tmp;
    }
    $espace_entre_ligne=imagefontheight($taillefont);
    if(!isset($espace_entre_carre_et_texte)) $espace_entre_carre_et_texte=5;
    $taille_carre=min($taillefont,5)*2;

    $i=0;
    $j=0;
    reset($tabLegende);
    while(list($id,$chaine)=each($tabLegende))
    {
        if($donnees[$j] != 0)
        {
            //On affiche les petits carrs de couleur
            ImageFilledRectangle($img,
                $x-$chaine_la_plus_longue-$margex-$taille_carre-$espace_entre_carre_et_texte,
                $margey+($i*$espace_entre_ligne)+$margey/3,
                $x-$chaine_la_plus_longue-$margex-$taille_carre-$espace_entre_carre_et_texte+$taille_carre,
                $margey+($i*$espace_entre_ligne)+$taille_carre+$margey/3,
                $tabCouleur[$j]);

            //On affiche la legende
            imagestring($img,$taillefont,$x-$chaine_la_plus_longue-$margex,$margey+($i*$espace_entre_ligne),$chaine,$black);
            $i++;
        }
        $j++;
    }

    if(!isset($nom_fic)) $nom_fic="cache/monCam2.png";

    imagePng($img,"cache/$nom_fic");
    imageDestroy($img);
    print("<img src=cache/$nom_fic>\n");
}


/**
 *  Fonction qui gnre un graphique pour l'volution des notes
 *
 * @param string : titre du graphique
 * @param array : les diffrentes notes  placer
 * @param array : les lgendes qui correspondent aux diffrentes notes
 * @param integer : la taille de la largeur
 * @param integer : la taille de la hauteur
 * @param string : le nom du fichier
 **/

function genererGraph($titre,$points,$tabLegende,$largeur,$hauteur,$nomFic)
{
    if(!isset($margex)) $margex=200;
    $margey=40;

    // creation de l'image
    $image = imagecreate($largeur,$hauteur);

    // creation des couleurs
    $maroon = ImageColorAllocate($image,100,0,0);
    $white = ImageColorAllocate($image,255,255,255);
    $red = ImageColorAllocate($image,255,0,0);
    $blue = ImageColorAllocate($image,0,0,255);
    $grey = ImageColorAllocate($image,200,200,200);
    $black = ImageColorAllocate($image,0,0,0);
    $green = ImageColorAllocate($image,0,128,0);
    $orange = ImageColorAllocate($image,255,165,0);
    $grisclair = ImageColorAllocate($image,247,247,247);


    if(!isset($Cbackground))
        $background=ImageColorAllocate($image,255,255,255);
    else $background=ImageColorAllocate($image,$Cbackground[0],$Cbackground[1],$Cbackground[2]);


    ImageFilledRectangle($image,0,0,$largeur,$hauteur,$background);
    ImageFilledRectangle($image,0,$margey,$largeur-$margex,$hauteur-$margey,$grisclair);

    //Tracage de la grille
    $taillefont=2;
    $nb_separation=10;
    $haut = ($hauteur-(2*$margey)) / ($nb_separation);

    //axe vertical
    imageLine($image,40,$hauteur-$margey,40,0+$margey,$green);

    for($i=0;$i<=($nb_separation);$i++)
    {
        $ypos=$margey + $hauteur - (int)($i*$haut);
        $ypos=$ypos-(2*$margey);

        if($i != ($nb_separation /2))
        {
            //Dans le cas d'un graph multi ligne, on ne trace pas
            //tous les reperes horizontaux (trop fouilli sinon)
            if(!isset($tabNoteExo)) ImageLine($image,0+40, $ypos,$largeur-$margex,$ypos,$maroon);
        }
        else ImageLine($image,0+40, $ypos,$largeur-$margex,$ypos,$red);

        $valeur=(20/$nb_separation)*$i;
        $valeur=$valeur*100;
        $valeur=round($valeur);
        $valeur=$valeur/100;
        $center=imagefontwidth($taillefont) * strlen($valeur);
        $center = (int)($margex - $center);
        imagestring($image, $taillefont,0,$ypos-(imagefontheight($taillefont)/2) , $valeur , $maroon);
    }

    $largeur_grille=$largeur-$margex-40;
    $largeur_col=$largeur_grille/(sizeof($points));//+((2*sizeof($points))*$espace_col);

    //cacul de l'chelle
    $echelle=(($hauteur-(2*$margey))/20);
    $tc=5; //tc = taille de la croix;
    $point1=array();
    $point2=array();

    //on dessine les lignes
    for($i=0;$i<sizeof($points);$i++)
    {
        $point2[0]=($i*$largeur_col+40);
        $point2[1]=(($hauteur-$margey) - ($points[$i] * $echelle));
        if($i != 0)
        {
            //Si il s'agit de multiligne, on trace la moyenne en pointill
            if(isset($tabNoteExo))
                imageDashedLine($image,$point1[0],$point1[1],$point2[0],$point2[1],$blue);
            else
                imageLine($image,$point1[0],$point1[1],$point2[0],$point2[1],$blue);
        }

        imageLine($image,$point2[0]-$tc/2,$point2[1]-$tc/2,$point2[0]+$tc/2,$point2[1]+$tc/2,$red);
        imageLine($image,$point2[0]-$tc/2,$point2[1]+$tc/2,$point2[0]+$tc/2,$point2[1]-$tc/2,$red);

        //label des colonnes
        $taille_label=imagefontwidth($taillefont) * strlen($i+1);
        imagestring($image,$taillefont,($largeur_col*$i)+40+$espace_col,$hauteur-($margey),$i+1,$black);
        imagestring($image,$taillefont,($largeur_col*$i)+40+$espace_col-(imagefontwidth($taillefont)/2),$point2[1]-15,$points[$i],$red);

        $point1[0]=$point2[0];
        $point1[1]=$point2[1];
    }

    $titlefont = 5;
    $txtsz = imagefontwidth($titlefont) * strlen($titre);
    $xpos = (int)(($largeur -$margex- $txtsz)/2); // center the title
    $xpos = max(1, $xpos); // force positive coordinates
    $ypos = $margey/3; // distance from top
    imagestring($image, $titlefont, $xpos, $ypos, $titre , $black);

    //legende
    if(!isset($tabLegende))
        $tabLegende=array("legende 1","legende 2","legende 3","legende 4","legende 5","legende 6","legende 7","legende 8","legende 9","legende 10");

    $margeLegende = 10;
    $espace=30;

    //on cherche la legende la plus longue
    $chaine_la_plus_longue=0;
    while(list($id,$chaine)=each($tabLegende))
    {
        if((imagefontwidth($taillefont) * strlen($chaine)) > $chaine_la_plus_longue)
            $chaine_la_plus_longue = (imagefontwidth($taillefont) * strlen($chaine));
    }

    //on affiche la legende
    if(!isset($tabLegende2))
    {
        reset($tabLegende);
        while(list($id,$chaine)=each($tabLegende))
        {
            $num_leg=$id+1;
            imagestring($image,$taillefont,($largeur-$margex)+$espace,$margey + $id*$margeLegende,"$num_leg : " . "$chaine" ,$black);
            $tmp=$id;
        }
    }

    /*********** Multi Ligne *********************/

    $taille_echantillon=10;
    if(isset($tabNoteExo))
    {
        //Correspondance entre le numero d'utilisateur et une couleur
        $tabLegendeCouleur=array();
        $indice=0;
        while(list($exo,$tabUser)=each($tabNoteExo))
        {
            $tabLegendeCouleur[$exo]=$indice;
            $indice++;
        }

        $espace_leg1_leg2=($tmp+2)*$margeLegende;
        //Legende des lignes

        //la moyenne
        imagedashedLine($image,($largeur-$margex)+$espace-$taille_echantillon,
        $margey + $margeLegende/2+ $espace_leg1_leg2+$eppaisseur_ligne,
        ($largeur-$margex)+$espace,
        $margey + $margeLegende/2+ $espace_leg1_leg2+$eppaisseur_ligne,
        $blue);

        imagestring($image,$taillefont,($largeur-$margex)+$espace,$margey+$espace_leg1_leg2," Moyenne",$black);

        reset($tabLegende2);
        while(list($id,$chaine)=each($tabLegende2))
        {
            $eppaisseur_ligne=imagefontwidth($taillefont);
            //print("$eppaisseur_ligne <br>");
            if($id > 0)
            {
                $coul=ajouter_hexcouleur($image, $tabCouleurLigne[$id-1]);
                imageLine($image,($largeur-$margex)+$espace-$taille_echantillon,
                    $margey + $id*$margeLegende+ $espace_leg1_leg2+$eppaisseur_ligne,
                    ($largeur-$margex)+$espace,$margey+$id*$margeLegende+
                    $espace_leg1_leg2+$eppaisseur_ligne,$coul);

                imagestring($image,$taillefont,($largeur-$margex)+$espace,$margey+$id*$margeLegende+$espace_leg1_leg2," $chaine",$black);
            }
        }

        reset($tabNoteExo);
        while(list($exo,$tabUser)=each($tabNoteExo))
        {
            //on dessine les lignes
            for($i=0;$i<sizeof($tabUser);$i++)
            {
                if(! in_array(-1,$tabUser))
                {
                    $point2[0]=($i*$largeur_col+40);
                    $point2[1]=(($hauteur-$margey) - ($tabUser[$i] * $echelle));
                    if($i != 0)
                    {
                        $coul=ajouter_hexcouleur($image, $tabCouleurLigne[$tabLegendeCouleur[$exo]]);
                        //$coul=ajouter_hexcouleur($image, $couleurs[1][round($exo%10)]);
                        imageLine($image,$point1[0],$point1[1],$point2[0],$point2[1],$coul);
                    }

                    //label des colonnes
                    $taille_label=imagefontwidth($taillefont) * strlen($i+1);
                    imagestring($image,$taillefont,($largeur_col*$i)+40+$espace_col,$hauteur-($margey),$i+1,$black);
                    //imagestring($image,$taillefont,($largeur_col*$i)+40+$espace_col-(imagefontwidth($taillefont)/2),$point2[1]-15,$points[$i],$red);

                    $point1[0]=$point2[0];
                    $point1[1]=$point2[1];
                }
                else
                    $i=sizeof($tabUser);
            }
        }
    }
    /*********** Fin Multi Ligne *********************/

    //Titre
    $titre=ereg_replace("_"," ",$titre);
    $titre=ereg_replace("'","",$titre);
    $titre=ereg_replace("@","'",$titre);

    ImagePNG($image,"cache/$nomFic");
    ImageDestroy($image);
    print("<img src=\"cache/$nomFic\">\n");
}

?>