<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
   fonctions_tableaux.php :
   Fichier de fonctions permettant de gnrer des tableaux de notes
 
   	@author Elyes FEKI (efeki@afide.fr)
  	@since  feb 2005
 	@package statistiques
 	@modulegroup fonctions
**/

require("../lib/obj_formation.php");



/**
 *  Fonction qui cre une capsule rcapitulative sur les informations d'un groupe
 *  en fonction de la position o on se trouve.
 *
 * @param integer : numero de groupe
 * @param integer : numero de formation
 * @param integer : niveau de dtails
 **/
// position = 0 ; affiche juste le nom de la formation + nom du formateur + nom du groupe
// position = 1 ; affiche tt ce que 0 affiche + type d'valuation
// position = 2 ,; affiche tt ce que 1 affiche + nom de la srie
function statsFormation($num_cal,$position)
{
    global $MSG_17, $MSG_648a,$MSG_635,$MSG_682,$MSG_1737,$MSG_1738,$MSG_1582a ;
    global $typeSerie,$titreSerie ;

     // On rcupere le nom du groupe + nom formateur + nom calendrier + effectif du groupe
    $obj_formation=new Formation($num_cal);
    $nom_cal=$obj_formation->toString();
    $nom_grp=$obj_formation->toString("[groupe]");
    $formateur=$obj_formation->toString("[formateur]");
    $effectif=get_formation_effectif_groupe($num_cal);

    print("<table class=\"tableau_normal\">
                <tr align=\"center\" class=\"couleur2\">
                    <td width=\"50%\"><b>$MSG_635</b></td>
                    <td width=\"50%\">$nom_cal</td>
                </tr>
                <tr align=\"center\" class=\"couleur2\">
                    <td><b>$MSG_17</b></td>
                    <td>$formateur</td>
                </tr>
                <tr align=\"center\" class=\"couleur2\">
                    <td><b>$MSG_682</b></td>
                    <td>$nom_grp ($effectif $MSG_1737)</td>
                </tr>
    ");
    // suivant le niveau de dtails
    switch ($position)
    {
        // 0 : juste l'entete principal
        case 0 :
                print("</table><br>");
                break ;
        // 1 : on ajoute le type d'valuation  l'entete principal
        case 1 :
                print("<tr align=\"center\" class=\"couleur2\">
                            <td><b>$MSG_1738</b></td>
                            <td>$typeSerie</td>
                         </tr>
                         </table><br>");
                break ;
        // 2 : on ajoute le type d'valuation et le titre de la srie  l'entete principal
        case 2 :
                print("<tr align=\"center\" class=\"couleur2\">
                            <td><b>$MSG_1738</b></td>
                            <td>$typeSerie</td>
                         </tr>
                         <tr align=\"center\" class=\"couleur2\">
                            <td><b>$MSG_1582a</b></td>
                            <td>$titreSerie</td>
                         </tr>
                         </table><br>");
                break ;
    }
}



/**
 *  Fonction qui cre une capsule rcapitulative sur les informations d'un stagiaire
 *  en fonction de la position o on se trouve.
 *
 * @param integer : numero d'utlisateur
 * @param integer : numero de formation
 * @param integer : niveau de dtails
 **/

// si position = 1 : premiere niveau : on affiche le nom, prenom + nb formation
// si position = 2 : deuxieme niveau : on affiche le nom, prenom + titre de la formation
// si position = 3 : troisieme niveau : on affiche le nom, prenom + titre de la formation + type de serie
// si position = 4 : test de positionnement : on affiche le nom, prenom + titre de la formation + test de positionnement
function statsStagiaire($utilisateur,$num_cal,$position)
{
    global $nb_formation,$typeSerie ;
    global $MSG_616a, $MSG_667b, $MSG_1739, $MSG_1738, $MSG_1740, $MSG_1741;
    // on recup son nom et son prenom
    $obj_individu=new Individu($utilisateur);
    $stagiaire=$obj_individu->toString("[prenom] [nom]");

    $obj_formation=new Formation($num_cal);
    $nom_cal=$obj_formation->toString();

    print("<br><table class=\"tableau_normal\">
                <tr align=\"center\" class=\"couleur2\">
                    <td width=\"50%\"><b>$MSG_616a</b></td>
                    <td width=\"50%\">$stagiaire</td>
                </tr>
    ");

    // selon le niveau de dtails
    switch ($position)
    {
        // 1 : on affiche le nombre de formation
        case 1 :
            print("<tr align=\"center\" class=\"couleur2\">
                            <td><b>$MSG_667b</b></td>
                            <td>$nb_formation</td>
                    </tr>
                    </table><br>
            ");
            break ;
        // 2 : on affiche le titre de la formation
        case 2 :
            print("<tr align=\"center\" class=\"couleur2\">
                            <td><b>$MSG_1739</b></td>
                            <td>$nom_cal</td>
                     </tr>
                     </table><br>
            ");
            break;
        // 3 : on affiche le titre de la formation et le type de srie
        case 3 :
             print("<tr align=\"center\" class=\"couleur2\">
                            <td><b>$MSG_1739</b></td>
                            <td>$nom_cal</td>
                     </tr>
                     <tr align=\"center\" class=\"couleur2\">
                            <td><b>$MSG_1738</b></td>
                            <td>$typeSerie</td>
                     </tr>
                     </table><br>
            ");
            break;
        // 4 : on affiche le titre de la formation et que c'est un test de posit
        case 4 :
             print("<tr align=\"center\" class=\"couleur2\">
                            <td><b>$MSG_1739</b></td>
                            <td>$nom_cal</td>
                     </tr>
                     <tr align=\"center\" class=\"couleur2\">
                            <td><b>$MSG_1740</b></td>
                            <td>$MSG_1741</td>
                     </tr>
                     </table><br>
            ");
            break;
    }
}



/**
 *  Fonction qui cree un lien contenant tout les numeros de srie d'un tableau
 *
 * @param array : tableau contenant tt les numeros de srie
 *
 * @return string : chaine de caractere  passer en parametre dans un lien href
 **/
function creeLien($tab_num)
{
  $lien;
  for($i=0;$i<sizeof($tab_num);$i++)
  {
    if($i == 0)
      $lien="tabSerie[0]=$tab_num[0]";
    else
      $lien .= "&tabSerie[$i]=$tab_num[$i]";
  }
  return($lien);
}


/**
 *  Fonction qui vrifie si la srie d'un calendrier est alatoire
 *
 * @param integer : numero de formation
 * @param integer : numero de serie
 * @param integer : met a jour le mode alatoire (0 : normal, 1 : monotheme, 2 : multitheme, 3 : test de positionnement)
 *
 * @return boolean
 **/
function estAleatoire($calendrier,$serie,&$mode_aleatoire)
{
    $aleatoire=0;
    // 1 - test si serie existante en mode alatoire
        //$sql="select * from gestserie where num_serie=$serie and num_cal=$calendrier and aleatoire='t'";
        //$res=pg_query($sql);
    $res=get_serie_aleatoire_formation($serie,$calendrier);
    if(pg_numrows($res)==1)
    {
        $mode_aleatoire=0;
        return 1;
    }

    // 2 - test si serie aleatoire monotheme ou multitheme
        //$sql="select distinct mode from serie_aleatoire where num_serie=$serie";
        //$res=pg_query($sql);
    $res=get_serie_mode_aleatoire($serie);
    if(pg_numrows($res)==1)
    {
        $row=pg_fetch_row($res,0);
        $mode_aleatoire=$row[0];
        return 1;
    }

    // 3 - Test si serie gnre par un test de positionnement

        // recup du parcours
        $current_formation=new Formation($calendrier);
        $parcours=$current_formation->getParcours();
        //recup du type d'etape

                //$sql="select distinct type_etape from gestparcours where g_num_parcours=$parcours and num_c_q_e_d=$serie";
                //$restype=pg_query($sql);

        $restype=get_parcours_type_etape_serie($parcours,$serie);
        $rowtype=pg_fetch_row($restype,0);
        if($rowtype[0]=='C')
        {

                //$sql="select * from asso_exo_serie_aleatoire where id_serie=$serie and num_cal=$calendrier";
                //$res=pg_query($sql);
            $res=get_serie_formation($serie,$calendrier);
            if(pg_numrows($res)>=0)
            {
                //echo "serie=$serie";
                $mode_aleatoire=3;
                return 1;
            }
        }
}


/**
 *  Fonction qui rcupre toutes les sries effectues soit pour un groupe, soit pr un utilisateur
 *  et qui les rpartie selon leurs types dans diffrents tableaux
 *
 * @param integer : numero de formation
 * @param integer : numero de stagiaire
 * @param array : tableau vide mis  jour avec les numeros de srie de remplir les blancs
 * @param array : tableau vide mis  jour avec les numeros de srie de sondages
 * @param array : tableau vide mis  jour avec les numeros de srie de src
 * @param array : tableau vide mis  jour avec les numeros de srie de qcm
 * @param array : tableau vide mis  jour avec les numeros de srie de qrc
 * @param array : tableau vide mis  jour avec les numeros de srie de drag & drop
 * @param array : tableau vide mis  jour avec les numeros de srie de multisrie
 * @param array : tableau vide mis  jour avec les numeros de srie de srie alatoire
 * @param array : tableau vide mis  jour avec les numeros de srie de srie alatoire monotheme
 * @param array : tableau vide mis  jour avec les numeros de srie de srie alatoire multitheme
 **/

function repartirSerie($calendrier,$utilisateur,&$tab_f,&$tab_s,&$tab_o,&$tab_q,&$tab_m,&$tab_d,&$tab_multi,&$tab_aleat,&$tab_aleat_mono,&$tab_aleat_multi)
{
    // recupere les diffrentes sries soit d'un groupe si la variable utilisateur est vide, soit d'un utilisateur, pour une formation donne
    if($utilisateur=="")
            $res_serie = get_formation_series_notees($calendrier);
    else
            $res_serie = get_stagiaire_series_notees_formation($utilisateur,$calendrier);

    $nb_serie = pg_num_rows($res_serie);

    for($i=0;$i<$nb_serie;$i++)
    {
        $row = pg_fetch_row($res_serie,$i);
        $num_serie = $row[0];

        //verifie si la serie est aleatoire
        if(estAleatoire($calendrier,$num_serie,$mode_aleat))
        {
            switch ($mode_aleat)
            {
                case 0 : $tab_aleat[]=$num_serie ; break ;
                case 1 : $tab_aleat_mono[]=$num_serie ; break ;
                case 2 : $tab_aleat_multi[]=$num_serie ; break ;
            }
        }
        else
        {
            // on recupere le nombre diffrent de type d'exo dans la srie
            if($utilisateur=="")
                $res_type = get_serie_type_formation($num_serie,$calendrier);
            else
                $res_type = get_serie_type_stagiaire_formation($num_serie,$calendrier,$utilisateur);

            $nb_type=pg_num_rows($res_type);

            //Dans le cas o il y'a qu'un seul type d'exo, on inclut la serie dans la rubrique correspondante
            if($nb_type==1)
            {
                $row = pg_fetch_row($res_type,0);
                $type=$row[0];

                switch($type){
                    case 'f' :  $tab_f[]=$num_serie ; break ;
                    case 's' : $tab_s[]=$num_serie ; break ;
                    case 'o' :  $tab_o[]=$num_serie ; break ;
                    case 'q' :  $tab_q[]=$num_serie ; break ;
                    case 'm' :  $tab_m[]=$num_serie ; break ;
                    case 'd' :  $tab_d[]=$num_serie ; break ;
                }
            } // fin traitement srie a un type d'exo

            // Dans le cas o c'est une multiserie a 2 exo, on vrifie si l'un des 2 exo est un sondage
            // auquel cas on ajoute la serie  sondage et le deuxieme exo dans sa rubrique correspondante
            // sinon on classe la srie dans le tableau de multiserie (tab_multi)
            if($nb_type==2)
            {
                // on recup l'un des types de la serie
                $row = pg_fetch_row($res_type,0);
                $type1 = $row[0];
                // on recup l'autre des types de la serie
                $row = pg_fetch_row($res_type,1);
                $type2 = $row[0];
                // si aucune des deux n'est un sondage, on classe la serie ds multiserie
                if(($type1!='s') && ($type2!='s'))
                {
                    $tab_multi[]=$num_serie ;
                }
                else
                {
                    // sinon on ajoute la serie ds sondage
                    $tab_s[]=$num_serie ;
                    // on recupere le type qui n'est pas un sondage
                    if($type1=='s') $type_a_classer = $type2 ;
                    else $type_a_classer = $type1 ;
                    // on l'insere ds le tableau correspondant
                    switch($type_a_classer)
                    {
                        case 'f' :  $tab_f[]=$num_serie ; break ;
                        case 'o' :  $tab_o[]=$num_serie ; break ;
                        case 'q' :  $tab_q[]=$num_serie ; break ;
                        case 'm' :  $tab_m[]=$num_serie ; break ;
                        case 'd' :  $tab_d[]=$num_serie ; break ;
                    }
                }
            } // fin traitement serie ou multiserie a 2 types exos

            // Dans le cas ou c'est une multiserie a + de 2 exo, on vrifie s'il y'a au moins une tape sondage,
            // si oui, on rajoute le num_serie ds le tableau de sondage (tab_s)
            // dans tous les cas on rajoute le num_serie au tableau de multiserie (tab_multiserie)
            if($nb_type>2)
            {
                $z=0 ;
                do
                {
                    $row = pg_fetch_row($res_type,$z);
                    if($row[0]=='s')
                        $tab_s[]=$num_serie ;
                    $z++ ;
                } while(($z<$nb_type)&&($row[0]!='s'));
                $tab_multi[]=$num_serie ;
            } // fin traitement multiserie a + de 2 types exo
        }
    }
}




/**
 *  Fonction qui rcupre toutes les notes d'un type srie, calcule la moyenne, et affiche un tableau
 *
 * @param integer : numero de groupe
 * @param integer : numero de stagiaire
 * @param integer : numero de formation
 * @param array : tableau contenant tout les numeros de srie
 * @param integer : niveau de dtails : si 1 on affiche le tableau, si 0 on rcupere juste la moy
 *
 * @return integer : moyenne generale
 * @return string : tableau de notes
 **/
function tableauNotes($groupe,$utilisateur,$calendrier,$tabSerie,$details,$archive=0)
{
    global $MSG_904, $MSG_203,$MSG_901,$FORM_1,$FORM_1a,$MSG_1742,$MSG_1743;
    global $moyenne_groupe, $nb_tableaux, $tab_points, $tab_libelles, $typeSerie;
    global $stats;

    // si le type de serie contient au moins une serie, on affiche le tableau de notes
    if(sizeof($tabSerie)>0)
    {
       //entete du tableau
        $affichage="
            <table class=\"tableau_espace\">
                <tr>
                    <th width=\"45%\">$typeSerie</th>
                    <th width=\"25%\">$MSG_901</th>";
        if($utilisateur=="")
            $affichage.="<th width=\"30%\">$FORM_1a</th></tr>";
        else $affichage.="</tr>";

        $somme_generale=0;

        for($i=0;$i<sizeof($tabSerie);$i++)
        {
            // on rcupere le titre de la serie
            $obj_serie=new Serie($tabSerie[$i]);
            $titre=$obj_serie->toString();

            // On rcupere la moyenne de la serie courante
            if($utilisateur=="")
                $res_moy = get_serie_moyenne_formation($tabSerie[$i],$calendrier);
            else
                $res_moy = get_serie_moyenne_stagiaire_formation($tabSerie[$i],$calendrier,$utilisateur);

            $row_moy=pg_fetch_row($res_moy,0);
            $moyenne_serie=(round($row_moy[0]*100))/100;

            //Pour le graphique on mmorise la note ds un tableau
            $tab_points[]=$moyenne_serie ;
			if(CHARSET=='UTF-8')
				$titre=utf8_decode($titre);
            $tab_libelles[]=$titre ;

            //On affiche le resultat obtenu
            $affichage.="
            <tr align=\"center\" class=\"couleur3\">
                <td>$titre</td>
                <td>$moyenne_serie</td>";
            if($utilisateur=="")
                $affichage.="
                    <td><a class=\"action\" href=\"details_serie.php?stats=$stats&num_grp=$groupe&id_serie=$tabSerie[$i]&num_cal=$calendrier&typeSerie=$typeSerie&titreSerie=$titre&moy=$moyenne_serie&archive=$archive\">$MSG_1742</a></td>
                </tr>";
            else $affichage.="</tr>";

            //On ajoute la moyenne de la serie  somme gnrale de ttes les series du type de serie trait
            $somme_generale+=$moyenne_serie ;
       }

        // On calcule la moyenne generale pour le type trait et on l'arrondit
        $moyenne_generale=$somme_generale/sizeof($tabSerie);
        $moyenne_generale=(round($moyenne_generale*100))/100;

        // On affiche la dernire ligne du tableau
        $affichage.="
            <tr class=\"couleur2\" align=\"center\">
                <td><b>$MSG_1743</b></td>
                <td><b>$moyenne_generale</b></td>";
        if($utilisateur=="")
            $affichage.="<td>&nbsp;</td>
                    </tr>
                </table>";
        else $affichage.="</tr></table>";

        // On met  jour la moyenne du Groupe
        $moyenne_groupe+=$moyenne_generale ;
        $nb_tableaux++;
    }

    if($details==1)
        return $affichage ;
    else
        return $moyenne_generale ;
}



/**
 *  Fonction qui affiche un tableau pour les sondages qui contient le nom des sries,
 *  le nombre de votant et le pourcentage
 *
 * @param integer : numero de calendrier
 * @param array : tableau contenant tout les numeros de sondages
 *
 * @return string : tableau de sondages
 **/
function tableauSondage($calendrier,$tabSondage,$utilisateur,$archive=0)
{
    global $stats, $num_grp;
    global $MSG_203, $FORM_1,$MSG_1483,$MSG_1744,$MSG_1215,$FORM_1a,$FORM_3b,$MSG_1745;
    // si le type de serie contient au moins une serie, on affiche le tableau de notes
    if(sizeof($tabSondage)>0)
    {
        //entete du tableau
        $affichage="
            <table class=\"tableau_espace\">
                <tr>
                    <th width=\"50%\">$MSG_1483</th>
        ";
        if($stats=="formations")
            $affichage.="
                    <th width=\"33%\">$MSG_1744</th>
                    <th width=\"17%\">$MSG_1215</th>";
        $affichage.="
                    <th width=\"16%\">$FORM_1a</th>
                </tr>
        ";

        $effectif=get_formation_effectif_groupe($calendrier);

        for($i=0;$i<sizeof($tabSondage);$i++)
        {
            // on rcupere le titre de la serie
            $obj_serie=new Serie($tabSondage[$i]);
            $titre=$obj_serie->toString();

            // on recupere l'ensemble des votants
            $res_nbvotant = get_sondage_nbvotant_formation($tabSondage[$i],$calendrier);
            $nb_votant=pg_fetch_row($res_nbvotant,0);

            $pourcentage=$nb_votant[0]/$effectif*100 ;
            $pourcentage=(round($pourcentage*100))/100;



            $affichage.="
                <tr class=\"couleur3\"  align=\"center\">
                    <td>$titre</td>";
            if($stats=="formations")
                $affichage.="
                    <td>$nb_votant[0]</td>
                    <td>$pourcentage %</td>";
            $affichage.="
                    <td><a class=\"action\" href=\"details_type.php?stats=$stats&utilisateur=$utilisateur&type=sondage&num_grp=$num_grp&id_serie=$tabSondage[$i]&num_cal=$calendrier&typeSerie=Sondage&titreSerie=$titre&archive=$archive\">$FORM_3b</a></td>
                </tr>
            ";
        }
        $affichage.="
                </table>
        ";

    }
    else
        $affichage="<br><b>$MSG_1745.</b><br>";
    return $affichage ;
}


/**
 *  Fonction qui affiche un tableau pour les exotlc
 *
 * @param integer : numero de groupe
 * @param integer : numero d'utilisateur
 * @param integer : numero de calendrier
 * @param integer : niveau de dtails : 1 : affichage du tableau, 0 : recupere la moyenne
 *
 * @return string : tableau de exotlc
 * @return integer : moyenne des exotlc
 **/
function tableauTP($groupe,$utilisateur,$calendrier,$details,$archive=0)
{
    global $typeSerie,$moyenne_groupe,$nb_tableaux,$tab_points,$tab_libelles,$stats ;
    global $MSG_576, $MSG_1246,$MSG_1248,$MSG_901, $FORM_1a,$MSG_1244,$MSG_1245,$MSG_1742,$MSG_1743 ;

    // on recupere les numeros, le titre et le mode rendu du TP pour la formation donne [et l'utilisateur donn]
    if($utilisateur=="")
        $res=get_formation_exercices_telecharges($calendrier);
    else
        $res=get_stagiaire_exercices_telecharges_formation($utilisateur,$calendrier);

    $nb=pg_numrows($res);

    // si on a au moins 1 exercice  tlcharger
    if($nb>0)
    {
        // affichage de l'entete du tableau
        if($utilisateur=="")
            $affiche="<table class=\"tableau_espace\">
                            <tr>
                                <th width=\"33%\">$typeSerie</th>
                                <th>$MSG_576</th>
                                <th>$MSG_1246</th>
                                <th>$MSG_1248</th>
                                <th>$MSG_901</th>
                                <th>$FORM_1a</th>
                            </tr>";
        else
            $affiche="<table class=\"tableau_espace\">
                            <tr>
                                <th width=\"33%\">$typeSerie</th>
                                <th>$MSG_576</th>
                                <th>$MSG_901</th>
                            </tr>";

        // on initialise la moy general des exercices  0
        $general=0 ;
        // on recupere l'effectif du groupe qui suit la formation
        $effectif=get_formation_effectif_groupe($calendrier);

        // pour chaque exercice
        for($i=0;$i<$nb;$i++)
        {
                $row=pg_fetch_row($res,$i);
                $titreExo = $row[1] ;
                $modeExo = $row[2] ;
                $numExo=$row[0];

                // selon le mode de rendu on affiche ce qui correspond
                if($modeExo=="pf")
                    $modeStrExo="$MSG_1244" ;
                else $modeStrExo="$MSG_1245" ;

                // on recupere le score et le nombre max de points pour un exercice donn et une formation [et un utilisateur]
                if($utilisateur=="")
                    $res_note_totale=get_formation_scores_exercice($calendrier,$numExo);
                else
                    $res_note_totale=get_stagiaire_scores_exercice_formation($utilisateur,$calendrier,$numExo);

                $nb_note_totale=pg_numrows($res_note_totale);

                // on initialise la moyenne de cette exercice prcis
                $total=0 ;


                // on recupere les scores qu'on met sur 20 et qu'on ajoute  $total.
                for($j=0;$j<$nb_note_totale;$j++)
                {
                    $row_note=pg_fetch_row($res_note_totale,$j);
                    $note=$row_note[0]*20/$row_note[1];
                    $total+=$note ;
                }

                // on calcul la moyenne de cette exercice prcis
                $moy=(round($total/$nb_note_totale*100))/100 ;


                // on ajoute le titre et la moyenne de l'exercice ds nos tableaux pour la conception du graphique
				if(CHARSET=='UTF-8')
				$titreExo=utf8_decode($titreExo);
                $tab_libelles[]=$titreExo ;
                $tab_points[]=$moy;

                // si l'exercice est de type plate forme on calcul le pourcentage de nombre de stagiaire l'ayant rendu
                if($modeExo=="pf")
                {
                    $res_rendu=get_formation_nb_exercices_rendus($calendrier,$numExo);
                    $row=pg_fetch_row($res_rendu,0);
                    $rendu=round($row[0]/$effectif*100)." %" ;
                }
                else $rendu="-";

                // on calcul le pourcentage de nombre de stagiaire ayant t corrig
                $res_corr=get_formation_nb_exercices_corriges($calendrier,$numExo);
                $row=pg_fetch_row($res_corr,0);
                $corr=round($row[0]/$effectif*100)." %" ;

                // on affiche la ligne courante
                if($utilisateur=="")
                    $affiche.="<tr class=\"couleur3\">
                                    <td>$titreExo</td>
                                    <td align=\"center\">$modeStrExo</td>
                                    <td align=\"center\">$rendu</td>
                                    <td align=\"center\">$corr</td>
                                    <td align=\"center\">$moy</td>
                                    <td align=\"center\"><a class=\"action\" href=\"details_serie.php?stats=$stats&type=tp&typeSerie=$typeSerie&num_grp=$groupe&titreSerie=$titreExo&num_cal=$calendrier&num_exo=$numExo&moy=$moy&archive=$archive\">$MSG_1742</a></td>
                                </tr>";
                else
                    $affiche.="<tr class=\"couleur3\">
                                    <td>$titreExo</td>
                                    <td align=\"center\">$modeStrExo</td>
                                    <td align=\"center\">$moy</td>
                                </tr>";

                // on ajoute la moyenne de l'exercice courant  la moyenne generale
                $general+=$moy ;
        }

        // on calcul la moyenne gnrale de tt les exercices
        $general=$general/$nb ;
        $general=(round($general*100))/100;
        // on affiche la derniere ligne du tableau
        if($utilisateur=="")
            $affiche.="<tr class=\"couleur2\" align=\"center\">
                                    <td colspan=\"4\"><b>$MSG_1743</b></td>
                                    <td><b>$general</b></td>
                                    <td>&nbsp;</td>
                        </tr>
                    </table>";
        else
            $affiche.="<tr class=\"couleur2\" align=\"center\">
                                    <td colspan=\"2\"><b>$MSG_1743</b></td>
                                    <td><b>$general</b></td>
                        </tr>
                    </table>";

        // on met a jour la moyenne du groupe
        $moyenne_groupe+=$general ;
        $nb_tableaux++ ;

        if($details==0)
            return $general ;
        else
            return $affiche ;
     }

}


// rcuperer la ractivit du formateur ds tableauExos et l'adapter  tableauTP...
/*
function tableauExos($groupe,$utilisateur,$calendrier,$details)
{
    global $MSG_902,$MSG_903,$MSG_576,$MSG_203,$MSG_1246,$MSG_1248;
    global $MSG_1244,$MSG_1245,$MSG_862b,$MSG_901,$FORM_1,$MSG_1247,$FORM_3b;
    global $moyenne_groupe,$nb_tableaux,$tab_points,$tab_libelles,$typeSerie ;
    global $stats;

    $tab_points=array();
    $tab_libelles=array();

    echo "<br><br>Ancienne fonction de  calcul de moyenne<br><br>";

    if($utilisateur=="")
        $req_exo="SELECT DISTINCT num_exo,titre
            FROM exotlc e, gestexotlc ge, gestionnaire g,gestparcours gp
            WHERE g.g_num_parcours = gp.g_num_parcours
            AND type_etape='E'
            AND num_c_q_e_d = num_exo
            AND g_num_gest_g = '$groupe'
            AND g_num_cal = '$calendrier'
            AND gesttlc_user IN (SELECT gu_num_user FROM gestionutil WHERE gu_num_gest_gr = '$groupe')";
    else
        $req_exo="SELECT DISTINCT num_exo,titre
            FROM exotlc e, gestexotlc ge, gestionnaire g,gestparcours gp
            WHERE g.g_num_parcours = gp.g_num_parcours
            AND type_etape='E'
            AND num_c_q_e_d = num_exo
            AND g_num_gest_g = '$groupe'
            AND g_num_cal = '$calendrier'
            AND gesttlc_user = '$utilisateur'";



    $resul=pg_query($req_exo);
    $nb=pg_numrows($resul);
    //echo "nb=$nb<br>";

    if($nb != 0){

    //debut du tableau
    $affiche="<table border=\"1\" width=\"75%\">
                        <tr bgcolor=\"#E8E8E8\">
                            <td align=\"center\" width=\"33%\"><b>$typeSerie</b></td>
                            <td align=\"center\"><b>Mode</b></td>
                            <!--<td align=\"center\">Ractivit du formateur</td>-->
                            <td align=\"center\"><b>Rendu</b></td>
                            <td align=\"center\"><b>Corrig</b></td>
                            <!--<td align=\"center\">$MSG_862b</td>-->
                            <td align=\"center\"><b>Moyenne</b></td>
                            <!--<td align=\"center\"><b>$FORM_1</b></td>-->
                        </tr>";

    $tabExo=array();
    $score_exo_total=0;
    $score_exo_total_possible=0;

    for($i=0;$i<$nb;$i++){
        $rowresult=pg_fetch_row($resul,$i);
        $tabExo[$i]=$rowresult[0];

        //Quel est le mode de rendu de l'exo
        $resexo=pg_query("select mode_rendu from exotlc where num_exo=$rowresult[0];");
        $rowexo=pg_fetch_row($resexo,0);
        switch($rowexo[0]) {
                case "pf" : $mode=$MSG_1244;
                                break;
                default : $mode=$MSG_1245;
                            break;
        }
        //echo "exo=$rowresult[0] - grp=$groupe<br>";
        if($utilisateur=="")
            $req_score_exo="SELECT resultat, notesur
                        FROM exotlc, gestexotlc
                        WHERE gesttlc_exo = num_exo
                        AND num_exo = $rowresult[0]
                        AND gesttlc_user IN(
                            SELECT gu_num_user FROM gestionutil
                            WHERE gu_num_gest_gr = '$groupe')";
        else
            $req_score_exo="SELECT resultat, notesur
                        FROM exotlc, gestexotlc
                        WHERE gesttlc_exo = num_exo
                        AND num_exo = $rowresult[0]
                        AND gesttlc_user = $utilisateur";


        $resul2=pg_query($req_score_exo);
        $nb2=pg_numrows($resul2);
        //echo "nb2=$nb2<br>";
        $score_exo=0;
        $score_exo_possible=0;
        for($j=0;$j<$nb2;$j++){
        $rowresult2=pg_fetch_row($resul2,$j);
        $score_exo += $rowresult2[0];
        $score_exo_possible += $rowresult2[1];
        }
        //echo "score exo=$score_exo<br>score_exo_possible=$score_exo_possible<br>";
        $score_exo_total+=$score_exo;
        $score_exo_total_possible+=$score_exo_possible;
        //echo "score_exo_total=$score_exo_total<br>score_exo_total_possible=$score_exo_total_possible<br>";

        $tab_Moyenne_Couleur=calculMoyenne($score_exo,$score_exo_possible);
        $moyenne=$tab_Moyenne_Couleur[0];
        $bgcolor=$tab_Moyenne_Couleur[1];

        //nom de l'exo pouvant etre pass comme parametre a un script
        $nom_exo=ereg_replace(' ','__',$rowresult[1]);
        //$nom_exo=htmlentities($nom_exo);
        $affiche.="<tr>
                            <td align=\"center\">$rowresult[1]</td>
                            <td align=\"center\">$mode</td>";

        //***************************
                STAT RENDU
        //***************************
        if($rowexo[0]=="pf"){
            $nbpf++;
            $resstag1=pg_query("select num_user,nom,prenom from utilisateurs where categorie like '%u%' and num_user in(select distinct gu_num_user from gestionutil gu,utilisateurs u where gu_num_gest_gr in
                                                    (select distinct g_num_gest_g from gestionnaire where g_num_cal=$calendrier));");
            $nbstag1=pg_numrows($resstag1);
            //echo "nbstag1=$nbstag1<br>";
            $cpt1=0;
            $cpt2=0;
            for($c=0;$c<$nbstag1;$c++){
                $rowstag1=pg_fetch_row($resstag1,$c);
                $resrendu=pg_query("select * from reception_exostlc where num_stag=$rowstag1[0] and num_exo=$rowresult[0] and num_cal=$calendrier;");
                $nbrendu=pg_numrows($resrendu);
                $numstag=$rowstag1[0];
                //si le stagiaire a rendu son exo
                if($nbrendu!=0){
                                        $rowrendu=pg_fetch_row($resrendu,0);
                                        $daterendu=$rowrendu[3];
                                        $ok=1;
                                        $rescorr=pg_query("select num_user,date_correction from resexouser where num_user='$numstag' AND num_exo='$rowresult[0]' AND num_cal='$calendrier';");
                                        $nbcorr=pg_numrows($rescorr);
                                        if($nbcorr==0){
                                                    $cpt1++;
                                                    $ok=0;
                                        }
                                        else {
                                                    $rowcorr=pg_fetch_row($rescorr,0);
                                                    $datecorr=$rowcorr[1];
                                                    $ok=1;
                                                    $cptdate++;
                                        }
                            }
                            else {
                                        $cpt2++;
                                        $ok=0;
                            }
                            //gestion de la ractivit du formateur
                            if($ok==1){
                                        $totaldate=($datecorr-$daterendu)+$totaldate;
                            }
                }
                //nbre de stagiaire ayant rendu leur TP (en %)
                $rendu=$nbstag1-$cpt2;
                $rendu=($rendu/$nbstag1)*10;
                $rendu=intval($rendu*100)/10;
                /////////////////////////////////////////
                //ractivit du formateur
                ////////////////////////////////////////
                if($cptdate==0)$cptdate=1;
                $totaldate=$totaldate/$cptdate;
                $totaldateTP=$totaldateTP+$totaldate;
                $nbminute=intval($totaldate/60);
                $nbheure=intval($nbminute/60);
                $nbjour=intval($nbheure/24);
                if($nbjour>=1){
                            //$nbheure=$nbheure-(24*$nbjour);
                            $reste=$totaldate-(24*60*60*$nbjour);
                            $nbheure=intval(($reste/60)/60);
                            $reste=$reste-(60*60*$nbheure);
                            $nbminute=intval($reste/60);
                }
                else if($nbheure>=1){
                            $reste=$totaldate-(60*60*$nbheure);
                            $nbminute=intval($reste/60);
                }

        //$affiche.=("\t<td align=\"center\">");
        //if($nbjour>=1){
        //        $affiche.=("<b>$nbjour</b> jour(s)");
        //}
        //if($nbheure>=1){
         //       $affiche.=(" <b>$nbheure</b> heure(s)");
        //}
        //$affiche.=(" <b>$nbminute</b> minute(s)");
        //$affiche.=("</td>\n");
        $affiche.=("\t<td align=\"center\">$rendu %</td>\n");
        $totalrendu=$totalrendu+$rendu;
        $cptrendu++;
        }
        else  {
        //$affiche.=("\t<td align=\"center\"> - </td>\n");
        $affiche.=("\t<td align=\"center\"> - </td>\n");
        }


        //***************************
                STAT CORRIGER
        //***************************
        //On rcupre les stagiaires de ce calendrier
        $cpt=0;
            $resstag1=pg_query("select num_user,nom,prenom from utilisateurs where categorie like '%u%' and num_user in(select distinct gu_num_user from gestionutil gu,utilisateurs u where gu_num_gest_gr in
                                                    (select distinct g_num_gest_g from gestionnaire where g_num_cal=$calendrier));");
            $nbstag=pg_numrows($resstag1);
            $nbstag1=$nbstag;
            for($c=0;$c<$nbstag;$c++){
                $rownoms=pg_fetch_row($resstag1,$c);
                $numstag=$rownoms[0];
                $rescorr=pg_query("select num_user,date_correction from resexouser where num_user='$numstag' AND num_exo='$rowresult[0]' AND num_cal='$calendrier';");
                $nbcorr=pg_numrows($rescorr);
                if($nbcorr!=0){
                            $cpt++;
                }
            }
                //nbre de stagiaire corrigs (en %)
                $corr=$cpt;
                $corr=($corr/$nbstag1)*10;
                $corr=intval($corr*100)/10;
                if($corr==100) $couleur="<font color=\"#EE0000\">";
                $totalcorr=$totalcorr+$corr;
        $affiche.=("\t<td align=\"center\">$corr %</td>\n");
        //$affiche.=("\t<td align=\"center\">$score_exo / $score_exo_possible</td>\n");
        $affiche.=("\t<td align=\"center\">$moyenne</td>\n");
        $affiche.=("\t<!--<td align=\"center\">$FORM_3b</td>-->\n");
        $affiche.=("</tr>\n\n");
        $tab_libelles[$i]=$rowresult[1];
        $tab_points[$i]=$moyenne;
    }

    if($score_exo_total_possible != 0){
        //$moyenne=sprintf("%.2f",($score_exo_total * (20 / $score_exo_total_possible)));
        $moyenne=$score_exo_total * (20 / $score_exo_total_possible);
        $moyenne=(round($moyenne*100))/100;
        //if($moyenne <10)$bgcolor="$mauvaise_reponse";
        //else $bgcolor="$bonne_reponse";
    }else{
        $moyenne = "X";
        //$bgcolor="#FFFFFF";
    }
    $totalcorr=$totalcorr/$nb;
    $totalcorr=intval($totalcorr*100)/100;
    $lien=creeLien($tabExo);
    $lien2=creeLien($points);
    $lien=ereg_replace("tab_num_qstaire","tab_num_exo",$lien);
    $lien2=ereg_replace("tab_num_qstaire","points",$lien2);
    $affiche.=("<tr>\n");
    $affiche.=("\t<td align=\"center\" colspan=\"2\" bgcolor=\"#E8E8E8\"><b>Moyenne totale</b></font></td>\n");
    //$affiche.=("\t<td align=\"center\"><b> $MSG_1247</b></td>\n");

    //ractivit moyenne
    //echo "nbpf=$nbpf<br>";

    //if($nbpf=="" || $nbpf==0)
    //    $nbpf=1;

    $totaldateTP=$totaldateTP/$nbpf;
                $nbminute=intval($totaldateTP/60);
                $nbheure=intval($nbminute/60);
                $nbjour=intval($nbheure/24);
                if($nbjour>=1){
                            //$nbheure=$nbheure-(24*$nbjour);
                            $reste=$totaldateTP-(24*60*60*$nbjour);
                            $nbheure=intval(($reste/60)/60);
                            $reste=$reste-(60*60*$nbheure);
                            $nbminute=intval($reste/60);
                }
                else if($nbheure>=1){
                            $reste=$totaldateTP-(60*60*$nbheure);
                            $nbminute=intval($reste/60);
                }
        //$affiche.=("\t<td align=\"center\">");
        //if($nbjour>=1){
        //        $affiche.=("<b>$nbjour</b> jour(s)");
        //}
        //if($nbheure>=1){
        //        $affiche.=(" <b>$nbheure</b> heure(s)");
        //}
        //$affiche.=(" <b>$nbminute</b> minute(s)");
        //$affiche.=("</td>\n");

    $affiche.=("\t<td align=\"center\"  bgcolor=\"#E8E8E8\"><b>$totalrendu %</b></font></td>\n");
    $affiche.=("\t<td align=\"center\" bgcolor=\"#E8E8E8\"><b> $totalcorr %</b></font></td>\n");
    //$affiche.=("\t<td align=\"center\"><b> $score_exo_total / $score_exo_total_possible </b></td>\n");
    $affiche.=("\t<td align=\"center\"  bgcolor=\"#E8E8E8\"><b> $moyenne </b></td>\n");
    $affiche.=("\t<!--<td align=\"center\" bgcolor=\"#E8E8E8\">&nbsp;</td>-->\n");
    $affiche.=("</tr>\n\n");
    $affiche.=("</table>\n");
    if($moyenne!='X'){
        $moyenne_groupe+=$moyenne ;
        $nb_tableaux++ ;
    }

    }
    if($details==1) return $affiche ;
    else return $moyenne ;
}

// fonction necessaire  tableauExos()
function calculMoyenne($score, $max){
  $tabRetour=array();
  $tabRetour[0]="X";
  $tabRetour[1]="#FFFFFF";

  global $bonne_reponse;
  global $mauvaise_reponse;

  if($max != 0){
    $moy=($score * (20/$max));
    $moy *= 100;
    $moy=round($moy);
    $moy /= 100;
    $tabRetour[0]=$moy;
    if($tabRetour[0]<10){
      $tabRetour[1]="$mauvaise_reponse";
    }
    else $tabRetour[1]="$bonne_reponse";
  }
  return($tabRetour);
}
*/

?>