<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

 /**
       @package statistiques
       @modulegroup plpgsql
       @module plpgsql_statistiques
*/



/*-----------------------------------------------------------------------------------------*/
//                         LES FONCTIONS  D'ACCESS AUX FONCTIONS PLPGSQL
/*-----------------------------------------------------------------------------------------*/
/*
                            DOIVENT RETOURNER UNE VARIABLE
*/
/*
CONVENTION DE NOMAGE :
Il faut tablir une correspondance entre le nom de la fonction php et le nom de la fonction
PLPGSQL. Ainsi, on utilisera le meme nom pour les 2 fonctions, a ceci prs que le nom de
 la fonction PLPGSQL est precede de _af_ afin de la distinguer des fonctions systeme.
Exemple:

la fonction php function check_access($droit, $cal, $user) correspond  _af_check_access dans la base

*/
/**
*   obtenir la liste des sries d'une formation ainsi que sa note sur 20 (OLD)
*
*   Retourne les numros de sries ainsi que leur note.
*
*    @param  integer : le numro de formation
*    @return integer : liste de numro de sries et de notes
*/
function stats_series_formation_old($calendrier)
{
            $sql_serie="select id_serie, score
                                    from res_serie
                                    where id_formation='$calendrier'
                                    and score >=0
                                    and date_fin >0";

            return(pg_query($sql_serie));
}
/**
*   obtenir la liste des sries d'une formation ainsi que sa note sur 20
*
*   Retourne les numros de sries ainsi que leur note.
*
*    @param  integer :  le numro de formation
*     @return integer : liste de numro de sries et de notes
*/
function stats_series_formation($calendrier)
{
            if(VERSION_BASE>VERSION)
            {
                        $liste_series_form="SELECT * from _af_stats_series_formation($calendrier) AS (serie smallint,score real)";
                        $res_liste_series_form = pg_query($liste_series_form);
            }
            else
                        $res_liste_series_form=stats_series_formation_old($calendrier);
            return ($res_liste_series_form);
}

 /**
*   obtenir la liste des exercices  tlcharger d'une formation, le score et le nombre de point de l'exercice (OLD)
*
*   Retourne les numros d'exercices, le score et le nombre de points
*
*    @param  integer : le numro de formation
*    @return integer : liste des numros d'exercices , leur score et points maximum
*/
function stats_exos_formation_old($calendrier)
{
            $sql_exo="select num_exo,score, surtotal
                                    from resexouser
                                    where num_cal='$calendrier'
                                    and surtotal<>0";
            return(pg_query($sql_exo));
}

/**
*   obtenir la liste des exercices  tlcharger d'une formation, le score et le nombre de point de l'exercice
*
*   Retourne les numros d'exercices, le score et le nombre de points
*
*    @param  integer :  le numro de formation
*    @return integer : liste des numros d'exercices , leur score et points maximum
*/
function stats_exos_formation($calendrier)
{

            if(VERSION_BASE > VERSION)
            {
                        $liste_exos_form="SELECT * from _af_stats_exos_formation($calendrier) AS (num_exo integer, note integer, point integer)";
                        $res_liste_exos_form = pg_query($liste_exos_form);
            }
            else
                        $res_liste_exos_form=stats_exos_formation_old($calendrier);

            return ($res_liste_exos_form);
}

/**
*  Obtenir la note sur 20 d'une srie d'une formation (OLD)
*
*  Renvoie la liste des notes d'une srie d'une formation
*
* @param integer : numro de formation
* @param integer : numro de srie
* @return integer : liste de note sur 20
*/
function stats_serie_formation_old($form,$serie)
{
            $req="select score
            from res_serie
            where id_formation='$form'
            and id_serie='$serie'
            and score>=0";
            $res=pg_query($req);
            return($res);
}

/**
*  Obtenir la note sur 20 d'une srie d'une formation
*
*  Renvoie la liste des notes d'une srie d'une formation
*
* @param integer : numro de formation
* @param integer : numro de srie
* @return integer : liste de note sur 20
*/

function stats_serie_formation($form,$serie)
{
            if(VERSION_BASE>VERSION)
            {
                        $req="select * from _af_stats_serie_formation($form,$serie) as (score real)";
                        $res=pg_query($req);
            }
            else
                        $res=stats_serie_formation_old($form,$serie);
            return($res);
}

/**
*  Obtenir la note et le total d'un exercice  tlcharger d'une formation (OLD)
*
*  Renvoie la liste des notes d'un exercice d'une formation
*
* @param integer : numro de formation
* @param integer : numro d'exercice
* @return integer : liste de note et de total
*/
function stats_exo_formation_old($form,$exo)
{
            $req="select score,surtotal
                        from resexouser
                        where num_cal='$form'
                        and num_exo='$exo'";

            $res=pg_query($req);
            return($res);
}

/**
*  Obtenir la note et le total d'un exercice  tlcharger d'une formation
*
*  Renvoie la liste des notes d'un exercice d'une formation
*
* @param integer : numro de formation
* @param integer : numro d'exercice
* @return integer : liste de note et de total
*/

function stats_exo_formation($form,$exo)
{
            if(VERSION_BASE>VERSION)
            {
                        $req="select * from _af_stats_exo_formation($form,$exo) as (score integer, total integer)";
                        $res=pg_query($req);
            }
            else
                        $res=stats_serie_formation_old($form,$exo);
            return($res);
}



?>