<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*
 * Created on Dec 11, 2008
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */

class StatsBuilder{
	
	var $properties;
	
	function StatsBuilder(){
		$this->properties=array();
	}
	
	/**
	 * Initialisation du conteneur de donnes
	 * @param object StatsAdapter $obj_stats_adapter
	 */
	function initStatsBuilder(&$obj_stats_adapter){
		$this->obj_stats_adapter=&$obj_stats_adapter;
	}
	
	/**
	 * Dfini une proprit
	 * 
	 * Une proprit est un nom d'un type particulier auquel est associ un libll.
	 * A une proprit correspond une valeur statistique qui pourra etre obtenu par une mthode sur un objet appropri ( prciser)
	 * 
	 * @param string $libelle Libll de la proprit (pour affichage)
	 * @param string $name Nom de la proprit (code unique pour selection)
	 * @param string $type Type de la proprit parmis les constantes dfinies
	 */
	function setProperty($libelle, $name, $type){
		$this->properties[$name][STATS_FIELD_LABEL]=$libelle;
		$this->properties[$name][STATS_FIELD_TYPE]=$type;
	}
	
	/**
	 * Obtenir une proprit identife par son nom
	 * @param string $name Nom de la proprit  obtenir (code unique pour selection)
	 */
	function getProperty($name){
		return $this->obj_stats_adapter->getProperty($name);
	}
	
	/**
	 * Obtenir un champs d'une proprit identife par son nom et par le champs
	 * @param string $name Nom de la proprit  obtenir (code unique pour selection)
	 * @param string $field Nom du champs  obtenir (parmis les constantes dfinies)
	 */
	function &getPropertyField($name,$field){
		$tmp=&$this->getProperty($name);  //reference pour le cas ou value est un objet
		return $tmp[$field];
	}
	
	/**
	 * Dfini un critre de selection
	 * 
	 * Un selecteur est un nom d'un type particulier auquel est associ un libll.
	 * Un selecteur permet de slectionner les rsultats statistiques en fonction des valeurs qui sont possibles pour celui-ci.
	 *  
	 */	
	function setSelecter($libelle, $name, $type){
		//inutile pour l'instant
	}

	/**
	 * Dfini un filtre de selection
	 * 
	 * Un filtre est un label d'un type particulier auquel est associ un libll.
	 * Un filtre permet de rduire les rsultats statistiques en fonction des valeurs qui sont possibles pour celui-ci.
	 * 
	 *  
	 */		
	function setFilter($libelle, $name, $type){
		//inutile pour l'instant		
	}
} 

?>