<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Objet de stockage de statistiques (StatsAdapter) 
 */
 class StatsCollection{
 	
 	/**
 	 * var object[] StatsAdapter Tableau de stockage de statistiques
 	 */
 	var $statsBuilds;
 	
 	function StatsCollection(){
 		$this->statsBuilds=array();
 	}
 	
 	/**
 	 * Enregistre un StatsAdapter (1er lment correspondant  la cl)
 	 * @param string $build_key Identifiant du StatsAdapter  enregistrer
 	 * @param object  StatsAdapter L'objet  enregistrer
 	 */
 	function register($adapter_key, &$adapter){
 		$adapter->setStatsCollection($this);
 		array_push(this->statsBuilds[$adapter_key],&$adapter);
 	}
 	
 	/**
 	 * Optenir un StatsAdapter  (dernier correspondant  la cl)
 	 * @param string $build_key Identifiant du StatsAdapter  enregistrer
 	 * @param object  StatsAdapter L'objet  enregistrer
 	 */
 	function &getBuild($adapter_key){
 		return array_pop($this->statsBuilds[$adapter_key]);
 	}
 }
?>
