<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Adaptateur d'objets pour les statistiques
 * 
 * Permet l'obtention des proprits d'un objet  partir de mthodes gnriques
 */
 class StatsAdapter{
 	
 	/**
 	 * @var object StatsBuilder Objet permettant la construction de statistiques
 	 */
 	var $obj_stat_builder;
 	
 	/**
 	 * @var object mixed  Objet  adapter
 	 */ 	
 	var $obj_data;
 	
 	/**
 	 * @var object StatsCollection Collection de StatsAdapter
 	 */
 	var $obj_stats_collection;
 	
 	/**
 	 * Constucteur
 	 */
 	function StatsAdapter(){
 		$this->obj_stat_builder=& new StatsBuilder();
 	}
 	
 	 /**
 	 * Initalisation avec l'objet  adapter
 	 * 
 	 * @param object Object L'objet  adapter
 	 */
 	function initStatsAdapter(&$obj_data){
 		$this->obj_data=&$obj_data;
 	}
 	
 	
 	/**
 	 * Obtenir l'Objet  adapter
 	 * @return object mixed l'Objet  adapter
 	 */
 	function getObjData(){
 		return $this->obj_data;
 	}
 
  	/**
 	 * Obtenir le StatsBuilder associ 
 	 * @return object StatsBuilder obtenir l'Objet permettant la construction de statistiques
 	 */	
 	function getStatsBuilder(){
 		return $this->obj_stat_builder;
 	}
 	
 	/**
 	 * Obtenir une proprit 
 	 * 
 	 * Mthode abstraire (doit etre complt par les mthodes des classes hritantes)
 	 * 
 	 * Mthode spcifique de rcupration de donnes de l'objet adapt
 	 * @param string $name Nom de la proprit  obtenir
 	 * @param object StatsAdapter Le StatsAdapter correspondant  la proprit $name si celui-ci est de type  STATS_TYPE_OBJECT. Retourne null sinon.
 	 */
 	function &getProperty($name){
		//selon certains types de champs, il faut rcuprer les Adapters associs  		
 		$field_type=$this->obj_stat_builder->getPropertyField($name,STATS_FIELD_TYPE);
		
		//si la proprit est de type STATS_TYPE_OBJECT, on retourne l'Adapter qui sera initialis par la mthode fille avec l'objet  adapter
		if($field_type==STATS_TYPE_OBJECT){
			$build=& $this->obj_stats_collection->getBuild($name);
			if(is_subclass_of($build,'StatsAdapter')){
				return $build;
			}else{
				die("StatsAdapter::getProperty($name): Erreur lors de la recupration du StatsAdapter");
			}
		}
 	}
 	
 	function setStatsCollection(&$obj_stats_collection){
 		$this->obj_stats_collection=&$obj_stats_collection;
 	}
 }
?>
