<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*
 * Created on Dec 16, 2008
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 /**
 * Adaptateur de l'objet Etape pour les statistiques
 * 
 * Permet l'obtention des proprits d'une etape  partir de mthodes gnriques
 */
 class StatsAdapterEtape extends StatsAdapter{
 	
 	
 	/**
 	 * Constucteur
 	 * 
 	 * @param object Object L'objet  adapter
 	 */
 	function StatsAdapterEtape(){
 		parent::StatsAdapter();
 		
 		$this->obj_stat_builder->initStatsBuilder($this);
 		
 		$this->obj_stat_builder->setProperty(MSG_606, 'libelle', STATS_TYPE_VARCHAR); 
 		
 		$this->obj_stat_builder->setProperty(MSG_1241, 'duree', STATS_TYPE_INTERVAL);
 		
 	}
 	
 	/**
 	 * Obtenir une proprit 
 	 * 
 	 * Mthode spcifique de rcupration de donnes de l'objet adapt
 	 * @param string $name Nom de la proprit  obtenir
 	 */
 	function getProperty($name){
		//recupere le StatsAdapter adapt si la proprit $name est de type  STATS_TYPE_OBJECT
		$property_obj_stats=parent::getProperty($name);
		switch($name){
			case 'libelle':
				$value=$this->obj_data->getLibelle();
				break;
			
			case 'debut':
				$value=$this->obj_data->getDebut();
				break;
			case 'fin':
				$value=$this->obj_data->getFin();
				break;
			
																			
		}
		return array('label'=>$this->obj_stat_builder->getPropertyField($name,STATS_FIELD_LABEL),STATS_FIELD_VALUE=>$value,STATS_FIELD_NAME=>$this->obj_stat_builder->getPropertyField($name,STATS_FIELD_NAME),STATS_FIELD_TYPE=>$field_type);
 		
 }
 	
?>
