<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Adaptateur des Etapes de Parcours pour les statistiques
 * 
 * Permet l'obtention des proprits des tapes d'un parcours  partir de mthodes gnriques.
 * 
 * En sus des mthodes propres  StatsAdapter qui correspond  UNE donne, cette classe qui correspond  PLUSIEURS donnes propose une mthode next()
 * permettant d'accder de manire itrative  chacunes des occurences de donnes. 
 * 
 * Cette mthode next() est faite pour etre appell en tant que condition d'arret d'un WHILE, la mthode getProperty() et ses drives (getPropertyField(), etc...) pouvant
 * ensuite etre appel  l'intrieur du WHILE pour la rcupration gnrique des proprits.
 * 
 */
 class StatsAdapterEtapes extends StatsAdapter{  
 	
 	/**
 	 * @var mixed[] Elment coutant
 	 */
 	var $current_element;
 	
 	/**
 	 * Constucteur
 	 * 
 	 * @param object Object L'objet  adapter
 	 */
 	function StatsAdapterEtapes(){
 		parent::StatsAdapter();
 		
 		$this->obj_stat_builder->initStatsBuilder($this);
 		// (id int4, libelle varchar, libelle_bis varchar, libelle_alias  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
 		$this->obj_stat_builder->setProperty(MSG_80, 'id', STATS_TYPE_INTEGER); //remplacer les chaines par des MSG
 		$this->obj_stat_builder->setProperty(MSG_606, 'libelle', STATS_TYPE_VARCHAR);
 		$this->obj_stat_builder->setProperty(MSG_2750, 'type_alias', STATS_TYPE_VARCHAR);
 		$this->obj_stat_builder->setProperty(MSG_608, 'type', STATS_TYPE_VARCHAR);
 		$this->obj_stat_builder->setProperty(MSG_2751, 'type_libelle', STATS_TYPE_VARCHAR);
 		$this->obj_stat_builder->setProperty(MSG_232, 'fin', STATS_TYPE_BOOLEAN);
 		$this->obj_stat_builder->setProperty(MSG_257, 'chrono', STATS_TYPE_INTEGER);
 		
 		//hors mthodes de la classe
// 		$this->obj_stat_builder->setProperty('Dure totale de connexion', 'individu_connexion_total', STATS_TYPE_INTERVAL);
// 		$this->obj_stat_builder->setProperty('Dure de Formation', 'individu_formation_connexion_total', STATS_TYPE_INTERVAL);
 	}
 	
 	/**
 	 * Obtenir une proprit 
 	 * 
 	 * Mthode spcifique de rcupration de donnes de l'objet adapt
 	 * @param string $name Nom de la proprit  obtenir
 	 */
 	function getProperty($name){
		//recupere le StatsAdapter adapt si la proprit $name est de type  STATS_TYPE_OBJECT
//		$property_obj_stats=parent::getProperty($name); //inutile ici
		
		switch($name){
			case 'id':
				$value=$this->current_element[0];
				break;
			case 'libelle':
				$value=$this->current_element[1];
				break;
			case 'type_alias':
				$value=$this->current_element[3];
				break;
			case 'type':
				$value=$this->current_element[4];
				break;
			case 'type_libelle':
				$value=$this->current_element[10];
				break;
			case 'fin':
				$value=$this->current_element[9];
				break;
			case 'chrono':
				$value=$this->current_element[8];
				break;	
//			//hors mthodes de la classe	
//			case 'individu_connexion_total':
////				$value='';
//				break;
//			case 'individu_formation_connexion_total':
////				$value='';
//				break;																	
		}

//inutile ici		
//		//si la proprit est de type STATS_TYPE_OBJECT, on initialise, avec l'objet data($value), le StatsAdapter retourn par la mthode de la classe mre
//		$field_type=$this->obj_stat_builder->getPropertyField($name,STATS_FIELD_TYPE);
//		if($field_type==STATS_TYPE_OBJECT){
//			$property_obj_stats->initStatAdapter($value);
//		}elseif($field_type==STATS_TYPE_QUERY_RESULT){
//			$iterator= new SqlResultIterator($value);
//		}
		return array('label'=>$this->obj_stat_builder->getPropertyField($name,STATS_FIELD_LABEL),STATS_FIELD_VALUE=>$value,STATS_FIELD_NAME=>$this->obj_stat_builder->getPropertyField($name,STATS_FIELD_NAME),STATS_FIELD_TYPE=>$field_type);
	}
	
	function next(){
   		$this->current_element=$this->obj_data->getNextElement();
   		if($this->current_element==null)return false;
   		else return true;
   }
 }
?>
