<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Adaptateur de l'objet Formation pour les statistiques
 * 
 * Permet l'obtention des proprits d'une formation  partir de mthodes gnriques
 */
 class StatsAdapterFormation extends StatsAdapter{
 	
 	
 	/**
 	 * Constucteur
 	 * 
 	 * @param object Object L'objet  adapter
 	 */
 	function StatsAdapterFormation(){
 		parent::StatsAdapter();
 		
 		$this->obj_stat_builder->initStatsBuilder($this);
 		
 		$this->obj_stat_builder->setProperty(MSG_606, 'libelle', STATS_TYPE_VARCHAR); //remplacer les chaines par des MSG
 		$this->obj_stat_builder->setProperty(MSG_682, 'classes', STATS_TYPE_QUERY_RESULT);
 		$this->obj_stat_builder->setProperty(MSG_537, 'debut', STATS_TYPE_DATE);
 		$this->obj_stat_builder->setProperty(MSG_232, 'fin', STATS_TYPE_DATE);
 		$this->obj_stat_builder->setProperty(MSG_727, 'obj_parcours', STATS_TYPE_OBJECT);
 		
 		//hors mthodes de la classe
 		$this->obj_stat_builder->setProperty('Dure totale de connexion', 'individu_connexion_total', STATS_TYPE_INTERVAL);
 		$this->obj_stat_builder->setProperty('Dure de Formation', 'individu_formation_connexion_total', STATS_TYPE_INTERVAL);
 	}
 	
 	/**
 	 * Initalisation avec l'objet  adapter
 	 * 
 	 * @param object Object L'objet  adapter
 	 */
// 	function initStatsAdapter($obj_formation){
// 		parent::initStatsAdapter($obj_formation);
// 	}
 	
 	/**
 	 * Obtenir une proprit 
 	 * 
 	 * Mthode spcifique de rcupration de donnes de l'objet adapt
 	 * @param string $name Nom de la proprit  obtenir
 	 */
 	function getProperty($name){
		//recupere le StatsAdapter adapt si la proprit $name est de type  STATS_TYPE_OBJECT
		$property_obj_stats=parent::getProperty($name);
		switch($name){
			case 'libelle':
				$value=$this->obj_data->getLibelle();
				break;
			case 'classes':
				$value=$this->obj_data->getClasses();
				break;
			case 'debut':
				$value=$this->obj_data->getDebut();
				break;
			case 'fin':
				$value=$this->obj_data->getFin();
				break;
			case 'obj_parcours':
				$value=$this->obj_data->getObjParcours();
				break;			
				
			//hors mthodes de la classe	
			case 'individu_connexion_total':
//				$value='';
				break;
			case 'individu_formation_connexion_total':
//				$value='';
				break;																	
		}
		
		//TODO
		//si la proprit est de type STATS_TYPE_OBJECT
		$field_type=$this->obj_stat_builder->getPropertyField($name,STATS_FIELD_TYPE);
		if($field_type==STATS_TYPE_OBJECT){
			$build->initStatAdapter($value);
		}
		return array('label'=>$this->obj_stat_builder->getPropertyField($name,STATS_FIELD_LABEL),STATS_FIELD_VALUE=>$value,STATS_FIELD_NAME=>$this->obj_stat_builder->getPropertyField($name,STATS_FIELD_NAME),STATS_FIELD_TYPE=>$field_type);
	}
 }
?>
