<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Adaptateur de l'objet Parcours pour les statistiques
 * 
 * Permet l'obtention des proprits d'un parcours  partir de mthodes gnriques
 */
 class StatsAdapterParcours extends StatsAdapter{
 	
 	
 	/**
 	 * Constucteur
 	 * 
 	 * @param object Object L'objet  adapter
 	 */
 	function StatsAdapterParcours(){
 		parent::StatsAdapter();
 		
 		$this->obj_stat_builder->initStatsBuilder($this);
 		
 		$this->obj_stat_builder->setProperty(MSG_606, 'libelle', STATS_TYPE_VARCHAR); //remplacer les chaines par des MSG
 		$this->obj_stat_builder->setProperty(MSG_1241, 'duree', STATS_TYPE_INTERVAL);
 		$this->obj_stat_builder->setProperty(MSG_1292, 'obj_filiere', STATS_TYPE_OBJECT);
 		$this->obj_stat_builder->setProperty(MSG_1517, 'etapes', STATS_TYPE_QUERY_RESULT);
 		
 		//hors mthodes de la classe
// 		$this->obj_stat_builder->setProperty('Dure totale de connexion', 'individu_connexion_total', STATS_TYPE_INTERVAL);
// 		$this->obj_stat_builder->setProperty('Dure de Formation', 'individu_formation_connexion_total', STATS_TYPE_INTERVAL);
 	}
 	
 	/**
 	 * Obtenir une proprit 
 	 * 
 	 * Mthode spcifique de rcupration de donnes de l'objet adapt
 	 * @param string $name Nom de la proprit  obtenir
 	 */
 	function getProperty($name){
		//recupere le StatsAdapter adapt si la proprit $name est de type  STATS_TYPE_OBJECT
		$property_obj_stats=parent::getProperty($name);
		switch($name){
			case 'libelle':
				$value=$this->obj_data->getLibelle();
				break;
			case 'duree':
				$value=$this->obj_data->getDuree();
				break;
			case 'obj_filiere':
				$value=$this->obj_data->getObjFiliere();
				break;
			case 'etapes':
				$value=$this->obj_data->getEtapes();
				break;
				
//			//hors mthodes de la classe	
//			case 'individu_connexion_total':
////				$value='';
//				break;
//			case 'individu_formation_connexion_total':
////				$value='';
//				break;																	
		}
		
		//si la proprit est de type STATS_TYPE_OBJECT, on initialise, avec l'objet data($value), le StatsAdapter retourn par la mthode de la classe mre
		$field_type=$this->obj_stat_builder->getPropertyField($name,STATS_FIELD_TYPE);
		if($field_type==STATS_TYPE_OBJECT){
			$property_obj_stats->initStatAdapter($value);
		}elseif($field_type==STATS_TYPE_QUERY_RESULT){
//			$iterator= new SqlResultIterator($value);
			$property_obj_stats->initStatAdapter(new SqlResultIterator($value));
		}
		return array('label'=>$this->obj_stat_builder->getPropertyField($name,STATS_FIELD_LABEL),STATS_FIELD_VALUE=>$value,STATS_FIELD_NAME=>$this->obj_stat_builder->getPropertyField($name,STATS_FIELD_NAME),STATS_FIELD_TYPE=>$field_type);
	}
 }
?>
