<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
* Cette classe dcrit un modle de correction.
*
* @author  COCQUET Rmi <rcocquet@afide.fr>
* @since 10/03/2005
*
* @package template
*/
class TemplateExotlc {
	/**
	* @var integer  Identifiant en base de donnes
	*/
	var $id;
	
	/**
	* @var string  Libell 
	*/
	var $nom;

	/**
	* @var integer  numro du thme
	*/
	var $num_theme;

	/**
	* @var array numeros des rubriques
	*/
	var $criteres = Array();

	/**
	*	Construit  un modle de correction.
	*	Si id est null, construit un nouveau modele  partir des autres parametres,
	*	sinon, recupere les donnes en bases pour le construire, les autres champs
	*	tant ignors.
	*
	*	@param integer $id le numero du modele en base de donnes
	*	@param string $nom le nom du modle
	*	@param integer $num_theme le numero du thme auquel il est associ
	*	@param array $criteres le tableau de critres, sous critres et de notation
	*/
	function TemplateExotlc($id, $nom = "", $num_theme = 0, $criteres = null) {

		if ($id == null) {

			if (empty($num_theme) || $num_theme < 0) {
				print "Le numero du thme associ au modle de correction ne peut etre vide ou ngatif";
				exit();
			}
			if (empty($criteres)) {
				print "Un modle de correction doit avoir des critres associs";
				exit();
			}
			$this -> id = null;
			$this -> nom = $nom;
			$this -> num_theme = $num_theme;
			$this -> criteres = $criteres;

			$NIVEAU_DEBUG = 1;
			//print_r($this -> criteres);

		} else {

			if (empty($id) || $id < 0) {
				print "L'identifiant du modle de correction ne peut etre vide ou ngatif";
				exit();
			}
			$this -> id = $id;

			$src_template = get_template($id);
			$this -> nom = pg_fetch_result($src_template, 0, 1);
			//$this -> num_theme = pg_result($src_template, 0, 2);
			$res_template_theme=get_template_themes(TYPE_CATEGORIE_EXOTLC_MODELE_CORRECTION,$id);
			$this->num_theme=pg_fetch_result($res_template_theme,0,0);
            // recup les infos d'un modele de correction
			//$src_criteres = get_template_criteres($id);
			$src_criteres=get_template_associations($id);
			$nbrows = pg_numrows($src_criteres);

			$this->criteres = Array();

			$id_rub = 0;
			//pour ligne de resultat
			for ($i = 0; $i < $nbrows; $i ++) {
				$row = pg_fetch_row($src_criteres);
				
				//on recupere le critere actuel et on effectue une
				//action quand le numero change
				$cur_rub = $row[1];
				if ($svg_rub != $cur_rub) {
					$svg_rub = $cur_rub;
					$id_rub ++;
					$id_srub = 0;
					//print"mise a 0 <BR>";
				}

				//enregistre la sous rubrique
				if (!empty($row[2])&&$row[1]==$cur_rub) {
					$id_srub ++;
					$this->criteres[$id_rub][$row[1]][$id_srub][$row[2]] = $row[3];
					//print ("R $id_rub   rub=".$row[1]."SR $id_srub  srub=".$row[2]." snote=".$this -> criteres[$id_rub][$row[1]][$id_srub][$row[2]] ." <br>");
				}
				//enregistre la rubrique
				else {
					if (!empty($row[3])&&$row[1]==$cur_rub) {

						$this->criteres[$id_rub][$row[1]] = $row[3];

						//print ("R $id_rub rub=".$row[1]."SR $id_srub srub=".$row[2]." snote=".$this -> criteres[$id_rub][$row[1]] ." <br>");
					} 
				}
			}

			//print_r($this -> criteres);
			//print ("fin constructeur");
		}
	}

	// ------------------------------------------------------------------------------------------------------------------- fin Parcours($num_parcours, $nom_parcours ....)

	/**
	* 	Fonction qui insre un enregistrement en table si celui ci n'existe pas.
	*	@return boolean: true si l'enregistrement a russi, false sinon.
	*/
	function insertToDB() {

		//test de prcondition
		if (empty($this -> nom) || empty($this -> num_theme) || empty($this -> criteres)) {
			print "L'objet Template n'a pas t correctement initialis: <BR>
																		nom=$this->nom<BR>num_theme=$this->num_theme<BR>criteres=";
			print_r($this -> criteres);
			print "<BR>";
		}

		//on vrifie qu'un enregistrement existe
		//if (check_template($this -> nom, $this -> num_theme)) {

			//cre le Template
			$this -> id = set_template(set_ams_libelle($this -> nom), $this -> num_theme);

			//cre ses critres et sous critres
			//$ordre = 0;    //get_template_last_critere($this -> id)
			//$ordre=get_template_last_critere($this -> id);
			reset($this -> criteres);
			while (list ($i, $tab) = each($this -> criteres)) {

				reset($tab);
				while (list ($key, $value) = each($tab)) {

					if (is_array($value)) {
						//$ordre_ss = 0;   // get_template_last_sous_critere($this -> id , $num_critere)
						reset($value);
						while (list ($key2, $value2) = each($value)) {
							reset($value2);
							while (list ($key3, $value3) = each($value2)) {
								//$ordre_ss ++;        // get_template_last_sous_critere($this -> id , $num_critere)
								$ordre_ss=get_template_last_sous_critere($this->id,$key);
								if ($sv_key != $key) {
									$sv_key = $key;
									//$ordre ++;  //  get_template_last_critere($this -> id)
									$ordre=get_template_last_critere($this -> id);
									set_template_assoc($this -> id, $key, "NULL", "NULL", $ordre);
								}
								set_template_assoc($this -> id, $key, $key3, $value3, $ordre_ss);
							}
						}
					} else {
						//$ordre ++;
						$ordre=get_template_last_critere($this -> id);
						$note_sur = $value;
						set_template_assoc($this -> id, $key, "NULL", "NULL", $ordre);
						set_template_assoc($this -> id, $key, "NULL", $value, $ordre);
					}

				}
			}
			return true;
		/*
		} else {
			return false;
		}
		*/
	}

	function getMaxSousCriteres() {
		$max = 0;
		///calcul des max ss_criteres et nb criteres
		reset($this -> criteres);
		while (list ($key_, $value_) = each($this -> criteres)) {
			reset($value_);
			while (list ($key, $value) = each($value_)) {
				$tmp_ss_criteres = 0;
				if (is_array($value)) {
					reset($value);
					while (list ($key2, $value2) = each($value)) {

						//comptabilise le max de sous criteres
						$tmp_ss_criteres ++;
						if ($max < $tmp_ss_criteres) {
							$max = $tmp_ss_criteres;
							//print "nveau max=".$this->max_ss_criteres;
						}

					}
				}
			}
		}
		return $max;
	}

	/**
		Obtenir le nombre de critres pour ce modele.
		@return integer le nombre de critres
	*/
	function getNbCriteres() {

		return sizeof($this -> criteres);
	}

	/**
		Obtenir le nombre de sous critres pour le critre d'indice spcifi.
		@param integer indice du critere spcifi
		@return integer le nombre de sous criteres
	*/
	function getNbSousCriteres($i) {
		reset($this -> criteres[$i]);
		while (list ($key, $value) = each($this -> criteres[$i])) {
			$j ++;
			$num = $value;
			//print "$key | $value";
		}
		if ($j != 1) {
			print ("Le format du tableau de critere de l'objet Template est incorrect<BR>");
		}
		if (is_array($num))
			$size = sizeOf($num);
		else
			$size = 0;
		//print("le critere $i a $size sous criteres<BR>")	;
		return $size;
	}

	/**
		Obtenir le numero d'un critere par son indice
		@param integer l'indice du critere dont on veut le numero
		@return integer le numero du critere voulu		
	*/
	function getCritere($i) {
		reset($this->criteres[$i]);
		$j = 0;
		while (list ($key, $value) = each($this->criteres[$i])) {
			$j ++;
			$num = $key;
		}
		if ($j != 1) {
			print ("Le format du tableau de critere de l'objet Template est incorrect<BR>");
		}
		//print($this -> criteres[$i]."|  le critere $i a pour numero $num<br>");
		return $num;
	}

	/**
	 * Obtenir les sous criteres du Template
	 * @param integer $critere L'indice du critre pour lequel on veut le sous critre
	 * @param integer $i L'indice du sous-critere voulu
	 * @return integer L'identifiant du sous-critre.
	 */
	function getSousCritere($critere, $i) {
//		echo "$critere, $i<br>";
		$crit = null;
		$cur_i = 0;
//		print_rr($this->criteres);
		reset($this->criteres[$critere]);
		while (list ($key_, $value_) = each($this -> criteres[$critere])) {
			
			if(is_array($value_)){
				reset($value_);
				while (list ($key, $value) = each($value_)) {
					
					reset($value);
					while (list ($key2, $value2) = each($value)) {
				
						if($key==$i){
								$num=$key2;	
						}
					}		
				}
			}
		}
		if ($num == null)
			print "<br>Il n'y a pas de sous critere d'indice $i pour le critere d'indice $critere. <br>Il n'y a que ".$this -> getNbSousCriteres($critere)." souscriteres<br>";
		
		//print("le sous critere $i du critere $critere a pour numero $num <BR>");
		return $num;
	}


	function getSousCritereNoteMax($critere, $i) {
		$crit = null;
		$cur_i = 0;
//		print_rr($this->criteres);
		reset($this->criteres[$critere]);
		while (list ($key_, $value_) = each($this -> criteres[$critere])) {
			
			if(is_array($value_)){
				reset($value_);
				while (list ($key, $value) = each($value_)) {
					
					reset($value);
					while (list ($key2, $value2) = each($value)) {
				
						if($key==$i){
								$note=$value2;	
						}
					}		
				}
			}
		}
		if ($note == null)
			print "<br>Il n'y a pas de sous critere d'indice $i pour le critere d'indice $critere. <br>Il n'y a que ".$this -> getNbSousCriteres($critere)." souscriteres<br>";
		
		return $note;
	}
	
	/**
	* Affiche le nom du modle
		*
	* @return string : retourne le nom du modle
	*/

	function toString() {
		return $nom;
	}
	// ------------------------------------------------------------------------------------------------------------------- fin toString($format)

}

?>