<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**

       @package template
       @modulegroup plpgsql
       @module plpgsql_template
*/

/**
*   Enregistrer un nouveau template. (OLD)
*
*
*   @param string: nom du groupe
*   @param integer : numero du thme
*   @return integer : numero du template de base
*/
function set_template_old( $nom, $numtheme){

 
		$req="INSERT  INTO correction_modele (nom, num_theme) VALUES ('$nom', $numtheme); ";
        $res=pg_query($req);
        $oid=pg_getlastoid($res);
        $res=pg_query("SELECT id  FROM correction_modele WHERE OID=$oid;");
        $id=pg_result($res, 0, 0);
      

        return $id;

}

/**
*   Enregistrer un nouveau template. (OLD)
*
*   @param string: nom du groupe
*   @param integer : numero du thme
*   @return integer : numero du template de base
*/
function set_template( $nom, $numtheme){
	$nom=addslashes($nom);
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_modele_correction('$nom')";
		$res=pg_query($sql);
        // enregistre dans theme_categories
		set_categorie_element_theme(16, $numtheme, pg_fetch_result($res, 0, 0));
		return pg_fetch_result($res, 0, 0);
	}
            else
                      $id=set_template_old( $nom, $numtheme);

            return ($id);
}

/**
*   Enregistrer une association de Template (OLD)
*	Ajoute une rubrique ou une sous rubrique  un modle, avec une notation.
*
*   @param integer: identifiant en base du Template
*   @param integer: identifiant en base de la rubrique
*   @param integer: identifiant en base de la sous rubrique (peu etre NULL)
*   @param integer: note sur laquelle est not le critre
*	@return integer: l'entier resultat de la requete
*/
function set_template_assoc_old( $id, $num_rub, $num_srub, $note_sur, $ordre){

 
		$req="INSERT  INTO correction_modele_asso  (num_modele, num_rub, num_srub, note_sur,ordre) VALUES ($id,$num_rub, $num_srub, $note_sur, $ordre);";
        //echo $req."<br>";
        $res=pg_query($req);

        return $res;

}

/**
*   Enregistrer une association de Template
*	Ajoute une rubrique ou une sous rubrique  un modle, avec une notation.
*
*   @param integer: identifiant en base du Template
*   @param integer: identifiant en base de la rubrique
*   @param integer: identifiant en base de la sous rubrique (peu etre NULL)
*   @param integer: note sur laquelle est not le critre
*	@return integer: l'entier resultat de la requete
*/
function set_template_assoc($id, $num_rub, $num_srub, $note_sur, $ordre){
	if(VERSION_BASE>VERSION){
		// debug
		//echo "num_srub=$num_srub et note_sur=$note_sur et ordre=$ordre<br>";
		 if($num_srub=="NULL" && $note_sur!="NULL"){
			$sql="select * from contraintes.af_maj_modele_correction_criteres_note($id,$num_rub,$ordre,$note_sur)";
			//echo "maj=$sql<br>";
			$res=pg_query($sql);
		}
		else{
			if($num_srub=="NULL")
			$sql="select * from contraintes.af_set_modele_correction_criteres($id,$num_rub,$ordre,$note_sur)";
			else
			 $sql="select * from contraintes.af_set_modele_correction_criteres($id,$num_srub,$ordre,$note_sur)";
			//echo "sql=$sql<br>";
			$res=pg_query($sql);
		}
		
		

	}
            else
                      $id=set_template_assoc_old($id, $num_rub, $num_srub, $note_sur, $ordre);

            return ($res);
}

/**
*   Verifie qu'un Template de nom et de numero de theme specifie n'existe pas.
*
*   @param string: le nom du Template  rechercher
*   @param integer: identifiant en base du thme associ
*	@return boolean: true si pas d'enregistrement existant, false sinon
*/
function check_template_old($nom, $numtheme){
		
		$req="SELECT id FROM correction_modele WHERE num_theme=$numtheme AND nom LIKE('$nom');";
        //echo $req."<br>";
        $res=pg_query($req);
		if(pg_numrows($res)==0)$ok=true;
        else $ok=false;
        
        return $ok;

}

/**
*   Verifie qu'un Template de nom et de numero de theme specifie n'existe pas.
*
*   @param string: le nom du Template  rechercher
*   @param integer: identifiant en base du thme associ
*	@return boolean: true si pas d'enregistrement existant, false sinon
*/
function check_template($nom, $numtheme){
			$nom=addslashes($nom);
            if(VERSION_BASE>VERSION)
            {
                     

            }
            else
                      $id=check_template_old($nom, $numtheme);

            return ($id);
}

/**
	Obtenir un modele de correction.(OLD)
	
	Les informations obtenues sont:
	id  |    nom |  num_theme 

  	@param integer: identifiant en base du template
	@return integer: l'entier resultat de la requete
*/
function get_template_old($i){

		$req="SELECT id,nom  FROM correction_modele WHERE id=$i";
        //echo $req."<br>";
        $res=pg_query($req);
		
        
        return $res;

}

/**
	Obtenir un modele de correction.
	
	Les informations obtenues sont:
	id  |    nom |  num_theme 

  	@param integer: identifiant en base du template
	@return integer: l'entier resultat de la requete
*/
function get_template($i){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_template($i) as (id int4,libelle varchar)";
		$res=pg_query($sql);
	}
    else
		$res= get_template_old($i);
	return ($res);
}

/**
	Obtenir les informations d'un critere(OLD)
	
	Les informations obtenues sont:
	num_rub | libelle_rub | num_theme
	
  	@param integer: identifiant en base du critere
	@return integer: l'entier resultat de la requete
*/
function get_template_critere_old($rub){

		$req="select * from RUBRIQUE where  num_rub=$rub ;";
        //echo "toto=".$req."<br>";
        $res=pg_query($req);
		
        
        return $res;

}

/**
	Obtenir les informations d'un critere
	
	Les informations obtenues sont:
	num_rub | libelle_rub | num_theme
	
  	@param integer: identifiant en base du critere
	@return integer: l'entier resultat de la requete
*/
function get_template_critere($rub){
	if(VERSION_BASE>VERSION){
								

	}
    else
		$res= get_template_critere_old($rub);
	return ($res);
}

/**
	Obtenir les criteres et sous criteres d'un modele de correction.(OLD)
	
	Les informations obtenues sont:
	num_modele  |    num_rub |  num_srub | note_sur | ordre

  	@param integer: identifiant en base du template
	@return integer: l'entier resultat de la requete
*/
function get_template_associations_old($i){

		//$req="SELECT * FROM correction_modele_asso WHERE num_modele=$i GROUP BY (num_rub, ordre) ORDER BY ordre";
        $req="SELECT SRUBS.num_modele, SRUBS.num_rub, SRUBS.num_srub, SRUBS.note_sur, SRUBS.ordre 
        FROM correction_modele_asso RUBS 
        INNER JOIN correction_modele_asso SRUBS 
        ON (RUBS.num_rub=SRUBS.num_rub) 
        WHERE RUBS.num_modele=$i 
        AND SRUBS.num_modele=$i 
        AND RUBS.note_sur IS NULL 
        AND SRUBS.note_sur IS NOT NULL 
        ORDER BY RUBS.ordre, SRUBS.ordre;";
        //echo $req."<br>";
        $res=pg_query($req);
		
        
        return $res;

}

/**
	Obtenir les criteres et sous criteres d'un modele de correction.
	
	Les informations obtenues sont:
	num_modele  |    num_rub |  num_srub | note_sur  | ordre

  	@param integer: identifiant en base du template
	@return integer: l'entier resultat de la requete
*/
function get_template_associations($i){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_template_associations($i)";
		//echo "$sql";
		$res=pg_query($sql);
	}
	else
		$res= get_template_associations_old($i);
	return $res;
}

/**
	Obtenir les  sous criteres d'un critere.(OLD)
	
	Les informations obtenues sont:
	num_srub | libelle_srub |srub_numtheme | num_rub

  	@param integer: identifiant en base du critere
	@return integer: l'entier resultat de la requete
*/
function get_template_rubrique_sous_criteres_old($rub){

		$req="select * from SOUSRUBRIQUE
			where  num_rub='$rub' ;";
        //echo "req=$req<br>";
        $res=pg_query($req);
		
        
        return $res;

}

/**
	Obtenir les  sous criteres d'un critere.
	
	Les informations obtenues sont:
	num_srub | libelle_srub | srub_numtheme | num_rub

  	@param integer: identifiant en base du critere
	@return integer: l'entier resultat de la requete
*/
function get_template_rubrique_sous_criteres($rub){

            if(VERSION_BASE>VERSION)
            {
                     

            }
            else
                      $res= get_template_rubrique_sous_criteres_old($rub);

            return ($res);
}
/**
	Supprimer un modele de correction.(OLD)

  	@param integer: identifiant en base du template
*/
function del_template_old($i){

		$req1="DELETE  FROM correction_modele WHERE id=$i";
		$req2="DELETE  FROM correction_modele_asso WHERE num_modele=$i";
    	//echo $req1."<br>";
     	//echo $req2."<br>";
        $res1=pg_query($req1);
        $res2=pg_query($req2);

}

/**
	Supprimer un modele de correction.

  	@param integer: identifiant en base du template
*/
function del_template($i){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_template($i)";
		$res=pg_query($sql);

	}
	else 
		return del_template_old($i);
	return $res;

}

/**
	Obtenir les themes d'un template (OLD)
	
	@param integer : numero template
	@return resultat requete
	
*/
function get_template_themes_old($template){
	$sql="select distinct num_themedir,nom_theme from themedir where num_themedir in 
				(select num_theme from correction_modele where id=$template)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Obtenir les themes d'un template 
	@param integer : numero categirie
	@param integer : numero template
	@return resultat requete
	
*/
function get_template_themes($categorie,$template){
	 if(VERSION_BASE>VERSION)
		$res=get_categorie_element_themes($categorie,$template);
	 else
		$res=get_template_themes_old($template);
	 return $res;
}


/**
	Obtenir le numero du dernier critere d'un modele de correction (OLD)
	@param integer : numero modele
	@return  integer :  le numero du dernier critere
*/
function get_template_last_critere_old($modele){
	$sql="select max(ordre) from correction_modele_asso where num_modele=$modele and num_srub is null and note_max is null";
	$res=pg_query($sql);
	return pg_fetch_result($res, 0, 0) +1;
}
/**
	Obtenir le numero du dernier critere d'un modele de correction 
	@param integer : numero modele
	@return  integer :  le numero du dernier critere
*/
function get_template_last_critere($modele){
	if(VERSION_BASE>VERSION){
		// on recupere les criteres du modele dans un tableau
		$sql="select * from contraintes.af_get_template_criteres_non_ordonnes($modele) as (modele_correction int4,id int4,libelle varchar,pere int4,note_max int4)";
		$res=pg_query($sql);
		$nb_criteres=pg_num_rows($res);
		if($nb_criteres==0){
			//echo "ret null";
			$ret="NULL";
			return $ret;
		}
		$tab_criteres="_int4'{";
		for($i=0;$i<$nb_criteres;$i++){
			$row=pg_fetch_row($res,$i);
			// dernier ?
			if($i<$nb_criteres -1)
				$tab_criteres .=$row[1].",";
			else
				$tab_criteres .=$row[1];
		}
		$tab_criteres .="}'";
		$sql="select * from contraintes.af_gen_get_last_element('contraintes.modele_correction_criteres','critere',$tab_criteres,'and modele_correction=$modele')";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
		if(pg_num_rows($res)==1){
			return pg_fetch_result($res, 0, 0);
		} 
		else{
			 return null;	
		}
		
	}
	else
		return get_template_last_critere_old($modele);
}

 /**
	Obtenir le numero du dernier sous critere d'un modele de correction (OLD)
	@param integer : numero modele
	@param integer : numero critere
	@return  integer :  le numero du dernier critere
*/
function get_template_last_sous_critere_old($modele,$critere){
	$sql="select max(ordre) from correction_modele_asso where num_modele=$modele and num_rub=$critere and num_srub is not null ";
	$res=pg_query($sql);
	return pg_fetch_result($res, 0, 0) +1;
}
/**
	Obtenir le numero du dernier sous critere d'un modele de correction 
	@param integer : numero modele
	@param integer : numero modele
	@return  integer :  le numero du dernier critere
*/
function get_template_last_sous_critere($modele,$critere){
	if(VERSION_BASE>VERSION){
		// on recupere les sous criteres du critere du modele dans un tableau
		$sql="select * from contraintes.af_get_template_sous_criteres_non_ordonnes($modele,$critere) as (modele_correction int4,id int4,libelle varchar,pere int4,note_max int4)";
		$res=pg_query($sql);
		$nb_criteres=pg_num_rows($res);
		if($nb_criteres==0)
			return "NULL";
		$tab_criteres="_int4'{";
		for($i=0;$i<$nb_criteres;$i++){
			$row=pg_fetch_row($res,$i);
			// dernier ?
			if($i<$nb_criteres -1)
				$tab_criteres .=$row[1].",";
			else
				$tab_criteres .=$row[1];
		}
		$tab_criteres .="}'";
		$sql="select * from contraintes.af_gen_get_last_element('contraintes.modele_correction_criteres','critere',$tab_criteres,'and modele_correction=$modele')";
		$res = pg_query($sql);
		if(pg_num_rows($res)==1){
			return pg_fetch_result($res, 0, 0);
		} 
		else{
			 return null;	
		}
		
	}
	else
		return get_template_last_sous_critere_old($modele,$critere);
}


function get_template_sous_critere($template,$critere,$souscritere){
	$sql="select * from contraintes.af_get_template_sous_critere($template,$critere,$souscritere) AS (modele_correction int4,id int4,libelle varchar,pere int4,note_max int4)";
	$res = pg_query($sql);
}

/**
	Teste si modle de correction est supprimable 
	@param integer : numero modle
	@return bool : true supprimable,false sinon
*/
function check_template_supprimable($template){
	
		$res=!fk_finder('modele_correction','id',$template);
	
	return $res;
}

?>