<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoTest.
 * Un DoTest sert  grer l'avancement des Etapes de type Test.
 * 
 * @package test
 */
class DoTest extends DoListe{ 

	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours Identifiant du parcours courant.
	 * @param integer $etape Identifiant de l'tape courante.
	 * @param object DoNodeFactory &$obj_DoNodeFactory Fabrique utilise pour la cration des objets d'avancement qui composent le Test
	 */	
	function DoTest($formation,$individu,$parcours,$etape,&$obj_DoNodeFactory){
		parent::DoListe($formation,$individu,$parcours,$etape,&$obj_DoNodeFactory);
	}
	
	
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	/**
	 * Dbut du Test
	 * Initialise l'avancement du Test.
	 * Cration de l'identifiant rsultat et enregistrement de la date de dbut pour le Test.
	 * Si le Test est en cours, initalise et commence le positionnement courant.
	 * 
	 * @return integer idenfiant rsultat en base de donnes
	 */	
	function beginCurrentEtape(){
		messageDebug("DoTest::beginCurrentEtape()");
		$res_resultat=get_resultat_etape($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape());
		if(pg_num_rows($res_resultat)==1){
			$row_resultat=pg_fetch_row($res_resultat);
			$id_resultat=$row_resultat[0];
			$fin_resultat=$row_resultat[6];
		}
		if(!empty($id_resultat)){
			
			$this->resultat=$id_resultat;
			if(!empty($fin_resultat)){
				die("Erreur DoTest::beginCurrentEtape(): l'tape a dj t commence et est dj termine.<br/>");
			}else{
				echo "COMMENCE l'EVALUATION <br>";
				if(!is_object($this->obj_DoNode)){
					$this->nextEvaluation();
				}
				return $this->obj_DoNode->begin();
			}
		}else{
			echo "COMMENCE LA SERIE <br>";			
			$this->resultat=set_resultat_debut($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape() );
			echo "COMMENCE l'EVALUATION <br>";
				if($this->nextEvaluation()){
					return $this->obj_DoNode->begin();
				}
				return false;
		}
		return $this->resultat;
	}

	/**
	 * Construction des objets associs  l'avancement au sein du Test.
	 * L'objet d'avancement de l'element courant du Test, de type DoPositionnement, est construit  partir
	 * de l'identifiant Resultat cr par la methode beginCurrentEtape().
	 * 
	 * @return object DoPositionnement : L'objet correspondant  l'lment courant du Test
	 */ 	 
	function performCurrentEtape(){
		messageDebug("DoTest::performCurrentEtape()");
		parent::performCurrentEtape();
		$row_avancement=$this->getAvancement();
		if(!empty($row_avancement[5])){
			$this->obj_DoNode=&$this->obj_DoNodeFactory->createDoEvaluation($this->getResultat(),$row_avancement[5],$row_avancement[6],$row_avancement[7]);
			$this->obj_DoNode->perform();
		}
		else{
			unset($this->obj_DoNode);
		}
		return $this->obj_DoNode;
	}
	
	/**
	 * Termine le Test et si besoin termine le Positionement courant et charge le suivant.
	 * Enregistre la date de fin du Test et du Positionement si besoin et detruit les attributs de l'objet inutiles.
	 * @param object Resultat $obj_resultat : Resultat associ  l'objet associ  l'avancement.
	 * @return boolean TRUE ou FALSE suivant le succs ou non de la mthode.
	 */
	function endCurrentEtape($obj_resultat=null){
		messageDebug("DoTest::endCurrentEtape($obj_resultat)");
		if(is_object($this->obj_DoNode)){
			if($this->obj_DoNode->isBegin()){
				if($this->obj_DoNode->isEnd()){
//					echo "serie: evaluation finie<br>";				
					$this->nextEtape();
				}else{
//					echo "serie: evaluation PAS finie, on la finie<br>";				
					$res_node=$this->obj_DoNode->end($obj_resultat);
					unset($this->obj_DoNode);
//					echo"<pre>";
//					print_r($this);
//					echo"</pre>";
					$this->nextEvaluation();
//					echo"<pre>";
//					print_r($this);
//					echo"</pre>";
					if($res_node)echo "serie: evaluation a bien ete finie<br>";		
					else echo "serie: evaluation NA PAS ete finie<br>";
				}
			}else{
				die("DoTest::endCurrentEtape(): L'valuation courante ne peut etre termine car elle n'a pas t commence.</b><br/>");
				return false;
			}
		}
		
		if(!is_object($this->obj_DoNode)){ //nb:attention pas de else
//			echo "TERMINE LA SERIE<br>";
			$res_parent=parent::endCurrentEtape($obj_resultat);	
			if($res_parent)echo "serie: la serie a bien ete finie<br>";		
			else echo "serie: la serie NA PAS ete finie<br>";		
			return $res_parent;
		}else{
			messageDebug("DoTest::endCurrentEtape(): La serie ne peut etre termine: Il y a une valuation suivante.");
			return false;
		}
	}
		
//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------
	/**
	 * Passage au Positionnement suivant du Test.
	 * Initalise l'objet d'avancement du Positionnement ou le met  null si pas de Positionnement suivant.
	 * @return boolean TRUE si il y a un Positionnement suivant, FALSE sinon.
	 */
	function nextEvaluation(){
		$row_avancement=$this->getAvancement();
		if(!empty($row_avancement[5])){
			//$this->obj_DoEtapeFactory=&$this->getDoEtapeFactory();
			$this->obj_DoNode=&$this->obj_DoNodeFactory->createDoEvaluation($this->getResultat(),$row_avancement[5],$row_avancement[6],$row_avancement[7]);
			return true;
		}
		else{
			unset($this->obj_DoNode);
			return false;
		}
	}
	
	/**
	 * Obtenir l'avancement courant.
	 * L'avancement est calcul pour la formation et l'individu courant, donc l'identifiant du parcours peur changer.
	 * @return array la ligne resultat de requete : (parcours int4, etape int4,type int4, formation int4,individu int4, date_debut timestamp)
	 */	
	function getAvancement(){
		return pg_fetch_row(get_resultat_serie_avancement_max($this->getResultat()));
	}
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	/**
	 * Obtenir l'objet Test associ  cet objet d'avancement.
	 * @return object Test L'objet Test associ. 
	 */
	function getTest(){
		return parent::getListe();
	}

	/**
	 * Obtenir l'objet d'avancement correspondant au Positionnement courant du Test
	 * @return object DoPositionnement L'objet d'avancement du Positionnement courant
	 */	
	function &getCurrentDoPositionnement(){
		return parent::getCurrentDoNode();
	}

	/**
	 * Obtenir la fabrique permettant la cration des objets associs au Test
	 * @return object DoEtapeFactory  Fabrique utilise pour la cration des objets d'avancement qui composent le Test
	 */	
	function getCurrentDoEvaluationFactory(){
		return parent::getCurrentDoNodeFactory();
	}
}
?>
