<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *Fichier de dfinition de la classe Test
 *Un test est compos de plusieurs positionnements.
 *Il peut etre dynamique, et donc ses positionnements doivent alors etre dynamiques.
 *Il peut aussi ne pas l'etre, et dans ce cas on peut y associer des positionnements dynamiques ou non.
 *Il peut etre continu, les diffrents positionnements qui le composent sont alors fusionns.
 *Il peut avoir un media ou non.
 *
 *@package test
*/
class Test extends Liste{
	
	/**
	 * @var boolean Indique que le test est dynamique
	 */
	var $dynamique;

	/**
	 * @var boolean Indique que le test est continu (chronos fusionns)
	 */
	var $continu;
	
	/**
	 * @var integer Identifiant du Media associ 
	 */
	var $media;

	/**
	 * @var integer Longueur, en pixel, du Media associ 
	 */
	var $longueur_media;
	
	/**
	 * @var integer Largeur, en pixel, du Media associ 
	 */	
	var $largeur_media;

	/**
	 * Construit un Test.
	 * Le Test peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant de l'Etape
	 * @param string $libelle Libell
	 * @param string $date_creation date de cration (format SQL)
	 * @param boolean $dynamique Indique que le test est dynamique
	 * @param boolean $continu Indique que le test est dynamique
	 * @param integer $media Identifiant du Media associ 
	 * @param integer $longueur_media Longueur, en pixel, du Media associ 
	 * @param integer $largeur_media Largeur, en pixel, du Media associ 
	 */
	function Test($id, $libelle="Etape Test", $date_creation="27.11.2006",$dynamique=false , $continu=false, $media=0, $longueur_media=0, $largeur_media=0){
		if(func_num_args()==1){
			$res_etape=get_test($id);
			$row_etape=pg_fetch_row($res_etape);
			$libelle=$row_etape[1];
			$date_creation=$row_etape[7];
			$dynamique=$row_etape[2];
			$continu=$row_etape[3];
			$media=$row_etape[4];
			$longueur_media=$row_etape[5];
			$largeur_media=$row_etape[7];
		}else{
			
		}
		parent::Liste($id, $libelle,$date_creation);
		$this->initTest($dynamique,$continu,$media,$longueur_media,$largeur_media);
	}
	
	function initTest($dynamique,$continu,$media,$longueur_media,$largeur_media){
		parent::initListe(TYPE_LISTE_TEST);
		$this->dynamique=$dynamique;
		$this->continu=$continu;
		$this->media=$media;
		$this->longueur_media=$longueur_media;
		$this->largeur_media=$largeur_media;
	}

	/**
	* Fonction qui retourne le nombre total de secondes du test
	*
	* Cette fonction calcule le nombre total de seconde du test en effectuant la somme des dures de chaque positionnement.
	* Si les positionnements du test sont tous sans chrono, alors cette fonction retourne 0 (seconde)
	* @return integer : Dure totale en seconde du test
	*/
	function getChronoTotal() {
		$result=get_test_somme_chronos($this->id);
		return pg_result($result,0,0) ;
	}
	
	/**
	 * Savoir si le Test est continu.
	 * @return boolean true si le Test est continu, false sinon.
	 */
	function isContinue() {
		return $this->continu;
	}

	/**
	 * Savoir si le Test est dynamique.
	 * @return boolean true si le Test est dynamique, false sinon.
	 */	
	function isDynamique() {
		return $this->dynamique;
	}
	
	/**
	 * Obtenir l'icone associe  l'Etape.
	 * @return string Le nom du fichier icone
	 */
	function getIcone(){
		if($this->isDynamique()){
			return "ico_test_dynamique.png";
		}else{
			return "ico_test.png";
		}
	}
}
?>