<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package test
 * @modulegroup fonctions
 */

/**
 * Fonction qui rparti des tests provenant d'un resulat de requette dans 4 tableaux.
 * Un tableau contenant les test continus, un autre les dynamiques, un autre les dynamiques continus
 * et un dernier ceux qui ne sont ni dynamiques, ni continus.
 * @param integer: un resultat de requete dont la premiere colonne est un identifiant de test.
 * @param integer : le nombre de tuples de l'entier resultat
 * @param array: IN/OUT le tableau des tests continus
 * @param array: IN/OUT le tableau des tests dynamiques
 * @param array: IN/OUT le tableau des tests continus et dynamiques
 * @param array: IN/OUT le tableau des tests non continus et non dynamiques
 */ 
function dispatch_tests($res, $nb,$tabContinue, $tabDyn, $tabDynContinue,$tabRien){
    reset($tabContinue);
    reset($tabDyn);
    reset($tabDynContinue);
    reset($tabRien);
    // Parcours des listes
    for($i=0;$i<$nb;$i++){
        // Rcupration du numro de la liste
        $num_liste=pg_fetch_result($res,$i,0);
        $current_liste= new Test($num_liste);
        // recup du type de liste
        $type_liste_dyn=$current_liste->isDynamique();
        $type_liste_cont=$current_liste->isContinue();
        //echo "$type_liste_dyn et   $type_liste_cont<br>";
        if(($type_liste_dyn=="t") && ($type_liste_cont=="t"))
            $tabDynContinue[]=$current_liste;
        else {
            if($type_liste_dyn=="t")
                $tabDyn[]=$current_liste;
            else {
                if($type_liste_cont=="t")
                    $tabContinue[]=$current_liste;
                else
                    $tabRien[]=$current_liste;
            }
        }
        unset($current_liste);
    }
    //print_r($tabContinue);
    //print_r($tabDyn);
    //print_r($tabDynContinue);
    //print_r($tabRien);
}


/**
 * Fonction qui retourne les actions permises sur un test
 * @param integer : le numero du test
 * @return integer : 0:suppression possible, 1 suppression impossible, 2 autre.
 */
function get_test_actions($test){
    // Valeur de retour
    $action_liste=0;
    // test si la liste est dans un parcours
    $sql="select g_num_parcours from gestparcours where num_c_q_e_d='$test' and type_etape='L'";
    $res=pg_query($sql);
    $nb=pg_numrows($res);
    if($nb>0)
    {
        $action_liste=1;
        // test si le parcours est ds une formation
        for($j=0;$j<$nb;$j++)
        {
            $row=pg_fetch_row($res,$j);
            $tabform=array();
            get_parcours_all_formations($row[0],$tabform);
            $sz=sizeof($tabform);
            if($sz>0)
            {
                $action_liste=2;
                break ;
            }
        }
    }
    return $action_liste ;
}

function compare_tests(  $test1,  $test2){
	$lib1=$test1->libelle;
	$lib2=$test2->libelle;
	$lib1=strtolower($lib1);
	$lib2=strtolower($lib2);
	$res=strcmp($lib1, $lib2);
	return $res;
}
?>
