<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fonctions pour les tests.
 * 
 * @package test	
 */

/**
	Supprime un test  (OLD)

 *	@param inyeger : le numero du test
 *	@return integer : le resultat de la requete
*/
function del_test_old($test){
	$sql="delete from test where id_test =$test";
	$del=pg_query($sql);
 	$sql="delete from serie_exo where id  =$test";
 	$del=pg_query($sql);
 	$sql="delete from asso_test_reponse where id_test  =$test";
 	$del=pg_query($sql);
 	$sql="delete from test_quest_rep where id_test  =$test";
 	$del=pg_query($sql);
 	$sql="delete from test_rep_nbexogen where id_test  =$test";
	$del=pg_query($sql);
 	return $del;
}
/**
	Supprime un test

 *	@param inyeger : le numero du test
 *	@return integer : le resultat de la requete
*/
function del_test($test){
	if(VERSION_BASE>VERSION){
 		$res=pg_query($sql);
    }
    else
        $res=del_test_old($test);
    return $res ;
}

/**
	Mettre  jour la question commune d'un test (OLD)
	
	@param integer : le numero du test
	@param string : le libelle de la question commune
	@return integer : le resultat de la requete
*/
function maj_test_question_commune_old($test,$libelle){
	$sql="update test set question_commune='$libelle' where id_test=$test";
	return pg_query($sql);
}
/**
	Mettre  jour la question commune d'un test 
	
	@param integer : le numero du test
	@param string : le libelle de la question commune
	@return integer : le resultat de la requete
*/
function maj_test_question_commune($test,$libelle){
	if(VERSION_BASE>VERSION){
 		$res=pg_query($sql);
    }
    else
        $res=maj_test_question_commune_old($test,$libelle);
    return $res ;
}

/**
 * Obtenir les informations d'un test.
 * 
 * @param integer : le numero du test
 * @return integer resultat de la requete:
 */
/*function get_test_old($test) {
	$sql = "SELECT id_test, type_test, media_test, longueur_media, largeur_media,chrono,type_reponse,question_commune FROM test WHERE id_test=$test";
	//echo $sql . "<br>";
	return pg_query($sql);
}*/

/**
 * Obtenir les informations d'un test.
 * 
 * @param integer : le numero du test
 * @return integer resultat de la requete:
 */
/*function get_test($test) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM af_get_test($test) AS ()";
		echo $sql . "<br>";
		$result = pg_query($sql);
	} else
		$res = get_test_old($test);
	return $res;

}*/

/**
 * Obtenir sur les rponses possibles  un test.
 * Les rponses sont ordonnes.
 * 
 * @param integer : le numero du test
 * @return integer resultat de la requete: (id int4, reponse int4, niveau int4, bareme int4, media int4, longueur int4, largeur int4)
 */
function get_test_reponses_infos_old($test) {
	$requete = "SELECT A.id_test, A.id_reponse, niveau, num_bareme, media_reponse,longueur_media, largeur_media
		            FROM asso_test_reponse A
		            WHERE A.id_test=$test
		            ORDER BY ordre";
	//echo $requete . "<br>";
	return pg_query($requete);
}

/**
 * Obtenir sur les rponses possibles  un test.
 * Les rponses sont ordonnes.
 * 
 * @param integer : le numero du test
 * @param integer : le numero du rponse du test
 * @return integer resultat de la requete:(id int4, reponse int4, niveau int4, bareme int4, media int4, longueur int4, largeur int4)
 */
function get_test_reponses_infos($test) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM af_get_test_reponses_infos($test) AS (id int4, reponse int4, niveau int4, bareme int4, media int4, longueur int4, largeur int4)";
		echo $sql . "<br>";
		$result = pg_query($sql);
	} else
		$res = get_test_reponses_infos_old($test);
	return $res;

}

/**
 * Obtenir les evaluations  gnrer pour un test
 * Les rponses sont ordonnes.
 * 
 * @param integer : le numero du test
 * @return integer resultat de la requete: (id int4, reponse int4, type int4, nb_a_generer int4, taille_chapeau int4)
 */
function get_test_evaluations_a_generer_old($test) {
	$requete = "SELECT R.id_test, A.id_reponse, R.type_exercice, R.nb_a_generer, R.taille_chapeau
		            FROM  test_rep_nbexogen R,asso_test_reponse A 
		            WHERE R.id_test=$test
					AND A.id_test=R.id_test
		            ORDER BY A.ordre";
	//echo $requete . "<br>";
	return pg_query($requete);
}

/**
 * Obtenir les exercices  gnrer pour une rponse  un test
 * Les rponses sont ordonnes.
 * 
 * @param integer : le numero du test
 * @return integer resultat de la requete:(id int4, reponse int4, type int4, nb_a_generer int4, taille_chapeau int4)
 */
function get_test_evaluations_a_generer($test) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM af_get_test_evaluations_a_generer($test) AS (id int4, reponse int4, type int4, nb_a_generer int4, taille_chapeau int4)";
		echo $sql . "<br>";
		$result = pg_query($sql);
	} else
		$res = get_test_evaluations_a_generer_old($test);
	return $res;
}

/**
 * Cre un test.(OLD)
 * @param integer : le numero de la serie pere (heritage)
 * @param varchar : le libell de la question commune
 * @param integer : le numero du type de test
 * @param integer : le numero du media
 * @param integer : la longueur du media
 * @param integer : la largeur du media
 * @param integer : le chrono (secondes)
 * @param integer : le type de reponses (radio ou checkboxes)
 * @return integer resultat de la requete
 */
/*function set_test_old($id,  $libelle_question , $type, $media, $longueur, $largeur, $chrono, $type_evaluation) {
	$insert = "INSERT INTO test 
	(id_test, type_test, media_test, longueur_media, largeur_media,chrono,type_reponse,question_commune)
	VALUES ($id, '$type', $media,$longueur,$largeur,$chrono,$type,'" . addslashes($libelle_question) . "') ;";
	echo $insert . "<br>";
	$res = pg_query($insert);
	return $res;
}*/


/**
 * Cre un test.
 * 
 * @param varchar : le libell de la question commune
 * @param integer : le numero du type de test
 * @param integer : le numero du media
 * @param integer : la longueur du media
 * @param integer : la largeur du media
 * @param integer : le chrono (secondes)
 * @param integer : le type de reponses (radio ou checkboxes)
 * @param integer : le numero de la serie (old)
 * @return integer resultat de la requete
 */
/*function set_test($libelle_question , $type, $media, $longueur, $largeur, $chrono, $type_evaluation, $id="") {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_set_test('$libelle_question', $type, $media, $longueur, $largeur, $chrono, $type_evaluation) ";
		echo $sql . "<br>";
		$result = pg_query($sql);
		return pg_fetch_result($result,0,0);
		
	} else
		return set_test_old($id,  $libelle_question , $type, $media, $longueur, $largeur, $chrono, $type_evaluation);
}*/

/**
 * Mettre a jour un test.
 * 
 * @param integer : le numero du test
 * @param varchar : le libell de la question commune
 * @param integer : le numero du type de test
 * @param integer : le numero du media
 * @param integer : la longueur du media
 * @param integer : la largeur du media
 * @param integer : le chrono (secondes)
 * @param integer : le type de reponses (radio ou checkboxes)
 * @return integer resultat de la requete
 */
/*function maj_test_old($id,  $libelle_question , $type, $media, $longueur, $largeur, $chrono, $type_evaluation) {
	$insert = "UPDATE test SET type_test='$this->type_test', chrono='$this->chrono_gen',media_test=" . $this->media_test->getIdDB() . ",longueur_media=" . $this->media_test->getLongueurDB() . ",largeur_media=" . $this->media_test->getLargeurDB() . ",type_reponse='$this->type_rep',question_commune='" . addslashes($this->question_commune) . "'  WHERE id_test = $this->id_serie";
	echo $insert . "<br>";
	return pg_query($insert);
}*/

/**
 * Mettre a jour un test.
 * 
 * @param integer : le numero du test
 * @param varchar : le libell de la question commune
 * @param integer : le numero du type de test
 * @param integer : le numero du media
 * @param integer : la longueur du media
 * @param integer : la largeur du media
 * @param integer : le chrono (secondes)
 * @param integer : le type de reponses (radio ou checkboxes)
 * @return integer resultat de la requete
 */
/*function maj_test($id,  $libelle_question , $type, $media, $longueur, $largeur, $chrono, $type_evaluation) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM af_maj_test($id, $libelle_question, $type, $media, $longueur, $largeur, $chrono, $type_evaluation) ";
		echo $sql."<br>";
		$result = pg_query($sql);
	} else
		$res = maj_test_old($id,  $libelle_question , $type, $media, $longueur, $largeur, $chrono, $type_evaluation);
	return $res;
}*/

function get_test_last_reponse_old($test){
	$result = pg_query("SELECT MAX(ordre) FROM asso_test_reponse WHERE id_test=$test");
	return pg_result($result, 0, 0)+1;
}

function get_test_last_reponse($test){
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM af_get_test_last_evaluation($test)";
		echo $sql."<br>";
		$result = pg_query($sql);
	}else
		return get_test_last_reponse_old($test);
}

function set_test_reponse_old($test, $reponse, $niveau, $ordre, $bareme, $media, $hauteur, $largeur){
	$insert = "INSERT INTO asso_test_reponse (id_test, id_reponse, niveau, ordre, num_bareme, media_reponse, longueur_media, largeur_media)
	           VALUES ($test, $reponse, $niveau, $ordre, $bareme, $media, $hauteur, $largeur)";
	return pg_query($insert);
}

function set_test_reponse($test, $reponse, $niveau, $ordre, $bareme, $media, $hauteur, $largeur){
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM af_set_test_evaluation($test, $reponse, $niveau, $ordre, $bareme, $media, $hauteur, $largeur)";
		echo $sql."<br>";
		$result = pg_query($sql);
	}else
		return set_test_reponse_old($test, $reponse, $niveau, $ordre, $bareme, $media, $hauteur, $largeur);
}

function set_test_reponse_evaluations_old($test, $reponse, $type, $nb_a_generer, $taille_chapeau){
	$insert = "INSERT INTO test_rep_nbexogen (id_test, id_reponse, type_exercice, nb_a_generer, taille_chapeau)
			   VALUES ($test, $reponse, $type, $nb_a_generer, $taille_chapeau)";
	//echo $insert."<br>";
	pg_query($insert);
	return pg_query($insert);
}

function set_test_reponse_evaluations($test, $reponse, $type, $nb_a_generer, $taille_chapeau){
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM af_set_test_reponse_evaluations($test, $reponse, $type, $nb_a_generer, $taille_chapeau)";
		echo $sql."<br>";
		$result = pg_query($sql);
	}else
		return set_test_reponse_evaluations_old($test, $reponse, $type, $nb_a_generer, $taille_chapeau);
}

?>