<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fonctions pour les tests.
 * 
 * @package test
 * @modulegroup plpgsql
 * @module plpgsql_test
 */

//include ("$chemin_bo/lib/test/plpgsql_deprecated_test.inc");

/**
 * Obtenir les parcours d'un test
 * @param integer : le numero du test
 * @return integer: resultat de la requete:(id int4, libelle varchar, filiere int4, duree bool)
 */
function get_test_parcours_old($test) {
		$req = "SELECT I.g_num_parcours,I.num_c_q_e_d, P.nom_parcours, P.affiche_fo 
				FROM gestparcours I, gestparcours F, parcours P 
				WHERE I.type_etape='L' AND I.num_c_q_e_d='$test'
				AND I.type_etape='S' AND I.g_num_parcours=F.g_num_parcours
				AND I.g_num_parcours=P.num_parcours";
		//echo "$sql<br>";
		return (pg_query($req));
}

/**
 * Obtenir les parcours d'un test
 * @param integer : le numero du test
 * @return integer: resultat de la requete:(id int4, libelle varchar, filiere int4, duree bool)
 */
function get_test_parcours($test) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_test_parcours($test) AS (id int4, libelle varchar, filiere int4, duree bool, date_creation timestamp)";
		//echo "$sql<br>";
		return (pg_query($sql));
	} else
		return get_test_parcours_old($test);
}


/**
*   Obtenir les infos d'un test (OLD)
*
*   @param integer : le numro du test
*   @return integer : le rsultat de la requte: (id int4, libelle varchar, dynamique int4, continu int4, media int4, longueur_media int4, largeur_media int4)
*/
function get_test_old($test) {
    $req="SELECT id_liste_test, nom_liste_test, dynamique, continue, media_liste_test, longueur_media, largeur_media FROM liste_test WHERE id_liste_test=$test";
    $res=pg_query($req);
    return $res;
}

/**
*   Obtenir les infos d'un test 
*
*   @param integer : le numro du test
*   @return integer : le rsultat de la requte: (id int4, libelle varchar, dynamique int4, continu int4, media int4, longueur_media int4, largeur_media int4, date_creation timestamp)
*/
function get_test($test) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_test($test) AS (id int4, libelle varchar, dynamique bool, continu bool, media int4, longueur_media int4, largeur_media int4, date_creation timestamp)";
		//echo "$sql<br>";
		return (pg_query($sql));
	} else return get_test_old($test);
}

/**
 * Obtenir les positionnements qui composent un test (OLD).
 * Les positionnements sont ordonns.
 * @param integer: le numro du test
 * @return integer : le rsultat de la requte: (test int4, positionnement int4, pere int4)
 */
function get_test_positionnements_old($test){
	 $req="SELECT id_liste_test, id_test, ordre FROM asso_liste_test WHERE id_liste_test=$test ORDER BY ordre";
	return pg_query($req) ;
}

/**
 * Obtenir les positionnements qui composent un test
 * Les positionnements sont ordonns.
 * @param integer: le numro du test
 * @return integer : le rsultat de la requte: (test int4, positionnement int4, pere int4)
 */
function get_test_positionnements($test){
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_test_positionnements($test) AS (test int4, positionnement int4, pere int4)";
		//echo "$sql<br>";
		return (pg_query($sql));
	} else return get_test_positionnements_old($test);
}

/**
 * Obtenir les informations des positionnements qui composent un test
 * Les positionnements sont ordonns.
 * @param integer: le numro du test
 * @return integer : le rsultat de la requte: (test int4, positionnement int4, pere int4)
 */
function get_test_positionnements_infos_old($test){
	print("get_test_positionnements_info_old() a implementer<br>");
	//return pg_query($req) ;
}

/**
 * Obtenir les informations des positionnements qui composent un test
 * Les positionnements sont ordonns.
 * @param integer: le numro du test
 * @return integer : le rsultat de la requte: ( id int4, libelle varchar, type  int4, chrono  int4, serie_aleatoire int4, question_reponse int4, test int4 )
 */
function get_test_positionnements_infos($test){
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_test_positionnements_infos($test) AS  ( id int4, libelle varchar, type  int4, chrono  int4, serie_aleatoire int4, question_reponse int4, test int4 )";
		//echo "$sql<br>";
		return (pg_query($sql));
	} else return get_test_positionnements_infos_old($test);
}

/**
 * Cre un test.(OLD)
 * @param varchar : le libell du test
 * @param integer : dynamique
 * @param integer : continu
 * @param integer : le numero du media
 * @param integer : la longueur du media
 * @param integer : la largeur du media
 * @return integer : l'identifiant du test
 */
function set_test_old( $libelle, $dynamique, $continu, $media, $longueur, $largeur) {
	$insert = "INSERT INTO liste_test (nom_liste_test, dynamique, continue, media_liste_test, longueur_media, largeur_media)
               VALUES ('$libelle', $dynamique, $continu, $media, $longueur, $largeur)";
	//echo $insert . "<br>";
	$result = pg_query($insert);
	$oid = pg_last_oid($result) ;
	$result = pg_query("SELECT id_liste_test FROM liste_test WHERE oid=$oid");
	return pg_fetch_result($result,0,0);
}

/**
 * Cre un test.
 * @param varchar : le libell du test
 * @param integer : dynamique
 * @param integer : continu
 * @param integer : le numero du media
 * @param integer : la longueur du media
 * @param integer : la largeur du media
 * @return integer : l'identifiant du test
 */
function set_test( $libelle, $dynamique, $continu, $media, $longueur, $largeur) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_set_test('$libelle', $dynamique, $continu, $media, $longueur, $largeur) ";
		//echo $sql . "<br>";
		$result = pg_query($sql);
		return pg_fetch_result($result,0,0);
		
	} else
		return set_test_old($libelle, $dynamique, $continu, $media, $longueur, $largeur);
}

/**
 * Met a jour un test.(OLD)
 * @param integer : identifiant du test
 * @param varchar : le libell du test
 * @param integer : dynamique
 * @param integer : continu
 * @param integer : le numero du media
 * @param integer : la hauteur du media
 * @param integer : la largeur du media
 * @return bool : TRUE ou FALSE selon que la mise a jour se soit bien passe ou non.
 */
function maj_test_old($test, $libelle, $dynamique, $continu, $media, $hauteur, $largeur) {
	$sql = "UPDATE liste_test SET (nom_liste_test='$libelle', dynamique=$dynamique, continue=$continu, media_liste_test=$media, longueur_media=$hauteur, largeur_media=$largeur)
               WHERE id_liste_test=$test";
	//echo $insert . "<br>";
	$result = pg_query($sql);
	return $result;
}

/**
 * Met a jour un test.
 * @param integer : identifiant du test
 * @param varchar : le libell du test
 * @param integer : dynamique
 * @param integer : continu
 * @param integer : le numero du media
 * @param integer : la longueur du media
 * @param integer : la largeur du media
 * @return bool : TRUE ou FALSE selon que la mise a jour se soit bien passe ou non.
 */
function maj_test($test, $libelle, $dynamique, $continu, $media, $hauteur, $largeur) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_maj_test($test,'$libelle', $dynamique, $continu, $media, $hauteur, $largeur) ";
		echo $sql . "<br>";
		$result = pg_query($sql);
		return pg_fetch_result($result,0,0);
		
	} else
		return maj_test_old($test, $libelle, $dynamique, $continu, $media, $hauteur, $largeur);
}

/**
*   Obtenir l'identifiant du pere du prochain positionnement  ajouter au test.(OLD)
*
*   @param integer : le numro du test
*   @return integer : numero d'ordre du prochain positionnement  ajouter au test 
*/
function get_test_last_positionnement_old($test) {
    $req="SELECT MAX(ordre) FROM asso_liste_test WHERE id_liste_test=$test";
    $res=pg_query($req);
    return pg_fetch_result($res,0,0)+1;
}

/**
*   Obtenir l'identifiant du pere du prochain positionnement  ajouter au test.
*
*   @param integer : le numro du test
*   @return integer : identifiant du pere du prochain positionnement  ajouter au test 
*/
function get_test_last_positionnement($test) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_test_last_positionnement($test)";
		//echo "$sql<br>";
		$res=pg_query($sql);
		return (pg_fetch_result($res,0,0));
	} else 
		return get_test_last_positionnement_old($test);
}

/**
*   Associer un positionnement  un test.(OLD)
*
* @param integer : le numro du test
* @param integer : le numro du positionnement
* @param integer : le numero d'ordre pour l'association
* @return bool : true ou false selon la reussite ou non de l'association
*/
function set_test_positionnement_old($test, $positionnement, $pere) {
	//on verifie que le positionnement n'est pas deja dans le test
	//si c'est le cas on ne fait rien.
	$verif="SELECT * FROM asso_liste_test WHERE id_liste_test=$test AND id_test=$positionnement";
	$r_verif=pg_query($verif);
	if(pg_num_rows($r_verif)==0){
		//si le pere est  NULL, c'est qu'on insert a la fin, cad avec le max de l'ordre +1
		if($pere=="NULL"){
			$ordre=get_test_last_positionnement_old($test);
		}else{
			//on recupere l'odre du pere	
			$sql="SELECT ordre FROM asso_liste_test WHERE id_liste_test=$test AND id_test=$pere";
			$res=pg_query($sql);
			$ordre=pg_fetch_result($res,0,0);
		}
		
		$req="UPDATE asso_liste_test SET ordre=ordre+1 WHERE id_liste_test=$test AND ordre>= $ordre";
		$res=pg_query($req);
		
	    $sql = "INSERT INTO asso_liste_test (id_liste_test, id_test, ordre)
		        VALUES ($test, $positionnement, $ordre)";
		//echo"$sql<br>";        
	    $res=pg_query($sql);
	    return $res;
	}
	else return false;
}

/**
*   Associer un positionnement  un test.
*
* @param integer : le numro du test
* @param integer : le numro du positionnement
* @param integer : le numero du pere pour l'odre de l'association
* @return bool : true ou false selon la reussite ou non de l'association
*/
function set_test_positionnement($test, $positionnement, $pere) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_set_test_positionnement($test, $positionnement, $pere)";
		//echo "$sql<br>";
		return (pg_query($sql));
	} else return set_test_positionnement_old($test, $positionnement, $pere);
}

/**
*   Supprimer un positionnement d'un test.(OLD)
*
* @param integer : le numro du test
* @param integer : le numro du positionnement
* @return bool : true ou false selon la reussite ou non de la suppression
*/
function del_test_positionnement_old($test, $positionnement) {
	
	// SELECTION de l'ordre de la ligne concerne
	$delete = "SELECT ordre FROM asso_liste_test WHERE id_liste_test=$test AND id_test=$positionnement";
	$res=pg_query($delete);
	if($res && pg_num_rows($res)>0){	
		$ordre=pg_fetch_result($res,0,0);
	
		// DELETE de la ligne concerne
		$delete = "DELETE FROM asso_liste_test WHERE id_liste_test=$test AND id_test=$positionnement";
		$res=pg_query($delete);
	
		// UPDATE des lignes qui suivent
		$update = "UPDATE asso_liste_test SET ordre = ordre -1 WHERE id_liste_test=$test AND ordre >= $ordre ";
		pg_query($update);	
	}
    return $res;
}

/**
*   Supprimer un positionnement d'un test.
*
* @param integer : le numro du test
* @param integer : le numro du positionnement
* @return bool : true ou false selon la reussite ou non de la suppression
*/
function del_test_positionnement($test, $positionnement) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_del_test_positionnement($test, $positionnement)";
		//echo "$sql<br>";
		return (pg_query($sql));
	} else return del_test_positionnement_old($test, $positionnement);
}

/**
 * Obtenir les positionnements que l'on peu associer  un test. (OLD)
 * Les positionnements assosiables sont ceux qui ne sont pas deja associs au test.
 * @param integer : le numro du test
 * @return integer : le resultat de la requete :( id int4, libelle varchar, type_question  int4, chrono  int4, serie_aleatoire int4, bareme int4, chrono_gen int4 )
 */
function get_test_positionnements_disponibles_old($test){
		$lst_test = "('q','s')"; // pour filtrer les qrc et src (type m et o)
		$requete = "SELECT id, titre, type_test, S.chrono, NULL, bareme, T.chrono FROM test T, serie_exo S WHERE id=id_test
		            AND id_test NOT IN (SELECT id_test FROM asso_liste_test WHERE id_liste_test = $test) and type_test in $lst_test ;";
		//echo "$requete<br>";
		return (pg_query($requete));
}

/**
 * Obtenir les positionnements que l'on peu associer  un test.
 * Les positionnements assosiables sont ceux qui ne sont pas deja associs au test.
 * @param integer : le numro du test
 * @return integer : le resultat de la requete :( id int4, libelle varchar, type_question  int4, chrono  int4, serie_aleatoire int4, bareme int4, chrono_gen int4 )
 */
function get_test_positionnements_disponibles($test){
		if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_test_positionnements_disponibles($test) AS ( id int4, libelle varchar, type_question  int4, chrono  int4, serie_aleatoire int4, bareme int4, chrono_gen int4 )";
		//echo "$sql<br>";
		return (pg_query($sql));
	} else return get_test_positionnements_disponibles_old($test);
}

/**
 * Supprimer un ensemble de tests. (OLD)
 * @param array : un tableau contenant les numro des tests
 * @return integer : le nombre de tests rellement supprims
 */
function del_tests_old($tests){
	
		$nb_deleted=0;
	    foreach($tests as $key => $value){
	    	$sql="DELETE FROM liste_test WHERE id_liste_test=$value";
        	$result1=pg_query($sql);
        	if($result1)$nb_deleted++;
        	$sql="DELETE FROM asso_liste_test WHERE id_liste_test=$value";
        	$result2=pg_query($sql);
	    }
	    return $nb_deleted;
}

/**
 * Supprimer un ensemble de tests.
 * @param array : un tableau contenant les numro des tests
 * @return integer : le nombre de tests rellement supprims
 */
function del_tests($tests){
	if (VERSION_BASE > VERSION) {
		$chaine="'{";
		$nb=count($tests);
		foreach($tests as $key => $value){
			if($key<$nb-1)$chaine.="$value,";
			else $chaine.="$value";		 	
		}
		$chaine.="}'";
		$sql = "SELECT * FROM contraintes.af_del_tests($chaine)";
		//echo "$sql<br>";
		return (pg_fetch_result(pg_query($sql),0,0));
	} else return del_tests_old($tests);
	
}

/**
	Obtenir la somme des chronos des positionnement d'un test
	@param integer : le numero du test
	@return integer : la dure totale des chrono en secondes
*/
function get_test_somme_chronos($test){
	 if(VERSION_BASE>VERSION){
		$sql="SELECT * FROM contraintes.af_get_test_somme_chronos($test)";
		//echo "$sql<br>";
		$res=pg_query($sql);
    }
    else
        $res=get_test_somme_chronos_old($test);
    return $res ;
}
?>
