<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
Un thme est une entit dans laquelle on peut ranger la plupart des lments de la
plate-forme.
On peut voir l'ensemble des thmes comme un classeur, et donc chaque thme comme un
intercallaire ou y serait rangs les lments de la plate-forme.

@author Cocquet Rmi
@since 03/03/2006

@package theme
*/
class Theme{

	var $id;
	
	var $libelle;
	
	var $owner;
	
	/**
    * Constructeur de la classe 
    * @param integer $num_ou_lib identifiant de l'enregistrement en BD ou libelle
    * @param String $libelle le libell du theme si le numero est le premier parametre
    */
    function Theme($num_ou_lib, $libelle="", $owner=null){
    	
    		//soit on constuit un objet dont on dispose de toutes les donnes
    		if(func_num_args()==2){
    			$this->id=$num_ou_lib;
    			$this->libelle=$libelle;
    			$this->owner=$owner;  
    			return;
    		}
    		//sinon on lit les donnes en base ou on construit un nouvel objet
    		
             // On determine le type du parametre a l'aide d'une expression reguliere
            $une_chaine  = ereg("[^0-9]",$num_ou_lib) ;

            // Deux constructions differentes selon le type du parametre (a refaire le jour ou on pourra surcharger les fonctions !!!)
            if(!$une_chaine){
                    $this->id = $num_ou_lib ;
                    $res= get_theme($num_ou_lib);
                    $row=pg_fetch_row($res);
                    $this->libelle=$row[1];
                    $this->owner=$row[3];
            }
            // Construction a partir d'un nom
            else{
                   $this->libelle = $num_ou_lib ;
            }
    }
		
	
	/**
		Obtenir l'identifiant en base du theme
	*/
	function getId(){
		return $this->id;	
	}
	
	/**
	*	Obtenir le propritaire du theme
	*/
	function getOwner(){
		return $this->owner;	
	}
	
	/**
	*	Savoir si le theme possede un propritaire
	*/
	function isPublic(){
		return empty($this->owner);	
	}
	/**
		Obtenir le libell du thme 
	*/
	function getLibelle(){
		//return htmlentities($this->libelle,ENT_QUOTES,CHARSET);
		return $this->libelle;
	}
	
	/**
	 * Affecter le libll du thme.
	 * @param string $libelle Le libll du thme
	 */
	function setLibelle($libelle){
		$this->libelle=$libelle;
	}

	/**
	 * Affecter l'identifiant du thme.
	 * @param integer $id L'identifiant du thme.
	 */	
	function setId($id){
		$this->id=$id;	
	}
	
	function insertToDB(){
		$this->id=set_theme(set_ams_libelle($this->libelle));
		return $this->id;
		
	}
	
	function updateToDB(){
		return maj_theme($this->id,set_ams_libelle($this->libelle));
	}
	
	/**
	 * Supprime le theme de la base de donnes
	 * ainsi que le repertoire sur le disque.
	 */
	function deleteToDB(){
		global $chemin_fo;
		return del_repertoire($chemin_fo ."/data/contenus/".$this->id) &&del_theme($this->id);
	}
	
	
	/**
	* Obtenir le libelle du theme tel qu'il sera affiche dans le gestionnaire de contenu
	*/
	function toString(){
		return $this->libelle;	
	}
	
	/**
		Obtenir les objets Categorie contenant des lments pour ce theme
	*/
	function getCategories(){
			
			//recupere les identiants des catgories de ce theme
			$categories=get_theme_categories($this->id);
			$nb_categories=pg_numrows($categories);
			
			//cree les objets catgories correspondant  ces identifiants
			$objCategories=array();
			for($i=0;$i<$nb_categories;$i++){
				$objCategories[$i]= new Categorie(pg_result($categories, $i, 0));
			}
			
			return $objCategories;
	}
	
	function share(){
		return maj_theme_owner($this->id,'public');
	}
	
	function unshare(){
		return maj_theme_owner($this->id,'auth');
	}
}
?>