<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**

       @package theme
       @modulegroup plpgsql
       @module plpgsql_theme
*/

//include("$chemin_bo/lib/theme/plpgsql_deprecated_theme.inc")
/**
 * Obtenir les proprits d'un theme. (OLD)
 * 
 * @param integer $theme le numero du theme dsir
 * @return integer L'entier resultat de la requete :(id int4, libelle varchar, nom_rep text)
 */
function get_theme_old($theme) {

	$req = "SELECT * FROM themedir WHERE num_themedir=$theme";
	//echo "$req<br>";
	$themes = pg_query($req);

	return $themes;
}

/**
 * Obtenir les proprits d'un theme. 
 * Ici,le rpertoire du theme est l'id, il est retourn par soucis
 * de   compatibilit entre les deux versions de la base de donnes
 * 
 * @param integer $theme le numero du theme dsir
 * @return integer L'entier resultat de la requete :(id int4, libelle varchar, nom_rep text)
 */
function get_theme($theme) {

	if (VERSION_BASE > VERSION) {

		$req = "select * from contraintes.af_get_theme($theme) AS (id int4, libelle varchar, nom_rep text, individu integer)";
		//echo "sql1=$req<br>";
		$themes = pg_query($req);

	} else
		$themes = get_theme_old($theme);

	return $themes;
}


function set_theme_old($libelle) {

	$req = "insert into THEMEDIR (nom_theme) values('$nom');";
	$res = pg_query($req);
	$oid = pg_getlastoid($res);
	$req = "SELECT num_themedir  FROM THEMEDIR WHERE oid='$oid';";
	$res = pg_query($req);

	return $res;
}

/**
*	Crer un nouveau theme
*	@param string: le libell du nouveau theme
*/
function set_theme($libelle) {
	if (VERSION_BASE > VERSION) {
		global $auth;
		$user_id=$auth->getUserId();
		$req = "select * from contraintes.af_set_theme('$libelle',$user_id) ";
		$res = pg_query($req);

	} else
		$res = set_theme_old($libelle);

	return pg_result($res, 0, 0);
}



function maj_theme_old($id, $libelle) {

	$req = "UPDATE themedir SET nom_theme = '$libelle' WHERE num_themedir=$id;";
	$res = pg_query($req);

	return $res;
}

/**
	Met a jour le libelle du theme avec vrification de l'unicit de celui-ci
	@param integer : le numero du theme  modifier
	@param string : le nouveau libelle qui doit ne pas exister
	@return bool: TRUE si la modification a t faite, FALSE sinon
*/
function maj_theme($id, $libelle) {
	if (VERSION_BASE > VERSION) {

		$req = "select * from contraintes.af_maj_theme($id, '$libelle') ";
		$res = pg_query($req);

	} else
		$res = set_theme_old($id, $libelle);

	return pg_result($res, 0, 0);
}

/**
*	Obtenir les criteres de correction associes a un theme (OLD)
*
*	@deprecated utiliser get_theme_criteres($theme)
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_criteres_old($theme) {

	$req = "select * from RUBRIQUE where rub_numtheme =$theme ;";
	$criteres = pg_query($req);

	return $criteres;
}

/**
*	Obtenir les criteres de correction associes a un theme
*
*	@deprecated utiliser get_theme_criteres($theme)
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_criteres($theme) {

	if (VERSION_BASE > VERSION) {

		$req = "A IMPLEMENTER";
		$criteres = pg_query($req);

	} else
		$criteres = get_theme_criteres_old($theme);

	return $criteres;
}

/**
*	Obtenir les criteres de correction associes a un theme (OLD)
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_criteres_old($theme) {

	$req = "select * from RUBRIQUE where rub_numtheme =$theme ;";
	$criteres = pg_query($req);

	return $criteres;
}

/**
*	Obtenir les criteres de correction associes a un theme
*
*	
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_criteres($theme){
	if (VERSION_BASE > VERSION) {
		//$req = "A IMPLEMENTER";
		$req="select * from contraintes.af_get_theme_criteres($theme) as (id int4,libelle varchar,pere int4)";
		//echo "req=$req<br>";
		$criteres = pg_query($req);

	} else
		$criteres = get_theme_criteres_old($theme);

	return $criteres;
}
/**
*	Obtenir les sous criteres de correction associes a un theme (OLD)
*
*	@deprecated utiliser  get_theme_sous_criteres($theme) 
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_sous_criteres_old($theme) {

	$req = "select * from SOUSRUBRIQUE where srub_numtheme =$theme;";
	$criteres = pg_query($req);

	return $criteres;
}

/**
*	Obtenir les sous criteres de correction associes a un theme
*
*	@deprecated utiliser get_theme_sous_criteres($theme)
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_sous_criteres($theme) {

	if (VERSION_BASE > VERSION) {

		$req = "A IMPLEMENTER";
		$criteres = pg_query($req);

	} else
		$criteres = get_sous_criteres_old($theme);

	return $criteres;
}

/**
*	Obtenir les sous criteres de correction associes a un theme (OLD)
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_sous_criteres_old($theme) {

	$req = "select * from SOUSRUBRIQUE where srub_numtheme =$theme;";
	$criteres = pg_query($req);

	return $criteres;
}

/**
*	Obtenir les sous criteres de correction associes a un theme
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_sous_criteres($theme) {

	if (VERSION_BASE > VERSION) {

		$req = "select * from contraintes.af_get_theme_sous_criteres($theme) as (id int4,libelle varchar,pere int4)";
		//echo "sql=$req<br>";
		$criteres = pg_query($req);

	} else
		$criteres = get_theme_sous_criteres_old($theme);

	return $criteres;
}

/**
*	Obtenir les modeles de correction associes a un theme(OLD)
*   @deprecated : utiliser get_theme_modeles_correction
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_modeles_old($theme) {

	$req = "select *  from CORRECTION_MODELE where num_theme=$theme  order by nom;";
	$modeles = pg_query($req);
	//echo $req;
	return $modeles;
}

/**
*	Obtenir les modeles  de correction associes a un theme
*
*	@param integer: le numero du theme desire
*   @deprecated : utiliser get_theme_modeles_correction
*	@return integer : l'entier resultat de la requete
*/
function get_modeles($theme) {

	if (VERSION_BASE > VERSION) {

		$req = "A IMPLEMENTER";
		$modeles = pg_query($req);

	} else
		$modeles = get_modeles_old($theme);

	return $modeles;
}

/**
*   Obtenir les formations d'un thmes pour une priode (OLD)
*
*   @param integer : le numero du theme
*   @param integer : le numero de la priode 1=pass 2=prsent 3=futur>
*   @return integer : l'entier resultat de la requete
*/
function get_formations_theme_periode_old($theme, $periode) {
	$today = date("Y-m-d");
	switch ($periode) {
		case 1 :
			$condition = " AND D2.jour < '$today' ";
			break;
		case 2 :
			$condition = " AND NOT (D1.jour > '$today' OR D2.jour < '$today') ";
			break;
		case 3 :
			$condition = " AND D1.jour > '$today' ";
			break;
	}
	$sql = "select DISTINCT  g_num_gest_g,U.nom, U.prenom, C.nom_cal as formation, C.num_cal, D1.jour as debut, D2.jour as fin
	                                FROM gestionnaire G, utilisateurs U, calendrier C, dates D1, dates D2
	                                WHERE U.num_user=G.g_num_user
	                                AND C.num_cal=G.g_num_cal
	                                AND D1.num_date=C.datedeb
	                                AND D2.num_date=C.datefin
	                                $condition
	                                AND num_cal in
	                                (select distinct g_num_cal from gestionnaire where g_num_parcours in
	                                (select g_num_parcours from gestparcours where num_etape=1 and num_thematik='$theme'))";
	return (pg_query($sql));

}
/**
*   Obtenir les formations d'un thmes pour une priode
*
*   @param integer : le numero du theme
*   @param integer : le numero de la priode 1=pass 2=prsent 3=futur>
*   @return integer : l'entier resultat de la requete
*/
function get_formations_theme_periode($theme, $periode) {
	if (VERSION_BASE > VERSION) {
		// Appel de la fonction plpgsql  crer : _af_get_formation_selection_periode("theme",$theme,$periode)
		$sql = "A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = get_formations_theme_periode_old($theme, $periode);
	return $res;
}

/**
*	Obtenir les libelles grille (presentiel) associes a un theme (OLD)
*   @deprecated : utiliser get_theme_grilles
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_libelle_grilles_old($theme) {

	$req = "select * from grille where theme =$theme order by libelle_grille;";
	$grilles = pg_query($req);

	return $grilles;
}

/**
*	Obtenir les libelles grille (presentiel) associes a un theme
*   @deprecated : utiliser get_theme_grilles
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_libelle_grilles($theme) {

	if (VERSION_BASE > VERSION) {

		$req = "A IMPLEMENTER";
		$grilles = pg_query($req);

	} else
		$grilles = get_libelle_grilles_old($theme);

	return $grilles;
}

/**
*	Obtenir les libelles titre de capacit (presentiel) associes a un theme (OLD)
*   @deprecated : utiliser get_theme_capacites_titres
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_libelle_titrecapacites_old($theme) {

	$req = "select * from titrecapacite where theme =$theme order by libelle_titrecapacite;";
	$titrecapacites = pg_query($req);

	return $titrecapacites;
}

/**
*	Obtenir les libelles titre de capacit (presentiel) associes a un theme
*   @deprecated : utiliser get_theme_capacites_titres
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_libelle_titrecapacites($theme) {

	if (VERSION_BASE > VERSION) {

		$req = "A IMPLEMENTER";
		$titrecapacites = pg_query($req);

	} else
		$titrecapacites = get_libelle_titrecapacites_old($theme);

	return $titrecapacites;
}

/**
*	Obtenir les libelles capacit (presentiel) associes a un theme (OLD)
*   @deprecated : utiliser get_theme_capacites
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_libelle_capacites_old($theme) {

	$req = "select * from capacite where theme =$theme order by libelle_capacite;";
	$capacites = pg_query($req);

	return $capacites;
}

/**
*	Obtenir les libelles titre de capacit (presentiel) associes a un theme
*   @deprecated : utiliser get_theme_capacites
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_libelle_capacites($theme) {

	if (VERSION_BASE > VERSION) {

		$req = "A IMPLEMENTER";
		$capacites = pg_query($req);

	} else
		$capacites = get_libelle_capacites_old($theme);

	return $capacites;
}

/**
*	Obtenir les grilles (presentiel) associes a un theme (OLD)
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_grilles_old($theme) {

	$req = "select * from grille where  num_grille in (select  gt_num_grille from grilletitrecapa ) and theme =$theme order by libelle_grille;";
	$grilles = pg_query($req);

	return $grilles;
}

/**
*	Obtenir les grilles (presentiel) associes a un theme
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_grilles($theme) {

	if (VERSION_BASE > VERSION) {

		$req = "A IMPLEMENTER";
		$grilles = pg_query($req);

	} else
		$grilles = get_grilles_old($theme);

	return $grilles;
}

/**
*	Obtenir les  titre de capacite (presentiel) associes a un theme (OLD)
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_titrecapacites_old($theme) {

	$req = "select * from titrecapacite where  num_titrecapacite in (select tr_num_titrecapacite from titrecapa ) and theme =$theme order by libelle_titrecapacite;";
	$titrecapacites = pg_query($req);

	return $titrecapacites;
}

/**
*	Obtenir les titre de capacite (presentiel) associes a un theme
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_titrecapacites($theme) {

	if (VERSION_BASE > VERSION) {

		$req = "A IMPLEMENTER";
		$grilles = pg_query($req);

	} else
		$titrecapacites = get_titrecapacites_old($theme);

	return $titrecapacites;
}

/**
*	Obtenir les ressources de type fichier  associees a un theme (OLD)
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_ressources_fichier_old($theme) {
	$req = "select * from ressource_fic  where num_themedir=$theme";
	$res = pg_query($req);
	return $res;
}

/**
*	Obtenir les ressources de type fichier associes a un theme
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_ressources_fichier($theme) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_get_categorie_fichiers_theme(7,$theme) as  (id int4, libelle varchar, type int4, connecte bool)";
		$res = pg_query($req);
	} else
		$res = get_theme_ressources_fichier_old($theme);
	return $res;
}


/**
*	Obtenir les ressources de type scenario associes a un theme
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_ressources_scenario($theme) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_get_categorie_fichiers_theme(1,$theme) as  (id int4, libelle varchar, type int4, connecte bool)";
		$res = pg_query($req);
	} else
		$res = get_theme_ressources_fichier_old($theme);
	return $res;
}

/**
*	Obtenir les ressources de type scenario dynamique associes a un theme
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_ressources_scenario_dynamique($theme) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_get_categorie_fichiers_theme(59,$theme) as  (id int4, libelle varchar, type int4, connecte bool)";
		$res = pg_query($req);
	} else
		$res = get_theme_ressources_fichier_old($theme);
	return $res;
}

/**
 * Obtenir les ressources glossaire associes  un theme
 * @param integer: le numero du theme desire
 * @return integer : l'entier resultat de la requete
 */
 function get_theme_ressources_glossaire($theme){
 
		$req = "select * from contraintes.af_get_categorie_fichiers_theme(66,$theme) as  (id int4, libelle varchar, type int4, connecte bool)";
		$res = pg_query($req);
	
	return $res;
}
 


/**
*	Obtenir les ressources associees a un theme (OLD)
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_ressources_old($theme) {
	$req="SELECT G.num_gest_res, G.libelle , G.num_fic, G.num_section, G.num_espace, G.datedeb, G.datefin, G.nouveau, G.motcle, G.type, G.num_cal, T.num_themedir 
		FROM ressource_gest G LEFT OUTER JOIN  ressource_txt T
		ON (G.num_fic=T.num_text AND T.num_themedir=$theme)
		LEFT OUTER JOIN ressource_fic F
		ON (G.num_fic=F.num_fic AND F.num_themedir=$theme )"; 
	$res = pg_query($req);
	return $res;
}

/**
*	Obtenir les ressources associes a un theme
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_ressources($theme) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_get_theme_ressources($theme) as (id int4,libelle varchar,fichier int4,mots_cles text)";
		$res = pg_query($req);
	} else
		$res = get_theme_ressources_old($theme);
	return $res;
}


/**
*	Obtenir les ressources de type texte  associees a un theme (OLD)
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_ressources_texte_old($theme) {
	$req = "select * from ressource_txt  where num_themedir=$theme";
	$res = pg_query($req);
	return $res;
}

/**
*	Obtenir les ressources de type texte associes a un theme
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_ressources_texte($theme) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_get_categorie_fichiers_textes_theme(26,$theme) AS (id int4, libelle varchar,type int4,
		 connecte bool,libelle2 varchar,adresse varchar(255),
  description varchar(255), mise_en_forme text, date_modification text)";
		$res = pg_query($req);
	} else
		$res = get_theme_ressources_texte_old($theme);
	return $res;
}

/**
*	Obtenir les formations avec ressources associees a un theme (OLD)
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_formations_ressource_old($theme) {
	$req = "select distinct num_cal,nom_cal  from calendrier where num_cal in
	                (select distinct num_cal from ressource_gest where
	                (num_fic in (select num_fic from ressource_fic where num_themedir=$theme) or
	                num_fic in (select num_text from ressource_txt where num_themedir=$theme))) and num_cal in
	                (select g_num_cal from gestionnaire);";
	$res = pg_query($req);
	return $res;
}

/**
*	Obtenir les formations avec ressources associes a un theme
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_formations_ressource($theme) {
	if (VERSION_BASE > VERSION) {
		$req = "A IMPLEMENTER";
		$res = pg_query($req);
	} else
		$res = get_theme_formations_ressource_old($theme);
	return $res;
}

/**
    Obtenir les mdias qcm associs  un theme (OLD)
	@deprecated utiliser la fonction get_theme_media_evaluation($theme)
    @param integer : le numro du theme
    @return integer : l' entier rsultat de la requte
*/
function get_theme_qcm_medias_old($theme) {
	$req = "select num_fic,lower(nom_fic) as minnom from ficmediaqcm where num_themedir=$theme order by minnom";
	$mediaqcm = pg_query($req);
	return $mediaqcm;
}
/**
    Obtenir les mdias qcm associs  un theme
	@deprecated utiliser la fonction get_theme_media_evaluation($theme)
    @param integer : le numro du theme
    @return integer : l' entier rsultat de la requte
*/
function get_theme_qcm_medias($theme) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_get_categorie_fichiers_theme(2, $theme) AS (id int4, libelle varchar, \"type\" int4, connecte bool)";
		$mediaqcm = pg_query($req);

	} else
		$mediaqcm = get_theme_qcm_medias_old($theme);
	return $mediaqcm;
}

/**
    Obtenir les reponses associes  un theme (OLD)
	@deprecated utiliser get_theme_qcm_reponses($theme)
    @param integer : le numro du theme
    @return integer : l'entier resultat de la requte
*/
function get_theme_reponses_old($theme) {
	$req = "select num_rep,lower(libelle_rep) as minlib,theme from reponse where theme=$theme order by minlib";
	$reponses = pg_query($req);
	return $reponses;
}
/**
    Obtenir les reponses associes  un theme
	@deprecated utiliser get_theme_qcm_reponses($theme)
    @param integer : le numro du theme
    @return integer : l'entier resultat de la requte
*/
function get_theme_reponses($theme) {
	if (VERSION_BASE > VERSION) {
		echo "A IMPLEMENTER";
	} else
		$reponses = get_theme_reponses_old($theme);
	return $reponses;
}



/**
    Obtenir les propositions de sondage associees a un theme (OLD)
    @param integer : le numero du theme
    @return integer : l'entier resultat de la requete
*/
function get_theme_sondage_propositions_old($theme) {
	$sql = "select num_prop,lower(libelle_prop) as minlib,theme from proposition where theme=$theme order by minlib";
	$propositions = pg_query($sql);
	return $propositions;

}
/**
    Obtenir les propositions de sondage associees a un theme
    @param integer : le numero du theme
    @return integer : l'entier resultat de la requete
*/
function get_theme_sondage_propositions($theme) {
	if (VERSION_BASE > VERSION) {
		/*
		$req = "select * FROM contraintes.af_get_theme_sondage_reponses($theme) AS (id int4, libelle varchar, interpretation_html bool)";
		$propositions = pg_query($req);
		*/
		$propositions=get_theme_question_reponse_reponses($theme,17,2);
	} else
		$propositions = get_theme_sondage_propositions_old($theme);
	return $propositions;
}

/**
    Obtenir les questions de qcm pour un theme (OLD)

    @param integer : le numro du theme
    @param integer : le resultat de la requte: id int4, libelle varchar,  interpretation_html bool, \"type\" int4, reponse bool
*/
function get_theme_qcm_questions_old($theme) {
	$sql = "select num_question, libelle_question, inter_html, 'q', 'FALSE'  from question where theme=$theme and num_question in (select qr_num_question from quest_rep) order by lower(libelle_question)";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les questions de qcm pour un theme

    @param integer : le numro du theme
    @param integer : le resultat de la requte: id int4, libelle varchar,  interpretation_html bool, \"type\" int4, reponse bool
*/
function get_theme_qcm_questions($theme) {
	if (VERSION_BASE > VERSION) {
		$res=get_theme_question_reponse_questions($theme, 17, 1);
	} else
		$res = get_theme_qcm_questions_old($theme);
	return $res;
}

/**
    Obtenir les questions de sondage pour un theme (OLD)

    @param integer : le numro du theme
    @param integer : le resultat de la requte
*/
function get_theme_questions_sondage_old($theme) {
	$sql = "select * from question_sondage where theme=$theme and num_sondage in (select num_sondage from proposition_sondage) order by lower(question)";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les questions de sondage pour un theme

    @param integer : le numro du theme
    @param integer : le resultat de la requte
*/
function get_theme_questions_sondage($theme) {
	if (VERSION_BASE > VERSION) {
		//$sql="select * from contraintes.af_get_theme_qcm_elements($theme) as (id int4,libelle varchar,interpretation_html bool)";
		//$sql="select T_id,T_libelle,T_interpretation_html from contraintes.af_get_theme_qcm_questions($theme) as (T_id int4,T_libelle varchar,T_interpretation_html bool)";
		//$sql="select * from contraintes.af_get_theme_qcm_questions($theme) as (T_id int4,T_libelle varchar,T_interpretation_html bool)";
		$sql = "select * from contraintes.af_get_theme_question_sondage($theme) as (id int4,libelle varchar,idq int4)";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_theme_questions_sondage_old($theme);
	return $res;
}



/**
*   R?cup?rer les exercices de type remplir les blancs pour un theme donn? (OLD)
*
*   Retourne les remplir les blancs du theme
*   @deprecated : utiliser get_theme_blancs
*    @param  integer : le numero du theme
*    @return  integer : resultat de la requete
*
*/
function get_theme_blancs_infos_old($theme) {
	$sql = "select * FROM gest_ftb WHERE theme=$theme;";
	return (pg_query($sql));
}

/**
*   Rcuprer les exercices de type remplir les blancs pour un theme donn?
*
*   Retourne les remplir les blancs du theme
*   @deprecated : utiliser get_theme_blancs
*    @param  integer : le numero du theme
*    @return  integer : resultat de la requete
*
*/
function get_theme_blancs_infos($theme) {
	if (VERSION_BASE > VERSION) {
		$req = "A IMPLEMENTER";
		$blancs = pg_query($req);
	} else
		$res = get_theme_blancs_infos_old($theme);
	return $res;
}

/**
    Obtenir les exotlc classs par mode rendu pour un theme donn (OLD)
*
*    @param  integer : le numero du theme
*   @param string : le sens pour le tri (asc ou desc)
*    @return  integer : resultat de la requete
*/
function get_theme_exotlc_classement_type_old($theme, $desc) {
	$sql = "select distinct num_exo, titre,lower( titre) as minus, mode_rendu from exotlc,  fictlc, gestfic where fictlc.num_fic=gestfic.gestfic_num_fic
	                and gestfic.gestfic_num_exo=exotlc.num_exo and fictlc.num_themedir=$theme  order by mode_rendu $desc";
	return (pg_query($sql));
}
/**
    Obtenir les exotlc classs par mode rendu pour un theme donn
*
*    @param  integer : le numero du theme
*   @param string : le sens pour le tri (asc ou desc)
*    @return  integer : resultat de la requete
*/
function get_theme_exotlc_classement_type($theme, $desc) {
	if (VERSION_BASE > VERSION) {
		
		 $sql="select * from contraintes.af_get_theme_exostlc_type($theme,'$desc') as (id int4,libelle varchar,libel text,type int4, date_creation timestamp) ";
		$res=pg_query($sql);
	} else
		$res = get_theme_exotlc_classement_type_old($theme, $desc);
	return $res;
}

/**
    Obtenir les exotlc classs par titre pour un theme donn (OLD)
*
*    @param  integer : le numero du theme
*   @param string : le sens pour le tri (asc ou desc)
*    @return  integer : resultat de la requete
*/
function get_theme_exotlc_classement_titre_old($theme, $desc) {
	$sql = "select distinct num_exo, titre,lower( titre) as minus, mode_rendu from exotlc,  fictlc, gestfic where fictlc.num_fic=gestfic.gestfic_num_fic
	                and gestfic.gestfic_num_exo=exotlc.num_exo and fictlc.num_themedir=$theme  order by minus $desc";
	return (pg_query($sql));
}
/**
    Obtenir les exotlc classs par titre pour un theme donn
*
*    @param  integer : le numero du theme
*   @param string : le sens pour le tri (asc ou desc)
*    @return  integer : resultat de la requete
*/
function get_theme_exotlc_classement_titre($theme, $desc) {
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_theme_exostlc_titre($theme,'$desc') as (id int4,libelle varchar,libel text,type int4, date_creation timestamp) ";
		$res=pg_query($sql);
	} else
		$res = get_theme_exotlc_classement_titre_old($theme, $desc);
	return $res;
}

/**
    Obtenir les fichiers des exercices  tlcharger pour un theme donn (OLD)
*
*    @param  integer : le numero du theme
*    @return  integer : resultat de la requete
*/
function get_theme_fichiers_exotlc_old($theme, $autre_theme = "") {
	$sql = "select * from fictlc where num_themedir=$theme";
	if (!empty ($autre_theme))
		$sql .= " or num_themedir=$autre_theme";
	return (pg_query($sql));
}
/**
    Obtenir les fichiers des exercices  tlcharger pour un theme donn
*
*    @param  integer : le numero du theme
*    @return  integer : resultat de la requete
*/
function get_theme_fichiers_exotlc($theme, $autre_theme = "") {
	if (VERSION_BASE > VERSION) {
		//$req = "A IMPLEMENTER";
		if(empty($autre_theme))
			$sql="select * from contraintes.af_get_categorie_fichiers_theme(5,$theme) 
						as (id int4,libelle varchar,type int4,connecte bool)";
		else
			$sql="select * from contraintes.af_get_categorie_fichiers_themes(5,$theme,$autre_theme) 
						as (id int4,libelle varchar,type int4,connecte bool)";
		$res=pg_query($sql);
	} else
		$res = get_theme_fichiers_exotlc_old($theme, $autre_theme);
	return $res;
}

/**
    Obtenir les fichiers correction des exercices  tlcharger pour un theme donn (OLD)
*
*    @param  integer : le numero du theme
*    @return  integer : resultat de la requete
*/
function get_theme_fichiers_correction_exotlc_old($theme, $autre_theme = "") {
	$sql = "select * from fictlc where num_themedir=$theme";
	if (!empty ($autre_theme))
		$sql .= " or num_themedir=$autre_theme";
	return (pg_query($sql));
}
/**
    Obtenir les fichiers correction des exercices  tlcharger pour un theme donn
*
*    @param  integer : le numero du theme
*    @return  integer : resultat de la requete
*/
function get_theme_fichiers_correction_exotlc($theme, $autre_theme = "") {
	if (VERSION_BASE > VERSION) {
		//$req = "A IMPLEMENTER";
		if(empty($autre_theme))
			$sql="select * from contraintes.af_get_categorie_fichiers_theme(9,$theme) 
						as (id int4,libelle varchar,type int4,connecte bool)";
		else
			$sql="select * from contraintes.af_get_categorie_fichiers_themes(9,$theme,$autre_theme) 
						as (id int4,libelle varchar,type int4,connecte bool)";
		$res=pg_query($sql);
	} else
		$res = get_theme_fichiers_correction_exotlc_old($theme, $autre_theme);
	return $res;
}

/**
    Obtenir les medias des exotlc pour un theme donn (OLD)
*
*    @param  integer : le numero du theme
*    @return  integer : resultat de la requete
*/
function get_theme_medias_exotlc_old($theme) {
	$sql = "select * from ficmediatlc where num_themedir=$theme";
	return (pg_query($sql));
}
/**
    Obtenir les medias des exotlc pour un theme donn
*
*    @param  integer : le numero du theme
*    @return  integer : resultat de la requete
*/
function get_theme_medias_exotlc($theme) {
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_categorie_fichiers_theme(6,$theme) as (id int4,libelle varchar,type int4,connecte bool)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	} 
	else
		$res = get_theme_medias_exotlc_old($theme);
	return $res;
}


/**
	Obtenir les categories ayant des lments pour le theme donn.
	@param String: numro du theme
	@return integer: resultat de la requete
*/
function get_theme_categories($theme) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_get_theme_categories($theme) AS ( id int4 ,  libelle varchar, table_cible varchar,  gestionnaire_contenu bool, code varchar )";
		//echo $req."<br>";
		$res = pg_query($req);
	} else
		print ("La fonction get_theme_categories($theme) n'existe pas pour la version ".VERSION);

	return $res;
}

/**
    Obtenir les question et sondages a reponses communes (QSRC) associes a un theme
    @param integer : le numero du theme
    @param integer : l'identifiant du type de QSRC
    @param varchar : "type" pour un tris par type, tris sur le libelle par default
    @param varchar : "DESC" pour un tris inverse, "ASC" par default
    @return integer : l'entier resultat de la requete :(id int4, libelle varchar, type int4, question varchar, question_reponse int4)
*/
function get_theme_qsrcs($theme,  $type, $ordre="", $desc="") {
	if($ordre=="type")$tris="ORDER BY type $desc";
	else $tris="ORDER BY libelle $desc";
	
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM contraintes.af_get_theme_qsrcs($theme, 23, $type) AS (id int4, libelle varchar, type int4, question varchar, question_reponse int4)$tris";
		//echo "$req<br>";
		$question_reponses = pg_query($req);
	} else
		die("La fonction get_theme_qsrcs($theme,  $type)   n'existe pas pour la version ".VERSION);
		
	return $question_reponses;
}


/**
	Obtenir les qrc pour le theme donn (OLD)
	@param String: numro du theme
	@return integer: resultat de la requete (id int4, libelle varchar, type int4, question varchar, positionnement int4)
*/
function get_theme_qrcs_old($theme, $ordre="", $desc="") {
	if($ordre=="type")$tris="ORDER BY type_test $desc";
	else $tris="ORDER BY ordre $desc";
	$sql = "select distinct id, titre, type_test, question_commune, id_test,lower(titre) as ordre from serie_exo,test where id=id_test and theme=$theme and type_test='m' $tris";
//	echo $sql;
	return (pg_query($sql));
}
/**
	Obtenir les qrc pour le theme donn
	@param String: numro du theme
	@param varchar : "type" pour un tris par type, tris sur le libelle par default
    @param varchar : "DESC" pour un tris inverse, "ASC" par default
	@return integer: resultat de la requete (id int4, libelle varchar, type int4, question varchar, positionnement int4)
*/
function get_theme_qrcs($theme, $ordre="", $desc="") {
	if (VERSION_BASE > VERSION) {
		return get_theme_qsrcs($theme,  4, $ordre, $desc);
	} else
		$res = get_theme_qrcs_old($theme, $ordre, $desc);
	return $res;
}

/**
	Obtenir les src pour le theme donn (OLD)
	@param String: numro du theme
	@return integer: resultat de la requete
*/
function get_theme_srcs_old($theme, $ordre="", $desc="") {
	$sql = "select distinct id,lower(titre) as ordre from serie_exo,test where id=id_test and theme=$theme and type_test='o' order by ordre";
	return (pg_query($sql));
}
/**
	Obtenir les qrc pour le theme donn
	@param String: numro du theme
	@return integer: resultat de la requete
*/
function get_theme_srcs($theme, $ordre="", $desc="") {
	if (VERSION_BASE > VERSION) {
		return get_theme_qsrcs($theme,  5, $ordre, $desc);
	} else
		$res = get_theme_srcs_old($theme, $ordre, $desc);
	return $res;
}

/**
	Obtenir les infos sondages appartenant  une serie pour un theme donne (OLD)

	@param integer : le numero du theme
 	@return integer : le resultat de la requete
*/
function get_theme_sondages_infos_serie_old($theme) {
	$sql = "select * from question_sondage where theme=$theme and num_sondage in
				(select id_exo from asso_exo_serie where type_exo='s' or type_exo='o') order by lower(question)";
	return (pg_query($sql));
}
/**
	Obtenir les infos sondages appartenant  une serie pour un theme donne

	@param integer : le numero du theme
 	@return integer : le resultat de la requete
*/
function get_theme_sondages_infos_serie($theme) {
	if (VERSION_BASE > VERSION) {
		$req = "A IMPLEMENTER";
	} else
		$res = get_theme_sondages_infos_serie_old($theme);
	return $res;
}

/**
	Obtenir les grilles avec capacite pour un theme (OLD)

 	@param integer : le numero du theme
 	@return integer : le resultat de la requete
*/
function get_theme_grilles_capacite_old($theme) {
	$sql = "select num_grille,libelle_grille from grille where num_grille in
				(select distinct gt_num_grille from grilletitrecapa where gt_num_titrecapacite in
				(select distinct tr_num_titrecapacite from titrecapa)) and theme=$theme";
	return (pg_query($sql));
}
/**
	Obtenir les grilles avec capacite pour un theme

 	@param integer : le numero du theme
 	@return integer : le resultat de la requete
*/
function get_theme_grilles_capacite($theme) {
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_theme_grilles_capacite($theme) as (id int4,libelle varchar)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	} 
	else
		$res = get_theme_grilles_capacite_old($theme);
	return $res;
}

/**
	Obtenir les grilles avec titrecapacite pour un theme (OLD)

 	@param integer : le numero du theme
 	@return integer : le resultat de la requete
*/
function get_theme_grilles_titrecapacite_old($theme) {
	$sql = "select num_grille,libelle_grille from grille where num_grille in
				(select distinct gt_num_grille from grilletitrecapa ) and theme=$theme";
	return (pg_query($sql));
}
/**
	Obtenir les grilles avec titrecapacite pour un theme

 	@param integer : le numero du theme
 	@return integer : le resultat de la requete
*/
function get_theme_grilles_titrecapacite($theme) {
	if (VERSION_BASE > VERSION) {
		$req = "A IMPLEMENTER";
	} else
		$res = get_theme_grilles_titrecapacite_old($theme);
	return $res;
}

/**
	Supprimer un theme vide.
	Attention, le repertoire du theme sur le disque reste  supprimer.
	@param integer : le numero du theme  supprimer
	@return bool: TRUE si la suppression a t faite, FALSE sinon
*/
function del_theme($id) {
	if (VERSION_BASE > VERSION) {

		$req = "select * from contraintes.af_del_theme($id) ";
		$res = pg_query($req);

	} else
		echo "A IMPLEMENTER";

	return pg_result($res, 0, 0);
}

/**
    Obtenir les question-reponses associes a un theme
    @param integer : le numero du theme
    @param integer : l'identifiant du type de question_reponse
    @return integer : l'entier resultat de la requete : id int4, type int4, radio bool
*/
function get_theme_question_reponses($theme,  $type) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM contraintes.af_get_theme_question_reponses($theme, 27, $type) AS (id int4, type int4, radio bool)";
		//echo "$req<br>";
		$question_reponses = pg_query($req);
	} else
		print("La fonction get_theme_question_reponses($theme,  $type)  n'existe pas pour la version ".VERSION);
		
	return $question_reponses;
}

/**
    Obtenir les qcms associes a un theme (OLD)
    @param integer : le numero du theme
    @return integer : l'entier resultat de la requete :id int4, type int4, radio bool
*/
function get_theme_qcms_old($theme) {
	$sql="SELECT DISTINCT Q.num_question, 'q', 'FALSE'
			FROM question Q, quest_rep QR
			WHERE Q.theme=$theme
			AND Q.num_question=QR.qr_num_question";
	//echo $sql."<br>";
	return pg_query($sql);
	
}

/**
    Obtenir les qcms associes a un theme
    @param integer : le numero du theme
    @return integer : l'entier resultat de la requete :id int4, type int4, radio bool
*/
function get_theme_qcms($theme) {
	if (VERSION_BASE > VERSION) {
		return get_theme_question_reponses($theme, 1);
	} else{
		return  get_theme_qcms_old($theme);		
	}
}

/**
	Obtenir les questions de sondage pour un theme (OLD)
	
	@param integer : le numero du theme
	@return integer : l'entier resultat de la requete
*/
function get_theme_sondages_old($theme){
	/*
	$sql="select * from question_sondage where theme=$theme and num_sondage in (select num_sondage from proposition_sondage)
			order by lower(question)";
	*/
	$sql="select distinct q.num_sondage,'s',q.type_sondage from question_sondage q,proposition_sondage ps 
			where q.theme=$theme and q.num_sondage=ps.num_sondage";
	return pg_query($sql);
									
}
/**
    Obtenir les lments de question-reponses associes a un theme
    @param integer : le numero du theme
    @param integer : l'identifiant du sondage
    @return integer : l'entier resultat de la requete :id int4, type int4, radio bool
*/
function get_theme_sondages($theme) {
	if (VERSION_BASE > VERSION) {
		return get_theme_question_reponses($theme, 2);
	} else{
		return  get_theme_sondages_old($theme);		
	}
}

/**
    Obtenir les lments de question-reponses associes a un theme
    @param integer : le numero du theme
    @param integer : l'identifiant de la categorie de question_reponse
    @param integer : l'identifiant du type de question_reponse
    @param integer : l'identifiant du type de question_reponse_element
    @return integer : l'entier resultat de la requete :id int4, libelle varchar,  interpretation_html bool, \"type\" int4, reponse bool
*/
function get_theme_question_reponse_elements($theme, $categorie, $type, $reponse) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM contraintes.af_get_theme_question_reponse_elements($theme, $categorie, $type, $reponse) AS (id int4, libelle varchar,  interpretation_html bool, \"type\" int4, reponse bool)";
		//echo "$req<br>";
		$reponses = pg_query($req);
	} else
		print("La fonction get_theme_question_reponse_elements($theme, $categorie, $type, $reponse) n'existe pas pour la version ".VERSION);
		
	return $reponses;
}

/**
    Obtenir les reponses de questions reponses associees a un theme
    @param integer : le numero du theme
    @param integer : l'identifiant de la categorie de question_reponse
    @param integer : l'identifiant du type de question_reponse
    @return integer : l'entier resultat de la requete :(id int4, libelle varchar, interpretation_html bool)
*/
function get_theme_question_reponse_reponses($theme, $categorie, $type) {
	if (VERSION_BASE > VERSION) {
		$reponses = get_theme_question_reponse_elements($theme, $categorie, $type, "TRUE");
	} else
		print("La fonction get_theme_question_reponse_reponses($theme, $categorie, $type) n'existe pas pour la version ".VERSION);
		
	return $reponses;
}

/**
    Obtenir les reponses de questions reponses associees a un theme
    @param integer : le numero du theme
    @param integer : l'identifiant de la categorie de question_reponse
    @param integer : l'identifiant du type de question_reponse
    @return integer : l'entier resultat de la requete :id int4, libelle varchar,  interpretation_html bool, \"type\" int4, reponse bool
*/
function get_theme_question_reponse_questions($theme, $categorie, $type) {
	if (VERSION_BASE > VERSION) {
		$questions = get_theme_question_reponse_elements($theme, $categorie, $type, "FALSE");
	} else
		print("La fonction get_theme_question_reponse_questions($theme, $categorie, $type) n'existe pas pour la version ".VERSION);
		
	return $questions;
}

/**
*    Obtenir    les medias pour les evaluations (OLD)
*	@deprecated		utiliser la fonction
* gnrique get_categorie_fichiers_theme(4,$theme)
*    @param  integer : le numero du theme
*    @return  integer : resultat de la requete
*/
function get_theme_medias_evaluations_old($theme) {
	$req = "select num_fic,lower(nom_fic) AS minnom from ficmediaqcm where num_themedir=$theme order by minnom;";
	//echo $req;
	return pg_query($req);
}

/**
*    Obtenir    les medias pour les evaluations
*	@deprecated	 utiliser la fonction gnrique get_categorie_fichiers_theme(4,$theme)
*    @param  integer : le numero du theme
*    @return  integer : resultat de la requete
*/
function get_theme_medias_evaluations($theme) {
	if (VERSION_BASE > VERSION) {
		$res = get_categorie_fichiers_theme(4, $theme);
	} else
		$res = get_theme_medias_evaluations_old($theme);
	return $res;
}

/**
    Obtenir les reponses de qcm associees a un theme (OLD)
    @deprecated utiliser get_theme_question_reponse_reponses($theme)
    @param integer : le numero du theme
    @return integer : l'entier resultat de la requete
*/
function get_theme_qcm_reponses_old($theme) {
	$sql = "select num_rep,lower(libelle_rep) as minlib,theme from reponse where theme=$theme order by minlib";
	//echo "$sql<br>";
	$reponses = pg_query($sql);
	return $reponses;

}
/**
    Obtenir les reponses de qcm associees a un theme
    @deprecated utiliser get_theme_question_reponse_reponses($theme)
    @param integer : le numero du theme
    @return integer : l'entier resultat de la requete
*/
function get_theme_qcm_reponses($theme) {
	if (VERSION_BASE > VERSION) {
		$reponses = get_theme_question_reponse_reponses($theme, 17, 1);
	} else
		$reponses = get_theme_qcm_reponses_old($theme);
	return $reponses;
}

/**
	Obtenir les questions de sondage pour un theme (OLD)
	
	@param integer : le numero du theme
	@return integer : l'entier resultat de la requete
*/
function get_theme_sondage_questions_old($theme){
	$sql="select * from question_sondage where theme=$theme and num_sondage in (select num_sondage from proposition_sondage)
			order by lower(question)";
	return pg_query($sql);
									
}
/**
	Obtenir les questions de sondage pour un theme (OLD)
	
	@param integer : le numero du theme
	@return integer : l'entier resultat de la requete
*/
function get_theme_sondage_questions($theme){
	if(VERSION_BASE>VERSION){
		$res=get_theme_question_reponse_questions($theme,17,2);
	}
	else
		$res=get_theme_sondage_questions_old($theme);
	return $res;
}

 /**
    Obtenir les propositions de sondage associees a un theme (OLD)
    @param integer : le numero du theme
    @return integer : l'entier resultat de la requete
*/
function get_theme_sondage_reponses_old($theme) {
	$sql = "select num_prop,lower(libelle_prop) as minlib,theme from proposition where theme=$theme order by minlib";
	$propositions = pg_query($sql);
	return $propositions;

}
/**
    Obtenir les propositions de sondage associees a un theme
    @param integer : le numero du theme
    @return integer : l'entier resultat de la requete
*/
function get_theme_sondage_reponses($theme) {
	if (VERSION_BASE > VERSION) {
		/*
		$req = "select * FROM contraintes.af_get_theme_sondage_reponses($theme) AS (id int4, libelle varchar, interpretation_html bool)";
		$propositions = pg_query($req);
		*/
		$propositions=get_theme_question_reponse_reponses($theme,17,2);
	} else
		$propositions = get_theme_sondage_reponses_old($theme);
	return $propositions;
}

/**
	Obtenir les ftb(remplir les blancs) pour un theme donn (OLD)
	@param integer :  le numero du theme
    @return integer : l'entier resultat de la requete
*/
function get_theme_ftbs_old($theme){
	$sql= "select id,text,show_word,inter_html FROM gest_ftb WHERE theme=$theme;";
	return (pg_query($sql));
}
/**
	Obtenir les ftb(remplir les blancs) pour un theme donn 
	@param integer :  le numero du theme
    @return integer : l'entier resultat de la requete
*/
function get_theme_ftbs($theme){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_theme_ftbs($theme,14) as (id int4,text text,voir_mots bool,interpretation_html bool)";
		//echo "sql=$sql<br>";
		return pg_query($sql);
	}
	else
		$res=get_theme_ftbs_old($theme);
	return $res;
}

/**
	Obtenir les series pour un theme donn (OLD)
	@param integer :  le numero du theme
	@param integer: facultatif, classement par types d'evaluations ($classement= 'TYPES') ou par libelle ($classement= 'LIBELLES')(par defaut)  
    @return integer : l'entier resultat de la requete (id int4,libelle varchar, type int4, libelle_type varchar) 
*/
function get_theme_series_old($theme, $classement='LIBELLES'){
	if($classement=='TYPES')$chaine_classement=" ORDER BY type_evaluations";
	else $chaine_classement=" ORDER BY ordre";
	//attention, la requete est sous simple cotes pour ne pas interprter les $MSG_xxxx (il faut retourner les chaines)
	$sql = 'SELECT  DISTINCT id,titre, type_exo AS type_evaluations,
				CASE 	WHEN type_exo=\'q\' THEN \'$MSG_547\'
					WHEN type_exo=\'s\' THEN \'$MSG_1483\'
					WHEN type_exo=\'f\' THEN \'$MSG_1372\'
					WHEN type_exo=\'m\' THEN \'$MSG_1863\'
					WHEN type_exo=\'o\' THEN \'$MSG_1864\'
					ELSE NULL END
				AS libelle_type,lower(titre) as ordre   
			FROM (
				SELECT  id, titre, SUM(cnt)  AS somme 
				FROM (
					SELECT  S.id AS id, titre, A.type_exo AS type_evaluations, CASE WHEN A.type_exo IS NULL THEN 0 ELSE 1 END AS cnt
					FROM serie_exo S LEFT OUTER JOIN asso_exo_serie A ON (S.id=A.id_serie )
					WHERE theme='.$theme.'
					AND id NOT IN
			                (select num_serie from serie_aleatoire)
					AND id NOT IN
			                (select id_test from test)
					AND id NOT IN (select num_c_q_e_d FROM gestparcours WHERE type_etape=\'C\' AND attach_parcours!=0 )
					GROUP BY S.id,A.type_exo, S.titre 
				) AS mono_type
				GROUP BY id,titre
			) AS series_types
			LEFT OUTER JOIN asso_exo_serie ON (id=id_serie AND somme=1) '.$chaine_classement;
			//echo "$sql<br>";
	$res = pg_query($sql);
	return $res;
}
/**
	Obtenir les series pour un theme donn 
	@param integer :  le numero du theme
   	@param integer: facultatif, classement par types d'evaluations ($classement= 'TYPES') ou par libelle ($classement= 'LIBELLES')(par defaut)  
    @return integer : l'entier resultat de la requete :(id int4,libelle varchar, type int4, libelle_type varchar) 
*/
function get_theme_series($theme, $classement='LIBELLES'){
	if (VERSION_BASE > VERSION) {
		if($classement=='TYPES')$chaine_classement=" ORDER BY type";
		else $chaine_classement="";
		
		$sql="select * from contraintes.af_get_theme_series($theme) as (id int4,libelle varchar, type int4, libelle_type varchar) $chaine_classement";
		//echo "$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=get_theme_series_old($theme, $classement);
	return $res;
}

/**
	Obtenir les positionnements pour un theme donn (OLD)
	@param integer :  le numero du theme
    @return integer : l'entier resultat de la requete
*/
function get_theme_positionnements_old($theme){
	$sql="	SELECT S.id, S.titre, T.type_test , T.chrono, S.id,  S.id, S.theme 
			FROM test T, serie_exo S 
			WHERE T.id_test=S.id
			AND (type_test='q' OR type_test='s')
			AND S.theme=$theme";
	//echo $sql."<br>";
	return pg_query($sql);
}

/**
	Obtenir les positionnements pour un theme donn 
	@param integer :  le numero du theme
    @return integer : l'entier resultat de la requete
*/
function get_theme_positionnements($theme){
	if (VERSION_BASE > VERSION) {
		 $sql="select * from contraintes.af_get_theme_positionnements($theme) as (id int4, libelle varchar, type_question int4, chrono int4, serie_aleatoire int4, question_reponse int4, theme int4 )";
		 //echo $sql."<br>";
		 $res=pg_query($sql);
	}
	else
		$res=get_theme_positionnements_old($theme);
	return $res;
}


/**
	Obtenir les series aleatoires pour un type et un theme (OLD)
	@param integer :  le numero du theme
	@param integer : numero du type
    @return integer : l'entier resultat de la requete
*/
function get_theme_series_aleatoires_old($theme,$type){
	if($type==0)
		$sql="SELECT id,titre, lower(titre) AS ordre
                        FROM serie_exo S
                        WHERE id IN (select num_serie from gestserie)
                        AND theme=$theme ORDER BY ordre ; ";
	else
		$sql="SELECT id,titre, lower(titre) AS ordre
                FROM serie_exo
                WHERE id IN (select distinct num_serie from serie_aleatoire where mode=$type)
                and theme=$theme ORDER by ordre ;";
		
	return pg_query($sql);
}
/**
	Obtenir les series aleatoires pour un type et un theme 
	@param integer :  le numero du theme
	@param integer : numero du type
    @return integer : l'entier resultat de la requete
*/
function get_theme_series_aleatoires($theme,$type){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_theme_series_aleatoires($theme,$type) as (id int4,libelle varchar, type varchar, libelle_type varchar)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=get_theme_series_aleatoires_old($theme,$type);
	return $res;
}

/**
	Obtenir les series non vide pour un theme donn (OLD)
	@param integer :  le numero du theme
    @return integer : l'entier resultat de la requete
*/
function get_theme_series_non_vide_old($theme){
	$sql = "select distinct id,titre, lower(titre) as ordre from serie_exo where theme=$theme and id not in
	                (select num_serie from serie_aleatoire) and id in (select distinct id_serie from asso_exo_serie) order by ordre";
	$res = pg_query($sql);
	return $res;
}
/**
	Obtenir les series non vide  pour un theme donn 
	@param integer :  le numero du theme
    @return integer : l'entier resultat de la requete
*/
function get_theme_series_non_vide($theme){
	if (VERSION_BASE > VERSION) {
		 $sql="select * from contraintes.af_get_theme_series_non_vide($theme,19) as (id int4,libelle varchar, type int4, libelle_type varchar)";
		 $res=pg_query($sql);
	}
	else
		$res=get_theme_series_old($theme);
	return $res;
}

/**
	Obtenir les evaluations pour un theme (old)
	@param integer : numero du theme
	@return integer : resultat requete
*/
function get_theme_evaluations_old($theme){
	$sql="select distinct id_exo,type_exo from asso_exo_serie where id_serie in
				(select id from serie_exo where theme=$theme) and id_serie not in 
				(select id_test from test) and id_serie not in 
				(select num_serie from serie_aleatoire)";
	$res=pg_query($sql);
	return $res;
}
 /**
	Obtenir les evaluations pour un theme 
	@param integer : numero du theme
	@return integer : resultat requete
*/
function get_theme_evaluations($theme){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_theme_evaluations($theme) as (id int4,type int4)";
		$res=pg_query($sql);
	}
	else
		$res=get_theme_evaluations_old($theme);
	return $res;
}

/**
*	Obtenir les modeles de correction associes a un theme(OLD)
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_modeles_correction_old($theme) {

	$req = "select *  from CORRECTION_MODELE where num_theme=$theme  order by nom;";
	$res = pg_query($req);
	//echo $req;
	return $res;
}

/**
*	Obtenir les modeles  de correction associes a un theme
*
*	@param integer: le numero du theme desire
*   @deprecated : utiliser get_theme_modeles_correction
*	@return integer : l'entier resultat de la requete
*/
function get_theme_modeles_correction($theme){
	if (VERSION_BASE > VERSION) {
	    $req="select * from contraintes.af_get_theme_modeles_correction($theme) as (id int4,libelle varchar)";
		$res = pg_query($req);

	} else
		$res = get_theme_modeles_correction_old($theme);

	return $res;
}

 /**
*	Obtenir les  capacits (presentiel) associes a un theme (OLD)
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_capacites_old($theme) {

	$req = "select * from capacite where theme =$theme order by libelle_capacite;";
	$res = pg_query($req);

	return $res;
}

/**
*	Obtenir les libelles titre de capacit (presentiel) associes a un theme
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_capacites($theme) {
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_theme_capacites($theme) as (id int4,libelle varchar)";
		$res= pg_query($sql);

	} else
		$res = get_theme_capacites_old($theme);

	return $res;
}

/**
*	Obtenir les grilles (presentiel) associes a un theme (OLD)
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_grilles_old($theme) {
	$sql = "select * from grille where theme =$theme order by libelle_grille;";
	$res = pg_query($sql);
	return $res;
}

/**
*	Obtenir les libelles grille (presentiel) associes a un theme
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_grilles($theme) {
	if (VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_get_theme_grilles($theme) as (id int4 ,libelle varchar)";
		$res = pg_query($sql);
	}
	else
		$res = get_theme_grilles_old($theme);
	return $res;
}

/**
*	Obtenir les titres de capacit (presentiel) associes a un theme (OLD)
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_titrecapacites_old($theme) {

	$req = "select * from titrecapacite where theme =$theme order by libelle_titrecapacite;";
	$res = pg_query($req);

	return $res;
}

/**
*	Obtenir les titres de capacit (presentiel) associes a un theme
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_titrecapacites($theme){
	if (VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_get_theme_capacites_titres($theme) as (id int4,libelle varchar)";
		$res = pg_query($sql);
	}
	else
		$res = get_theme_titrecapacites_old($theme);
	return $res;
}

function get_theme_tests_old($theme){
	$sql="SELECT id_liste_test, nom_liste_test, dynamique, continue, media_liste_test, longueur_media, largeur_media 
			FROM liste_test T, asso_list_test A, serie_exo S
			WHERE theme=$theme AND T.id_liste_test=A.id_liste_test AND A.id_test=s.id ";
	$res = pg_query($sql);
}
function get_theme_tests($theme){
	if (VERSION_BASE > VERSION){
		$sql="";
		$res = pg_query($sql);
	}
	else
		$res = get_theme_tests_old($theme);
	return $res;
}

/**
*   R?cup?rer les exercices de type remplir les blancs pour un theme donn? (OLD)
*
*   Retourne les remplir les blancs du theme
*   
*    @param  integer : le numero du theme
*    @return  integer : resultat de la requete
*
*/
function get_theme_blancs_old($theme) {
	$sql = "select id,text,show_word,inter_html FROM gest_ftb WHERE theme=$theme;";
	return (pg_query($sql));
}

/**
*   Rcuprer les exercices de type remplir les blancs pour un theme donn?
*
*   Retourne les remplir les blancs du theme
*   
*    @param  integer : le numero du theme
*    @return  integer : resultat de la requete
*
*/
function get_theme_blancs($theme) {
	if (VERSION_BASE > VERSION) {
		$req = "A IMPLEMENTER";
		$blancs = pg_query($req);
	} else
		$res = get_theme_blancs_old($theme);
	return $res;
}

/**
	Obtenir les etapes ressource pour un theme 
	@param  integer : le numero du theme
	@return  integer : resultat de la requete
*/
function get_theme_etapes_ressource($theme){
	$sql="select * from contraintes.af_get_theme_etapes_ressource($theme) as (etape int4,libelle varchar,espace int4,section int4,ressource int4,fichier int4,mots_cles text)";
//	echo "$sql";
	return pg_query($sql);
}

/**
	Obtenir les etapes forum pour un theme 
	@param  integer : le numero du theme
	@return  integer : resultat de la requete
*/
function get_theme_etapes_forum($theme){
	$sql="select * from contraintes.af_get_theme_etapes_forum($theme)  as 
	(id int4,libelle_etape varchar,forum int4,libelle varchar,description varchar,moderation bool,moderateur_pwd varchar,fils int4,messages int4,upload bool,theme varchar,configuration int4,date_creation timestamp)"; 

	//echo "$sql";
	return pg_query($sql);
}

/**
	Obtenir les series aleatoires configurees pour un theme  (OLD)
	@param  integer : le numero du theme
	@return  integer : resultat de la requete
*/
function get_theme_series_melangees_old($theme){

}
/**
	Obtenir les series aleatoires configurees pour un theme  
	@param  integer : le numero du theme
	@return  integer : resultat de la requete
*/

function get_theme_series_aleatoire_melangees($theme,$classement='LIBELLES'){
	if (VERSION_BASE > VERSION) {
		if($classement=='TYPES')$chaine_classement=" ORDER BY type";
		else $chaine_classement="";
		$sql="select * from contraintes.af_get_theme_series_aleatoire_melangees($theme)
		as (id int4,libelle varchar, type int4, libelle_type varchar,formation int4,parcours int4) $chaine_classement ";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res= get_theme_series_melangees_old($theme);
	return $res;
	
	
}

/**
 * Obtenir les proprits d'un theme.  (OLD)
 * Ici,le rpertoire du theme est l'id, il est retourn par soucis
 * de   compatibilit entre les deux versions de la base de donnes
 * 
 * @param integer $theme le numero du theme dsir
 * @return integer L'entier resultat de la requete :(id int4, libelle varchar, nom_rep text)
 */
function get_theme_by_libelle_old($libelle) {
	$sql="select * from themedir where nom_theme LIKE '$libelle'";
	//echo "sql=$sql<br>"; 
	return pg_query($sql);
}

/**
 * Obtenir les proprits d'un theme. 
 * Ici,le rpertoire du theme est l'id, il est retourn par soucis
 * de   compatibilit entre les deux versions de la base de donnes
 * 
 * @param integer $theme le numero du theme dsir
 * @return integer L'entier resultat de la requete :(id int4, libelle varchar, nom_rep text)
 */
function get_theme_by_libelle($libelle) {

	if (VERSION_BASE > VERSION) {

		$req = "select * from contraintes.af_get_theme('$libelle') AS (id int4, libelle varchar, nom_rep text)";
//		echo "$req<br>";
		$theme = pg_query($req);

	} else
		$theme = get_theme_by_libelle_old($libelle);

	return $theme;
}

/**
 * Obtenir les types de ressources pour un theme
 * @param integer : theme
 * @return integer L'entier resultat de la requete :(id int4, libelle varchar)
 */
 function get_theme_ressource_types($theme){
 	$sql="select * from contraintes.af_get_theme_ressource_types($theme) as (id int4,libelle varchar)";
 	return pg_query($sql);
 }
 
 /**
	Met a jour le propritaire d'un theme.
	@param integer $id Le numero du theme  modifier
	@param string $owner_selection Constante: 'auth' si le proprietaire doit etre l'utilisateur identifi, 'public' s'il doit etre null
	@return bool TRUE si la modification a t faite, FALSE sinon
*/
function maj_theme_owner($id, $owner_selection) {
	if (VERSION_BASE > VERSION) {
		if($owner_selection=='auth'){
			global $auth;
			$ndividu="'".$auth->getUserId()."'";
		}elseif($owner_selection=='public'){
			$ndividu='NULL';
		}else{
			die("$owner_selection: selecteur non valide");
		}
		$req = "select * from contraintes.af_maj_theme_individu($id, $ndividu) ";
		$res = pg_query($req);

	} else
		die(" maj_theme_owner_old($id, $owner_selection) n'existe pas");

	return sql2Bool(pg_result($res, 0, 0));
}
?>