<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
Fichier de dfinition de la classe Titrecapacite

La connexion  la base de donnes doit tre $db

@author LADJANI said <sladjani@afide.fr>
@since 29/03/2005

@package titre_capacite
*/
class Titrecapacite
{

        /**
        * @var integer  Identifiant en base de donnes
        */
        var $id ;

        /**
        * @var string  Libell du titrecapacit
        */
        var $libelle ;

        /**
        * @var integer  numro de thme
        */
        var $num_theme ; //  l'avenir theme = new Theme(...)

         /**
        * @var array Les Capacite du titre de capacite
        */
        var $sesCapacites ;


        /**
        * Constructeur de la classe Titrecapacite
        * @param mixed integer $num_ou_lib identifiant de l'enregistrement en BD ou string : Libell
        * @param integer $theme identifiant du thme en base de donnes
        */
        function Titrecapacite($num_ou_lib, $theme=0)
        {
                // On determine le type du paramtre  l'aide d'une expression regulire (on reoit toujours une String en php si c'est une rsultat de BD)
                $une_chaine  = ereg("[^0-9]",$num_ou_lib) ;

                // Deux constructions diffrentes selon le type du paramtre ( refaire le jour o on pourra surcharger les fonctions !!!)
                if(!$une_chaine)
                {
                        $this->id = $num_ou_lib ;
                        // echo "Class Salle : constructeur avec identifiant<br>" ;
                        /*
                        $requete="SELECT * FROM titrecapacite WHERE num_titrecapacite=$num_ou_lib" ;
                        $result=pg_query($requete) ;
                        */
                        $result=get_titrecapacite($num_ou_lib);
                        $row=pg_fetch_row($result) ;
                        $this->libelle = $row[1] ;
                        //$this->num_theme = $row["theme"] ;
						$restheme=get_titrecapacite_themes(11,$num_ou_lib);
						$this->num_theme=pg_fetch_result($restheme,0,0);
                        // Construction du tableau sesCapacites
                        $this->sesCapacites = array() ;
                        /*
                        $sql="select tr_num_capacite from titrecapa where tr_num_titrecapacite=$this->id";
                        $res=pg_query($sql);
                        */
                        $res=get_titrecapacite_capacites($this->id);
                         while($row = pg_fetch_array($res)){
                            //$this->sesCapacites[] = new Capacite($row["tr_num_capacite"]) ;
                            $this->sesCapacites[] = new Capacite($row[0]) ;
                         }

                }
                // Construction  partir d'un nom
                else
                {
                       $this->libelle = $num_ou_lib ;
                       $this->num_theme = $theme;
                       $this->sesCapacites=array();
                }



        }
        // ------------------------------------------------------------------------------------------------------------------- fin Titrecapacite()

        /**
        * Fonction qui insre un enregistrement en table titrecapacite et qui retourne l'identifiant de la ligne cre
        * On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
        * @return integer : identifiant de l'enregistrement cre ou un code erreur ngatif
        */
        function insertToDB()
        {
                // On n'insre une ligne que si l'organisme n'existe pas dj
                if($this->libelle=="")
                {
                        return (-110) ; // libell vide
                }
                // Le libell est correcte
                else
                {
                        //$lib=addslashes($this->libelle) ;
                        $lib=$this->libelle ;
                        // Cet organisme existe-il dj ?
                        //if(pg_num_rows(pg_query("SELECT num_titrecapacite FROM titrecapacite WHERE libelle_titrecapacite='$lib'"))>0)
                        if(check_titrecapacite($lib,$this->num_theme))
                        {
                                return (-111);  // organisme existe dj
                        }
                        else
                        {
                                //$insertion = "INSERT INTO titrecapacite (libelle_titrecapacite,theme) VALUES ('$lib','".$this->num_theme."')" ;
                                $insertion=set_titrecapacite(set_ams_libelle($lib),$this->num_theme);

                                // On retourne un boolen
                                //if($res = pg_query($insertion))
                                if($insertion)
                                {
                                        /*
                                        $tmp = pg_result(pg_query("SELECT num_titrecapacite FROM titrecapacite WHERE libelle_titrecapacite='$lib'"),0,0) ;
                                        // on retourne l'identifiant de la ligne cre
                                        return($tmp);
                                        */
                                        return $insertion;
                                }
                                else
                                        return (-1) ; // Problme requte
                        }
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin insertToDB()

        /**
        * Fonction qui met  jour l'enregistrement en table titrecapacite
        *
        * Fonction qui met  jour l'enregistrement en table titrecapacite
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        *
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */

        function updateToDB()
        {
                // Il faut que l'identifiant soit connu
                if($this->id != 0)
                {
                        //$update = "UPDATE titrecapacite SET libelle_titrecapacite = '".addslashes($this->libelle)."' WHERE num_titrecapacite=$this->id" ;
                        //$lib=addslashes($this->libelle) ;
                        $lib=$this->libelle ;
                        $update=maj_titrecapacite($this->id,set_ams_libelle($lib));

                        // echo "Class Titrecapacite : updateToDB. Requete =<br>$update<br>" ;

                        // On retourne un boolen
                        //if(pg_query($update))
                        if($update)
                                return true ;
                        else
                                return -1 ; // erreur base de donnes
                }
                // Identifiant inconnu : mise  jour impossible
                else
                {
                        return -2 ;
                }
        }

        /**
        * Procdure qui supprime les association titrecapacite / capacite
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @return integer  On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */
        function removeToDB(){
            // Il faut que l'identifiant soit connu
            if($this->id != 0){
                // suppression des associations grille / titrecapacite
                if(remove_titrecapacite($this->id)){
                    $sesCapacites=array();
                    return true;
                }
                else
                    return -1;
            }
            else{
                // Identifiant inconnu : suppression impossible
                return -2;
            }
        }
         // ------------------------------------------------------------------------------------------------------------------- fin removeToDB()

        /**
        * Procdure qui supprime l'enregistrement en base
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */
        function deleteToDB(){
            // Il faut que l'identifiant soit connu
            if($this->id != 0){

                // suppression de la grille
                if(del_titrecapacite($this->id)){
                    $sesCapacites=array();
                    return true;
                }
                else
                    return -1;  // erreur base de donnes
            }
            else{
                // Identifiant inconnu : suppression impossible
                return -2;
            }
        }
         // ------------------------------------------------------------------------------------------------------------------- fin deleteToDB()


         /**
        * Fonction qui retourne une du titre de capacite
        * @param integer  indice de la capacite dans le tableau sesCapacites (de 0  nbExercices -1). Si on ne met rien, on retourne le tableau entier
        * Enfin, si l'indice est incohrent on retourne faux (pour utilisation dans une boucle while)
        * @return object Capacite  Capacite au rang $indice+1
        */
        function getCapacite($indice=0)
        {
                // Si $indice n'est pas valu alors on retourne le tableau entier
                if(func_num_args()==0)
                {
                        return $this->sesCapacites ;
                }
                // Sinon on analyse la valeur $indice
                else
                {
                        // Est-ce que $indice est cohrent ?
                        if($indice>=0 && $indice < count($this->sesCapacites) )
                                return ($this->sesCapacites[$indice]) ;
                        else
                                return false ;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin getCapacite($indice)

        /**
        * Donne le nombre de capacites d'un titre de capacite
        * Selon le paramtre pass, on donne le nombre d'exercice d'un type prcis. Pour avoir le nombre total d'exercices, on ne passe aucun
        * paramtre.

        * @return integer : Nombre de capacites du titre de capacite
        */
        function getNbCapacites()
        {
                return count($this->sesCapacites) ;
        }


        /**
        * Procdure qui ajoute une capacite au titre de capacite
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @param integer : numro du titrecapacite  ajouter

        */

        function ajoutElement($id_capacite)
        {
                // echo "Class Serie : ajoutExercice()<br>";
                if($this->id)
                {
                    /*
                    $insert = "INSERT INTO titrecapa(tr_num_titrecapacite,tr_num_capacite)
                                    VALUES ($this->id, $id_capacite)" ;
                    */
                    $insert=set_titrecapacite_capacite($this->id,$id_capacite);

                    //echo $insert ;
                    //pg_query($insert) ;

                    // Mise  jour du tableau
                    //$this->sesCapacites[] = new Capacite($id_Capacite) ;

                }
                else
                        echo "Erreur numro de srie inconnu<br>";
        }
        // ------------------------------------------------------------------------------------------------------------------- fin ajoutTitrecapacite($id_titrecapacite)

        /**
        * Procdure qui retire une de capacite du titre de capacite
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @param integer : n de la capacite
        */

        function retireElement($id_capacite)
        {
            if($this->id && $id_capacite){
                /*
                $sql="delete from titrecapa where tr_num_capacite=$id_capacite and tr_num_titrecapacite=$this->id";
                $del=pg_query($sql);
                */
                $del=del_titrecapacite_capacite($this->id,$id_capacite);

            }
            else
                        echo "Erreur paramtre retireCapacite()<br>";
        }
         // ------------------------------------------------------------------------------------------------------------------- fin retireTitrecapacite($id_titrecapacite)

        /**
        * Fonction qui retourne une chane de caractre contenant des informations sur l'objet
        *
        * Si on ne passe aucun paramtre, la chane retourne contient le nom. Par contre, si le paramtre est dfini,
        * il est utilis comme format de retour. Cet fonction peut servir d'accesseur sur les attributs de la classe.
        * @param string : le paramtre determine ce qu'on retourne. Les informations disponibles sont :
        * [id_test] (gal  [id_serie]) & [type_test]
        * @return string : On retourne la chane de caractres cre  partir du format
        */
        function toString($format="")
        {
                // Aucun paramtre, on retourne le titre de la srie
                if($format=="")
                        return $this->libelle ;

                // Ce tableau contient tous les pattern et les nouvelles valeurs
                $tab_replace = array("\[libelle\]"=>"$this->libelle","\[id\]"=>"$this->id","\[num_theme\]"=>"$this->num_theme") ;

                while($tab=each($tab_replace))
                        $format = ereg_replace($tab[0],$tab[1],$format) ;

                return $format ;
        }
        // ------------------------------------------------------------------------------------------------------------------- fin toString($format)

        /**
        *   Obtenir un tableau contenant les numeros et libelles des capacite affiliables

        *   @return integer[] : le tableau resultat(id,libelle)
        */
        function getElementsAffiliables(){
            /*
            $sql="select distinct num_capacite,libelle_capacite  from capacite where theme=$this->num_theme and num_capacite not in
                    (select tr_num_capacite from titrecapa where tr_num_titrecapacite=$this->id) order by libelle_capacite";

            $res=pg_query($sql);
            */
            $res=get_titrecapacite_capacites_disponibles($this->id,$this->num_theme);
            $tab=array();
            while($row=pg_fetch_array($res)){
                $tab[$row[0]]=$row[1];
            }
            return $tab;

        }


        function getId() { return $this->id ; }
        function getNumTheme() { return $this->num_theme ; }

}
?>