<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
  
       @package titre_capacite
       @modulegroup plpgsql
       @module plpgsql_titre_capacite
*/



/*-----------------------------------------------------------------------------------------*/
//                         LES FONCTIONS  D'ACCESS AUX FONCTIONS PLPGSQL
/*-----------------------------------------------------------------------------------------*/
/*
                            DOIVENT RETOURNER UNE VARIABLE
*/
/*
CONVENTION DE NOMAGE :
Il faut tablir une correspondance entre le nom de la fonction php et le nom de la fonction
PLPGSQL. Ainsi, on utilisera le meme nom pour les 2 fonctions, a ceci prs que le nom de
 la fonction PLPGSQL est precede de _af_ afin de la distinguer des fonctions systeme.
Exemple:

la fonction php function check_access($droit, $cal, $user) correspond  _af_check_access dans la base

*/

/**
*   Vrifier si un nom de titre de capacite est unique pour un mme thme  (OLD)
*
*   @param integer : numero du theme
*   @param string : nom du titre de capacite
*   @return integer : numero du titre de capacite si existe, 0 sinon
*/
function check_titrecapacite_old($libelle_titrecapacite,$theme){
    $sql="select * from titrecapacite where libelle_titrecapacite='$libelle_titrecapacite' and theme=$theme";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return 0;
    $row=pg_fetch_row($res,0);
    return $row[0];
}
/**
*   Vrifier si un nom de titre de capacite est unique pour un mme thme
*
*   @param integer : numero du theme
*   @param string : nom du titre de capacite
*   @return integer : numero du titre de capacite si existe, 0 sinon
*/
function check_titrecapacite($libelle_titrecapacite,$theme){
    if(VERSION_BASE>VERSION){
        //print("A IMPLEMENTER");
		// Pas tester pour le moment
		return false;
    }
    else
        return check_titrecapacite_old($libelle_titrecapacite,$theme);
}


/**
*   Supprimer un titre de capacite.  (OLD)
*
*   Supprime le titre de capacite

*
*   @param integer : numero du titre de capacite  supprimer
*   @return integer : 1
*/
function del_titrecapacite_old($titrecapacite){

    //suppression des associations titrecapacite / capacite
    remove_titrecapacite($titrecapacite);
    // suppression du titre de capacite
    $del=pg_query("delete from titrecapacite where num_titrecapacite=$titrecapacite;");

    return 1;
}

/**
*   Supprimer un titre de capacite.
*
*   Supprime le titre de capacite
*
*   @param integer : numero du titre de capacite  supprimer
*   @return integer : 1
*/
function del_titrecapacite($titrecapacite){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_capacite_titre($titrecapacite)";
		$res=pg_query($sql);
	}
    else
		$res=del_titrecapacite_old($titrecapacite);
	return ($res);
}

/**
*   Supprimer les associations titrecapacite / capacite.  (OLD)
*
*   Supprime les associations titrecapacite / capacite

*
*   @param integer : numero du titre de capacite
*   @return integer : 1
*/
function remove_titrecapacite_old($titrecapacite){

    //suppression
    $del=pg_query("delete from titrecapa where tr_num_titrecapacite=$titrecapacite;");

    return 1;
}

/**
*   Supprimer les association titrecapacite / capacite
*
*   Supprime les associations  titrecapacite / capacite
*
*   @param integer : numero titre de capacite
*   @return integer : 1
*/
function remove_titrecapacite($titrecapacite){

            if(VERSION_BASE>VERSION)
            {
                print("A IMPLEMENTER");
            }
            else
                $res=remove_titrecapacite_old($titrecapacite);

            return ($res);
}

/**
*   Vrifier si un couple titrecapacite / capacite est unique   (OLD)
*
*   @param integer : numero de capacite
*   @param string : nom de la grille
*   @return integer : 1 si existe, 0 sinon
*/
function check_titrecapa_old($titrecapacite,$capacite){
    $sql="select * from titrecapa where tr_num_titrecapacite=$titrecapacite and tr_num_capacite=$capacite";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return 0;
    $row=pg_fetch_row($res,0);
    return 1;
}
/**
*   Vrifier si un couple titrecapacite / capacite est unique
*
*   @param integer : numero de capacite
*   @param string : nom de la grille
*   @return integer : 1 si existe, 0 sinon
*/
function check_titrecapa($titrecapacite,$capacite){
    if(VERSION_BASE>VERSION){
        //print("A IMPLEMENTER");
    }
    else
        return check_titrecapa_old($titrecapacite,$capacite);
}

/**
    Verifie si un titrecapacite est utilis (OLD)
    @deprecated : utiliser check_titrecapacite_supprimable
    @param integer : le numero du titre de capacite
    @return bool : true si utlis , false sinon
*/
function check_titrecapacite_utilise_old($titrecapacite){
    $sql="select * from grilletitrecapa where gt_num_titrecapacite=$titrecapacite";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return false;
    else
        return true;
}
/**
    Verifie si un titrecapacite est utilis
    @deprecated : utiliser check_titrecapacite_supprimable
    @param integer : le numero du titre de capacite
    @return bool : true si utlis , false sinon
*/
function check_titrecapacite_utilise($titrecapacite){
    if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        return check_titrecapacite_utilise_old($titrecapacite);
}

/**
    Verifie si un titre de capacite est note (OLD)

    @param integer : le numero de titre de capacite
    @return bool : true si utlis , false sinon
*/
function check_titrecapacite_note_old($titrecapacite){
    $sql="select * from notation where num_titrecapacite=$titrecapacite";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return false;
    else
        return true;
}
/**
    Verifie si un titre de capacite est note

    @param integer : le numero de titre de capacite
    @return bool : true si utlis , false sinon
*/
function check_titrecapacite_note($titrecapacite){
    if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        return check_titrecapacite_note_old($titrecapacite);
}

/**
    Verifie si une capacite est notee pour un titre de capacite (OLD)
    @deprecated : utiliser check_titrecapacite_supprimable
    @param integer : le numero du titre de capacite
    @param integer : le numero de capacite
    @return bool : true si utlis , false sinon
*/
function check_titrecapacite_capacite_notee_old($titrecapacite,$capacite){
    $sql="select * from notation where num_capacite=$capacite and num_titrecapacite=$titrecapacite";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return false;
    else
        return true;
}
/**
    Verifie si une capacite est notee pour un titre de capacite
	@deprecated : utiliser check_titrecapacite_supprimable
    @param integer : le numero du titre de capacite
    @param integer : le numero de capacite
    @return bool : true si utlis , false sinon
*/
function check_titrecapacite_capacite_notee($titrecapacite,$capacite){
    if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        return check_titrecapacite_capacite_notee_old($titrecapacite,$capacite);
}

/**
	Otenir les capacite d'un titre de capacite (OLD)

	@param integer : le numero du titrecapacite
 	@return integer : le resultat de la requete
*/
function get_titrecapacite_capacites_old($titrecapacite){
	$sql="select num_capacite,libelle_capacite from capacite where num_capacite in
			(select tr_num_capacite from titrecapa where tr_num_titrecapacite=$titrecapacite)";
   return (pg_query($sql));
}
/**
	Otenir les capacite d'un titre de capacite
	@param integer : le numero du titrecapacite
 	@return integer : le resultat de la requete
*/
function get_titrecapacite_capacites($titrecapacite){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_capacite_titre_capacites($titrecapacite) as (id int4,libelle varchar,capacite_titre int4)";
		$res=pg_query($sql);
    }
    else
        return get_titrecapacite_capacites_old($titrecapacite);
	return $res;
 }

/**
	Obtenir les infos d'un titre de capacite

 	@param integer : le numero de titre de capacite
	@return integer : le resultat de la requete
*/
function get_titrecapacite_old($titrecapacite){
	$sql="select * from titrecapacite where num_titrecapacite=$titrecapacite";
 	return (pg_query($sql));
}
/**
	Obtenir les infos d'un titre de capacite

 	@param integer : le numero de titre de capacite
	@return integer : le resultat de la requete
*/
function get_titrecapacite($titrecapacite){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_capacite_titre($titrecapacite) as (id int4,libelle varchar)";
		$res=pg_query($sql);
    }
    else
        return get_titrecapacite_old($titrecapacite);
	return $res;
 }

/**
    Enregistre un titre de capacite (OLD)

    @param string : le nom du titre da capacite
    @param integer : le numero du theme
    @return integer : le numero du titre de capacite, 0 si erreur
*/
function set_titrecapacite_old($libelle,$theme){
    $sql="INSERT INTO titrecapacite (libelle_titrecapacite,theme) VALUES ('$libelle',$theme)" ;
    $ins=pg_query($sql);
    if($ins){
        $oid=pg_getlastoid($ins);
        $res=pg_query("select num_titrecapacite from titrecapacite where oid=$oid");
        return pg_result($res, 0, 0);
    }
    else
        return 0;
}
/**
    Enregistre un titre de capacite

    @param string : le nom du titre de capacite
    @param integer : le numero du theme
    @return integer : le numero du titre de capacite, 0 si erreur
*/
function set_titrecapacite($libelle,$theme){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_capacite_titre('$libelle')";
		$res=pg_query($sql);
		// enregistre dans theme_categories
		set_categorie_element_theme(11, $theme, pg_fetch_result($res, 0, 0));
		return pg_fetch_result($res, 0, 0);
    }
    else
        return set_titrecapacite_old($libelle,$theme);
 }

/**
    Mettre  jour un titre de  capacite (OLD)

    @param integer : le numero du titre de capacite
    @param string : le nom du titre de capacite
    @return integer : le resultat de la requete
*/
function maj_titrecapacite_old($titrecapacite,$libelle){
    $sql="UPDATE titrecapacite SET libelle_titrecapacite = '$libelle' WHERE num_titrecapacite=$titrecapacite" ;
    return pg_query($sql);
}
/**
    Mettre  jour un titre de  capacite

    @param integer : le numero du titre de  capacite
    @param string : le nom du titre de  capacite
    @return integer : le resultat de la requete
*/
function maj_titrecapacite($titrecapacite,$libelle){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_maj_capacite_titre($titrecapacite,'$libelle')";
		$res=pg_query($sql);
    }
    else
        return maj_titrecapacite_old($titrecapacite,$libelle);
	return $res;
}

/**
    Enregistre le couple titrecapacite / capacite (OLD)

    @param integer : le numero du titre de capacite
    @param integer : le numero de capacite
    @return integer : le resultat de la requete
*/
function set_titrecapacite_capacite_old($titrecapacite,$capacite){
    $sql="INSERT INTO titrecapa(tr_num_titrecapacite,tr_num_capacite) VALUES ($titrecapacite,$capacite)" ;
    return pg_query($sql);
}
/**
    Enregistre le couple titrecapacite / capacite

    @param integer : le numero du titre de capacite
    @param integer : le numero de capacite
    @return integer : le resultat de la requete
*/
function set_titrecapacite_capacite($titrecapacite,$capacite){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_capacite_titre_capacite($titrecapacite,$capacite)";
		$res=pg_query($sql);
    }
    else
        return set_titrecapacite_capacite_old($titrecapacite,$capacite);
	return $res;
}

/**
    Supprimer le couple titrecapacite / capacite (OLD)

    @param integer : le numero du titre de capacite
    @param integer : le numero de capacite
    @return integer : le resultat de la requete
*/
function del_titrecapacite_capacite_old($titrecapacite,$capacite){
    $sql="delete from titrecapa where tr_num_capacite=$capacite and tr_num_titrecapacite=$titrecapacite";
    return pg_query($sql);
}
/**
    Supprimer le couple titrecapacite / capacite

    @param integer : le numero du titre de capacite
    @param integer : le numero de capacite
    @return integer : le resultat de la requete
*/
function del_titrecapacite_capacite($titrecapacite,$capacite){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_capacite_titre_capacite($titrecapacite,$capacite)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else
        return del_titrecapacite_capacite_old($titrecapacite,$capacite);
	return $res;
}

/**
    Obtenir les capacites disponibles pour un titrecapacite et un theme (OLD)

    @param integer : le numero du titre de capacite
    @param integer : le numero du theme
    @return integer : le resultat de la requete
*/
function get_titrecapacite_capacites_disponibles_old($titrecapacite,$theme){
    $sql="select distinct num_capacite,libelle_capacite  from capacite where theme=$theme and num_capacite not in
                    (select tr_num_capacite from titrecapa where tr_num_titrecapacite=$titrecapacite) order by libelle_capacite";
    return pg_query($sql);
}
/**
    Obtenir les capacites disponibles pour un titrecapacite et un theme

    @param integer : le numero du titre de capacite
    @param integer : le numero du theme
    @return integer : le resultat de la requete
*/
function get_titrecapacite_capacites_disponibles($titrecapacite,$theme){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_capacite_titre_capacites_disponibles($titrecapacite,$theme) as 
				(id int4,libelle varchar,capacite_titre int4)";
		$res=pg_query($sql);
    }
    else
        return get_titrecapacite_capacites_disponibles_old($titrecapacite,$theme);
	return $res;
}

/**
	Teste si untitre de capacite est supprimable (OLD)
	@param integer : numero titre de capacite
	@return bool : true supprimable, false non supprimable
*/
function check_titrecapacite_supprimable_old($titrecapacite){
	$sql="select * from grilletitrecapa where gt_num_titrecapacite=$titrecapacite";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return false;
    else
        return true;
}
 /**
	Teste si untitre de capacite est supprimable
	@param integer : numero titre de capacite
	@return bool : true supprimable, false non supprimable
*/
function check_titrecapacite_supprimable($titrecapacite){
	if(VERSION_BASE>VERSION){
		 $res=!fk_finder('capacite_titre','id',$titrecapacite);
	}
	else
		$res=check_titrecapacite_supprimable_old($titrecapacite);
	return $res;
}

/**
	Obtenir les themes d'untitre de  capacite   (OLD)
	@param integer : numero categorie
	@param integer : numero titre capacite
	@return resultat requete
*/
function get_titrecapacite_themes_old($titrecapacite){
	 $sql="select distinct num_themedir,nom_theme from themedir where num_themedir in 
				(select theme from titrecapacite where num_titrecapacite=$titrecapacite)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Obtenir les themes d'un titre capacite   
	@param integer : numero categorie
	@param integer : numero titrecapacite
	@return resultat requete
*/
function get_titrecapacite_themes($categorie,$titrecapacite){
	if(VERSION_BASE>VERSION){
		$res=get_categorie_element_themes($categorie,$titrecapacite);
	}
	else
		return get_capacite_themes_old($titrecapacite);
	return $res;
}

/**
    Verifie si une capacite est supprimable pour un titre de capacite (OLD)
    @param integer : le numero du titre de capacite
    @param integer : le numero de capacite
    @return bool : true si supprimable , false sinon
*/
function check_titrecapacite_capacite_supprimable_old($titrecapacite,$capacite){
    $sql="select * from notation where num_capacite=$capacite and num_titrecapacite=$titrecapacite";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return true;
    else
        return false;
}
/**
    Verifie si une capacite est supprimable pour un titre de capacite
    @param integer : le numero du titre de capacite
    @param integer : le numero de capacite
    @return bool : true si utlis , false sinon
*/
function check_titrecapacite_capacite_supprimable($titrecapacite,$capacite){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_is_capacite_titre_capacite_supprimable($titrecapacite,$capacite)";
		$res=pg_query($sql);
    }
    else
        return check_titrecapacite_capacite_supprimable_old($titrecapacite,$capacite);
	return $res;
}
 ?>