<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

class guiScenarioDynamiqueBloc extends PageComponent{
	function guiScenarioDynamiqueBloc($block_target,$obj_fichier_scenario_dynamique_bloc,$module_root=null,$templates=null){
		global $root;
		parent::PageComponent($module_root,$templates);
		
		$output_bloc_vars=$this->get_undefined($block_target);
		
		
		foreach($output_bloc_vars as $bloc_var){
			$bloc_var_indice_tmp=preg_split('/_(\d)$/', $bloc_var,-1, PREG_SPLIT_DELIM_CAPTURE);
			$bloc_var_indice=$bloc_var_indice_tmp[1];
			if(!empty($bloc_var_indice)){
				$suffixe="_$bloc_var_indice";
			}else{
				$suffixe=null;
			}
			
			$bloc_var_base_tmp=preg_split("/_\d/", $bloc_var,-1, PREG_SPLIT_NO_EMPTY);
			$bloc_var_base=$bloc_var_base_tmp[0];
			switch($bloc_var_base){
				case 'IMG_SRC':
					$tmp_fich=$obj_fichier_scenario_dynamique_bloc->getVar($bloc_var);
					$tmp_theme=$obj_fichier_scenario_dynamique_bloc->getVar('id_theme_img_src'.$suffixe);
					
					if(empty($tmp_fich)||empty($tmp_theme)){
						AstairsTemplate::setPageMessage("Erreur format composant: Le composant est corrompu.".$obj_fichier_scenario_dynamique_bloc->getLibelle(),MSG_ERROR);
					}
					else{
						$res_fic=get_fichier($tmp_fich);
						$theme=$tmp_theme;
						
						$chemin=get_fichier_chemin($obj_fichier_scenario_dynamique_bloc->getVar($bloc_var), $theme, TYPE_CATEGORIE_MEDIA_SCENARIO,$res_fic);
					}
					$var_value=$chemin;
					
					break;
				case 'FLASH_SRC':
					$tmp_fich=$obj_fichier_scenario_dynamique_bloc->getVar($bloc_var);
					$tmp_theme=$obj_fichier_scenario_dynamique_bloc->getVar('id_theme_flash_src'.$suffixe);
					
					if(empty($tmp_fich)||empty($tmp_theme)){
						AstairsTemplate::setPageMessage("Erreur format composant: Le composant est corrompu.".$obj_fichier_scenario_dynamique_bloc->getLibelle(),MSG_ERROR);
					}
					else{
						$res_fic=get_fichier($tmp_fich);
						$theme=$tmp_theme;
					
						$chemin=get_fichier_chemin($obj_fichier_scenario_dynamique_bloc->getVar($bloc_var), $theme, TYPE_CATEGORIE_MEDIA_SCENARIO,$res_fic);
					}

//					$res_fic=get_fichier($obj_fichier_scenario_dynamique_bloc->getVar($bloc_var));
//					$theme=$obj_fichier_scenario_dynamique_bloc->getVar('id_theme_flash_src'.$suffixe);
//					$chemin=get_fichier_chemin($obj_fichier_scenario_dynamique_bloc->getVar($bloc_var), $theme, TYPE_CATEGORIE_MEDIA_SCENARIO,$res_fic);
					
					$var_value=$chemin;
					break;
				default:
				//print_rr($bloc_var);
					$var_value=$obj_fichier_scenario_dynamique_bloc->getVar($bloc_var);
					// gestion ams
					//echo "var_value=$var_value (ici)<br>";
					//$tmp_var_value=get_ams_libelles($var_value);
//					$var_value=get_bo_fo_libelle($var_value);
//					echo "<b>ici : var_value=</b>$var_value (ici)<br>";
					
					break;	
			}
			
			$this->set_var($bloc_var,$var_value);
		}
	}
}
?>