<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

class guiScenarioDynamiqueSlides extends PageComponent{
	
	var $obj_fichier_scenario;
	
	function guiScenarioDynamiqueSlides($block_target,$obj_fichier_scenario,$module_root=null,$templates=null,$theme=0){
		
		parent::PageComponent($module_root,$templates);
		
		$this->obj_fichier_scenario=$obj_fichier_scenario;
		
		$this->set_var('RT_RAPIDE',MSG_2684);
		$this->set_var('PAUSE',MSG_2686);
		$this->set_var('AV_RAPIDE',MSG_2685);
		
		$this->set_var('SCENARIO_CSS_URL',$obj_fichier_scenario->getStylePath());
		
		$this->set_var('CURRENT_SLIDE',$obj_fichier_scenario->getCurrentBloc());
//print_rr($obj_fichier_scenario);
		$this->initTitle($module_root,$templates);
		$this->initMenu($module_root,$templates);
		$this->initContent($module_root,$templates);
		
	}
	
	function initTitle($module_root,$templates){
		global $root;
		$component=new guiScenarioDynamiqueSlideTitle('slide_model_title',$this->obj_fichier_scenario,"$root/lib_graphique/gui_scenario_dynamique/templates/tpl/",array('slide_model_title' => 'gui_scenario_dynamique_slide_title.tpl'));
		$this->setComponent('slide_model_title', $component);
	}
	
	function initMenu($module_root,$templates){
		die("guiScenarioDynamiqueSlides::initMenu(): methode abstraite devant etre surchargee.");
	}
	
	function initContent($module_root,$templates){
		global $root;
		$component=new guiScenarioDynamiqueSlideContent('slide_model_content',$this->obj_fichier_scenario,"$root/lib_graphique/gui_scenario_dynamique/templates/tpl/",array('slide_model_content' => 'gui_scenario_dynamique_slide_content.tpl'));
		$this->setComponent('slide_model_content', $component);
	}
	
	function getFichierScenarioDynamique(){
		return $this->obj_fichier_scenario;
	}
}
?>