<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Arbre javascript  3 niveau de selection maximum.
	Cet arbre javascript gnrique permet, par une selection de 
	diffrentes ressources, d'afficher une page necessitant des
	informations des ressources selectionne.
	
	necessite:
	$lien_cible : 				page qui doit etre charge  la selection du dernier niveau
										NOTE: le liens contenir un premier parametre (de type: script.php?1erparam=val1erparam)
	$fonction_un:				fonction sql a appeller pour obtenir le premier niveau (pas de parametre)
	$fonction_deux:			fonction sql a appeller pour obtenir le deuxieme niveau (voir plus bas pour les indications concernant les parametres)
	$fonction_trois:			fonction sql a appeller pour obtenir le troisieme niveau (voir plus bas pour les indications concernant les parametres)
	
	envoie les variables : 
		$param1
		$param2
		$param3
	correspondant chacunes aux valeurs selectionnes pour chacun des niveaux de selection
	<li>
	Indication pour les fonctions sql:
	
	Les fonctions  utiliser pour ce script doivent imprativement contenir
	un identifiant dans la premiere colonne de resultat et un libll dans la seconde.
	En effet l'identifiant sera utilis pour la valeur des noeuds de l'arbre,
	et le libell pour afficher le texte du noeud.
	</li>	
	
	<li>
	Indications pour les parametres:
	
	Chacun des niveaux de selections sont construits en fonction des donnes
	de la section du niveau suprieur. Ainsi:
	
		<li>
		$fonction_un ne doit pas avoir de parmatres ou des parametres qui seront
		constants sur la totalit de l'arbre
		</li>
		
		<li>
		$fonction_deux doit avoir en parametre, en plus de ceux constants
		sur la totalit de l'arbre, un parametre dont la valeur est celle du niveau
		suprieur. Ce parametre doit etre spcifi grace  la variable:
		
					<li>
					$niveau_un[$i][X] ou X est l'indice de la colonne de resultat de niveau 
					suprieur  utiliser
					</li>
		</li>
		
		<li>
		$fonction_trois doit avoir en parametre, en plus de ceux constants
		sur la totalit de l'arbre, un parametre dont la valeur est celle du niveau
		suprieur. Ce parametre doit etre spcifi grace  la variable:
		
					<li>
					$niveau_deux[$i][$w][X] ou X est l'indice de la colonne de resultat de niveau 
					suprieur  utiliser
					</li>
		</li>
		</li>
*/
//----------------------------------------------------------------------------------------------
//	DEBUG
//----------------------------------------------------------------------------------------------
$NIVEAU_DEBUG =0;
httpPostVariables();
messageDebug("fonction_un=$fonction_un");
messageDebug("fonction_deux=$fonction_deux");
messageDebug("fonction_trois=$fonction_trois");
//----------------------------------------------------------------------------------------------
//	DEBUT DU SCRIPT (HTML + JAVASCRIPT)
//----------------------------------------------------------------------------------------------
print ("
<HTML>
<HEAD>
<TITLE>$titre</TITLE>

<script type=\"text/javascript\">


var relocateURL = \"/\";

if(parent.frames.length == 0) {
  if(document.images) {
    location.replace(relocateURL);
  } else {
    location = relocateURL;
  }
}
</script>

<script type=\"text/javascript\" src=\"../menu_javascript/mtmcode.js\">
</script>

<script type=\"text/javascript\">

// Default target
MTMDefaultTarget = \"main\";

// Name of the frame where the menu is to appear.
MTMenuFrame = \"menu\";
MTMCodeFrame = \"code\"; // must correspond with value in mtmtrack.js

// variable for determining whether a sub-menu always gets a plus-sign
// regardless of whether it holds another sub-menu or not
MTMSubsGetPlus = \"never\";

// Variables for controlling colors in the menu document.
// Regular BODY atttributes as in HTML documents.
MTMBGColor = \"#FFFFFF\";
MTMBackground = \"#FFFFFF\";
MTMTextColor = \"black\";

// color for all menu items
MTMLinkColor = \"orange\";

// Hover color, when the mouse is over a menu link
MTMAhoverColor = \"blue\";

// Foreground color for the tracking & clicked submenu item
MTMTrackColor =\"black\";
MTMSubExpandColor = \"black\";
MTMSubClosedColor = \"black\";

// All options regarding the root text and it's icon
MTMRootColor = \"blue\";

// Additional style sheet properties if you're not using a linked style sheet.
// See the documentation for details on IDs, classes & elements used in the menu.
// Line can simply be removed if you haven't got any additional properties.
MTMExtraCSS.addRule('body','margin: 0px; padding: 0px;');

// Options for controlling the menu document
MTMcontentType = \"text/html; charset=ISO-8859-1\";

/******************************************************************************
* Configuration / lists icons                                                 *
******************************************************************************/
var MTMIconList = null;
MTMIconList = new IconList();
MTMIconList.addIcon(new MTMIcon(\"menu_link_external.gif\", \"http://\", \"pre\"));
MTMIconList.addIcon(new MTMIcon(\"menu_link_pdf.gif\", \".pdf\", \"post\"));

/******************************************************************************
* Configuration du menu                                                       *
******************************************************************************/

//Menu principal
var menu = null;
menu = new MTMenu();
");

//----------------------------------------------------------------------------------------------
//	CONSTRUCTION DE L'ARBRE
//----------------------------------------------------------------------------------------------

//recupere les donnees du premier niveau
eval("\$result_niveau_un=$fonction_un ;");
if (!$result_niveau_un) {
	print ("Erreur lors de la recuperation des donnees de premier niveau de l'arbre.<BR>");
	exit();
}

//recupere le nombre d'enregistrement du premier niveau                                   
$cnt_niveau_un = pg_NumRows($result_niveau_un);
//stock les donnees du premier niveau sous forme de tableau
$niveau_un = pg_super_fetch_array($result_niveau_un);


	
if ($cnt_niveau_un != 0) {
	$cpt_niveau_deux = 0;
	$cpt_niveau_trois = 0;

	//BOUCLE SUR LE PREMIER NIVEAU
	for ($i = 0; $i < $cnt_niveau_un; $i ++) {
		
//code 1
//////////////
		//formatage du libelle
		$niveau_un[$i][1] = htmlentities($niveau_un[$i][1]);

		//cree l'item javascript 
		print ("menu.addItem(\"".$niveau_un[$i][1]."\",\"./$lien_cible&param1=".$niveau_un[$i][0]."&param2=&param3=\");\n");

		//recupere les donnees du deuxieme niveau
		eval("\$result_niveau_deux=$fonction_deux ;");
		if (!$result_niveau_deux) {
			print ("Erreur lors de la recuperation des donnees de deuxieme niveau de l'arbre.<BR>");
			exit();
		}

		//recupere le nombre d'enregistrement du deuxieme niveau   
		$cnt_niveau_deux[$i] = pg_NumRows($result_niveau_deux);

		//stock les donnees du deuxieme niveau sous forme de tableau
		$niveau_deux[$i] = pg_super_fetch_array($result_niveau_deux);
		if ($cnt_niveau_deux[$i] > 0) {
			//cree l'item javascript 
			print ("var n_deux".$cpt_niveau_deux." = null;\n");
			print ("n_deux".$cpt_niveau_deux." = new MTMenu();\n".$cnt_niveau_deux[$i]."\n");

//code 1 FIN
//////////////
			//BOUCLE SUR LE NIVEAU DEUX
			for ($w = 0; $w < $cnt_niveau_deux[$i]; $w ++) {

//code 2
//////////////
				//recupere les donnees du troisieme niveau
				eval("\$result_niveau_trois[\$i][\$w]=$fonction_trois ;");

				//recupere le nombre d'enregistrement du troisieme niveau   
				$cnt_niveau_trois[$i][$w] = pg_NumRows($result_niveau_trois[$i][$w]);

				//stock les donnees du troisieme niveau sous forme de tableau
				$niveau_trois[$i][$w] = pg_super_fetch_array($result_niveau_trois[$i][$w]);

				if ($cnt_niveau_deux[$i] > 0) {

					//formatage du libelle
					$niveau_deux[$i][$w][1] = htmlentities($niveau_deux[$i][$w][1]);

					//cree l'item javascript 
					print "var n_trois$cpt_niveau_trois = null;\n";
					print "n_trois$cpt_niveau_trois = new MTMenu();\n";
					print "n_deux".$cpt_niveau_deux.".addItem(\"".$niveau_deux[$i][$w][1]."\",\"./$lien_cible&param1=".$niveau_un[$i][0]."&param2=&param3=".$niveau_deux[$i][$w][0]."\");\n";

					if ($cnt_niveau_trois[$i][$w] > 0) {

//code 2 FIN
//////////////
						//BOUCLE SUR LE NIVEAU TROIS
						
						for ($z = 0; $z < $cnt_niveau_trois[$i][$w]; $z ++) {
//code 3
//////////////							
							//formatage du libelle
							$niveau_trois[$i][$w][$z][1] = htmlentities($niveau_trois[$i][$w][$z][1]);
							//cree l'item javascript 
							print "n_trois$cpt_niveau_trois.addItem(\"".$niveau_trois[$i][$w][$z][1]."\",\"./$lien_cible&param1=".$niveau_un[$i][0]."&param2=".$niveau_trois[$i][$w][$z][0]."&param3=".$niveau_deux[$i][$w][0]."\");\n";
							print "\n\n";
						}
						print "n_deux".$cpt_niveau_deux.".makeLastSubmenu(n_trois$cpt_niveau_trois);\n";
						$cpt_niveau_trois ++;
//code 3 fin
//////////////
					}
				}
			}
			print "menu.makeLastSubmenu(n_deux$cpt_niveau_deux);\n";
		}
		$cpt_niveau_deux ++;
	}
}

//----------------------------------------------------------------------------------------------
//	FIN DU SCRIPT (HTML + JAVASCRIPT)
//----------------------------------------------------------------------------------------------
print ("
	</script>
</head>
<BODY onload=\"MTMStartMenu(true)\" BGCOLOR=FFFFFF  TEXT=000000 LINK=0000FF VLINK=002498 topmargin=0 leftmargin=0 marginwidth=0 marginheight=0>
");
require ('../piedpage.php3');
?>