<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affiche le source javascript n�cessaire � la contruction d'un 
 * arbre pour l'affichage des fili�res de la plate-forme.
 * 
 * @package filiere
 */

//------------------------------------------------------
//		LIBRAIRIES
//-----------------------------------------------------
$dbpath="../../../..";
require("$dbpath/dbpostgres.php");
require("$dbpath/en_tete.php");
$no_path_verify=true;
require("$root/bo/en_tete_back.php");

require("includes.php");
//$db=connecteDB();
//------------------------------------------------------
//		FONCTIONS PHP
//-----------------------------------------------------

/**
 * Affiche le javascipt n�cessaire � l'affichage des fili�res sous forme d'arbre dans une frame.
 * 
 * @param integer : numero du p�re dont on veut faire l'arborescence ('NULL' pour la totalit�).
 * @param integer : numero du p�re du p�re dont on fait l'arborescence.
 */
function arbo($parent, $pere){
		global $db;
        global $serverback;
        global $cptFiliere;
        global $page;
        global $module;
        
         $cptFiliere++;
         print "var cours$cptFiliere = null;\n";
         print "cours$cptFiliere = new MTMenu();\n";

        $res=get_filiere_sous_filieres($parent);
     
        while($row=pg_fetch_row($res)){
				//print_rr($row);
                $num=$row[0];
                $nom=$row[1];
                //echo "nom=$nom<br>";
                if(is_ams_libelle($nom)){
                	//echo "nom=$nom<br>";
                	$tmp_nom=get_ams_libelles($nom);
                	//echo "tmp_nom=$tmp_nom<br>";
                	$nom=get_ams_libelle($tmp_nom,50);
                	//echo "nom=$nom<br>";
                }
                //echo "nom=$nom<br>";

                $rang=get_filiere_niveau($num);


                if($rang==1)
                        print("menu.addItem(\"$nom\",\"http://$serverback/bo/$module/$page?gestcours=$num&niv=$rang\");\n");

                else{
                        print "cours$cptFiliere.addItem(\"$nom\",\"http://$serverback/bo/$module/$page?gestcours=$num&niv=$rang\");\n";

                        if($rang==2){
                                print "menu.makeLastSubmenu(cours$cptFiliere);\n";
                        }
                        else{
                                print "cours$pere.makeLastSubmenu(cours$cptFiliere);\n";
                        }
                 }
                $svgcptFiliere=$cptFiliere;
                arbo($num, $cptFiliere);
                $cptFiliere=$svgcptFiliere;
        }
        
}

//------------------------------------------------------
//		AFFICHAGE
//-----------------------------------------------------
print ("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">               
<HTML>
<HEAD>
<TITLE>$nompage</TITLE>
<META HTTP-EQUIV=\"CONTENT-TYPE\" CONTENT=\"TEXT/HTML; CHARSET=".CHARSET."\">
<script type=\"text/javascript\">
var relocateURL = \"/\";

if(parent.frames.length == 0) {
  if(document.images) {
    location.replace(relocateURL);
  } else {
    location = relocateURL;
  }
}
</script>

<script type=\"text/javascript\" src=\"http://$serverback/lib_graphique/objets/filiere/arbre_javascript/mtmcode.js\">
</script>

<script type=\"text/javascript\">

// Default target
MTMDefaultTarget = \"main\";

// Name of the frame where the menu is to appear.
MTMenuFrame = \"menu\";
MTMCodeFrame = \"code\"; // must correspond with value in mtmtrack.js

// variable for determining whether a sub-menu always gets a plus-sign
// regardless of whether it holds another sub-menu or not
MTMSubsGetPlus = \"never\";

// Variables for controlling colors in the menu document.
// Regular BODY atttributes as in HTML documents.
MTMBGColor = \"#FFFFFF\";
MTMBackground = \"#FFFFFF\";
MTMTextColor = \"black\";

// color for all menu items
// MTMLinkColor = \"#FFCC00\";
MTMLinkColor = \"#FDA408\";

// Hover color, when the mouse is over a menu link
MTMAhoverColor = \"blue\";

// Foreground color for the tracking & clicked submenu item
MTMTrackColor =\"black\";
MTMSubExpandColor = \"black\";
MTMSubClosedColor = \"black\";

// All options regarding the root text and it's icon
MTMRootColor = \"blue\";

// Additional style sheet properties if you're not using a linked style sheet.
// See the documentation for details on IDs, classes & elements used in the menu.
// Line can simply be removed if you haven't got any additional properties.
MTMExtraCSS.addRule('body','margin: 0px; padding: 0px;');

// Options for controlling the menu document
MTMcontentType = \"text/html; charset=".CHARSET."\";

/******************************************************************************
* Configuration / lists icons                                                 *
******************************************************************************/
var MTMIconList = null;
MTMIconList = new IconList();
MTMIconList.addIcon(new MTMIcon(\"menu_link_external.gif\", \"http://\", \"pre\"));
MTMIconList.addIcon(new MTMIcon(\"menu_link_pdf.gif\", \".pdf\", \"post\"));

/******************************************************************************
* Configuration du menu                                                       *
******************************************************************************/

//Menu principal
var menu = null;
menu = new MTMenu();

");

//initialisation du compteur global
$cptFiliere=1;

//appel de la fonction de creation de l'arborescence.
arbo('NULL','NULL');


print ("
</script>
</head>
<BODY onload=\"MTMStartMenu(true)\" BGCOLOR=FFFFFF  TEXT=000000 LINK=0000FF VLINK=002498 topmargin=0 leftmargin=0 marginwidth=0 marginheight=0>

");
include("$dbpath/pied_page.php");
?>