<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Classe qui construit l'affichage des icones, des liens et des titres des diffrentes langues.
 * Les langues affiches sont celles de la formation si celle-ci est affecte dans $_SESSION["obj_DoFormation"],
 * les langues disponibles en base de donnes si il y a une connection  la base,
 * et les langues presntes dans le repertoire public_html/ressources/langues/ si non.
 * @package langues
 */
class PlateformeLangues extends PageComponent{
	/**
	 * Constructeur
	 * 
	 * @param string $block_target Le nom de la variable qui contiendra la boucle dans le tpl.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
	function PlateformeLangues($block_target,$module_root=null,$templates=null,$obj_DoEtape=null){
		global $obj_DoFormation,$sess,$s_langue,$dbpath,$serverfront,$plateforme,$nom_site_back,$repertoire,$PHP_SELF,$MSG_1594,$MSG_1595,$MSG_1596,$MSG_1597,$MSG_1598,$MSG_2175,$MSG_2176;
		parent::PageComponent($module_root,$templates);
		parent::set_block($block_target,'plateforme_langues','bloc_langues');
		parent::set_var('bloc_langues',"");		
//		echo "\$PHP_SELF=$PHP_SELF";
		if(is_object($obj_DoFormation))$formation = $obj_DoFormation->getFormation();
		if($formation){
			$tablangue=get_formation_langues_disponibles($formation);
		}else{
			if(!$db){
				$tablangue=get_langues_installees();	
			}else{
				$tablangue=get_langues_disponibles();
			}
		}
		
		$original=$sess->self_url();
		$original_url_full=parse_url($original);
		$original_url=$original_url_full['path'];
		$original_query=$original_url_full['query'];
		while (list ($key, $currentLang) = each($tablangue)) {
			if ($s_langue != $currentLang[0]) {
				eval('$libelle_langue='.$currentLang[1].';');
//				if(is_object($obj_DoEtape))$lien_etape="&sz_obj_doetape=".exportObject($obj_DoEtape,'CURRENT_DO_ETAPE');
//				else $lien_etape=null;
				// debug
				//echo "lien_etape=$lien_etape<br>";
				//print_rr($obj_DoCorrection);
//				echo $sess->self_url();
				if(substr_count($original_query,'ChLangue=')>=1){
					$new=ereg_replace('ChLangue=[[:digit:]]','ChLangue='.$currentLang[0],$original_query);
				}else{
					$new=$original_query."&".'ChLangue='.$currentLang[0];
				}
//				echo "\$new=$new";
				$url=$original_url."?".$new;
//				echo "\$url=$url";
//				$url=$sess->add_query(array('ChLangue'=>$currentLang[0]),$sess->self_url());
				//"$PHP_SELF?ChLangue=". $currentLang[0].$lien_etape
				$component=new PlateformeLangue($url,"http://$serverfront/langues/" . $currentLang[0] . "/flag.gif",$currentLang[1],$module_root,array('plateforme_langue' => 'plateforme_langue.tpl'));
				$this->setComponent('plateforme_langue', $component,true,'plateforme_langues','bloc_langues');
			}
		}
	}
	
	function submit($get){
		global $sess,$auth,$s_langue;
		if($get['ChLangue']){
//			echo "change langue ".$get['ChLangue'];			
						maj_individu_langue($auth->getUserId(), $get['ChLangue']);
		}
		global $formation;
		$s_langue=get_page_langue($auth->getUserId(),$formation);

	
		global $page_lang_country_code,$page_lang;
		$page_lang_country_code=pg_fetch_result(get_langue(int2Sql($s_langue)),0,3);
		$page_lang=get_country_code_primary($page_lang_country_code);
	}
}
?>
