<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/*
 * Created on Apr 23, 2008
 *
 * To change the template for this generated filaddslashese go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
class guiAmsLibelle extends PageComponent{
	function guiAmsLibelle($libelle,$module_root='../lib_graphique/objets/langue/templates/tpl',$templates=array('component_ams_libelle'=>'gui_ams_libelle.tpl'),$interpretationHTML=false){
		global $ams_langue,$s_langue;
		parent::PageComponent($module_root,$templates);

		//valeur de retour permettant d'indiquer si l'on a ou pas un ams
		$is_ams_libelle=true;
		$ams_libelles=get_ams_libelles($libelle);
		
		if(is_array($ams_libelles)){

			$ams_langue_trouve=false;
			$vars['AMS_BULLE']='<span class=&quot;gui_ams_bulle&quot;>'.js(MSG_2635).': <ul>';
			foreach($ams_libelles as $indice => $ams_libelle){
				$langue=get_langue($ams_libelle[0]);
				$row_langue=pg_fetch_row($langue);

				if($ams_libelle[0]==$ams_langue){
					
					if($interpretationHTML){
						$vars['AMS_LIBELLE']=$ams_libelle[1];
					}
					else{
						$vars['AMS_LIBELLE']=htmlentities($ams_libelle[1],ENT_QUOTES,CHARSET);
					}
					$vars['AMS_LANGUE']=get_country_code_primary($row_langue[3]);
					$ams_langue_trouve=true;
				}else{
					if($row_langue[3])$vars['AMS_BULLE'].='<li><strong>'.get_country_code_primary($row_langue[3]).':</strong> '.htmlentities(addslashes($ams_libelle[1]),ENT_QUOTES,CHARSET).'</li>';
				}
			}
			$vars['AMS_BULLE'].='</ul></span>';
			if(!$ams_langue_trouve){
				$langue=get_langue($ams_langue);
				$row_langue=pg_fetch_row($langue);
				$vars['AMS_LIBELLE']='-'.js(MSG_2636).'-';
				$vars['AMS_LANGUE']=get_country_code_primary($row_langue[3]);
			}elseif($indice==0){
				$vars['AMS_BULLE']=js(MSG_2637);
			}
		}elseif(!empty($ams_libelles)){
			$vars['AMS_LIBELLE']=$ams_libelles;
			$vars['AMS_BULLE']=js(MSG_2638);	
			$is_ams_libelle=false;
		}else{
			$vars['AMS_LIBELLE']='-'.js(MSG_2636).'-';
			$vars['AMS_LANGUE']='(x)';
			$this->set_var($vars);
			return false;
		}
		$this->set_var($vars);
		return $is_ams_libelle;
	}
}
/**
 * Format text String to Javascript text String.
 * Replace scpecial chars from langue message
 * @param $string
 * @return unknown_type
 */
function js($string){
	return str_replace('d&#39;',"\'",$string);
}
?>