<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Objet de gestion d'association de données.
 * Cet objet contient 2 SelectList, l'un contenant les éléments d'une association (IN), l'autre contenant tous les éléments que l'on peut ajouter à l'association (OUT), y compris ceux déjà présents.
 * Les éléments du IN sont automatiquement soustraits des éléments du OUT, afin de simplifier la selection des données.
 * Il dispose de méthodes permettant l'ajout de données à l'association et la suppression de données de cette association.   
 */
class SelectListAddRemove{
	
	var $in;
	var $out;
	
	
	/**
	 * Constructeur.
	 * @param string $block_target Bloc cible dans lequel on veut afficher ce PageComponent
	 * @param object SelectListAddRemove $selectListAddRemove Les sous Modules du Module
	 * @param string $module_root Chemin racine des fichiers de templates (TPL)
	 * @param string $templates Les fichiers de Templates
	 */
	function SelectListAddRemove($in,$out){
		$this->in=$in;
		$this->out=$out;
	}
	
	/**
	 * Obtenir l'objet de gestion des données IN.
	 * @param object SelectListIn l'objet de gestion des données IN
	 */
	function getIn(){
		return $this->in;
	} 

	/**
	 * Obtenir l'objet de gestion des données OUT.
	 * @param object SelectListOut l'objet de gestion des données OUT
	 */	
	function getOut(){
		return $this->out;
	}
	
	/**
	 * Ajouter les éléments séléctionnés dans OUT dans le IN.
	 * @param integer[] $elements Identifiants des données à ajouter à l'association.
	 * @return bool true si effectu, false si echec.
	 */
	function add($elements){
		return $this->in->setElements($elements);
	}

	/**
	 * Retirer les éléments séléctionnés dans IN.
	 * @param integer[] $elements Identifiants des données à supprimer de l'association.
	 * @return bool true si effectu, false si echec.
	 */
	function remove($elements){
		return $this->in->delElements($elements);
	}
	
}

/**
 * Objet de gestion des données pour une liste de selection HTML avec ajout et suppression de la liste. 
 * Cette classe complete la classe  SelectList avec des fonctions d'ajout et de suppression.
 * Elle correspond à la liste contenant les données associées (IN).
 */
class SelectListIn extends SelectList{
	
	var $function_set;
	var $function_del;
	
	/**
	 * Constructeur.
	 * 
	 * Les fonctions de suppression et d'ajout de données doivent avoir un parametre dont la valeur est ##elements## correspondant au paremetre
	 * devant contenir les identifiants des données à ajouter et à supprimer.
	 * 
	 * @param string $function_get Fonction de remplissage des données
	 * @param string $title Titre de la liste de séléction
	 * @param string $selectName Nom de l'objet HTML (name)
	 * @param string $selectIsDisabled Désactivation du select
	 * @param string $function_set Fonction d'ajout de données
	 * @param string $function_del Fonction de suppression de données
	 */
	function SelectListIn($function_get, $title,$selectName,$selectIsDisabled,$function_set, $function_del,$selectOnClick=""){
		parent::SelectList($function_get, $title,$selectName,$selectIsDisabled,$selectOnClick);
		$this->function_set=$function_set;
		$this->function_del=$function_del;
	}
	
	/**
	 * Ajouter des éléments 
	 * @param integer[] $elements Identifiants des données à ajouter à l'association.
	 * @return bool true si effectu, false si echec.
	 */
	function setElements($elements){
		$tmp=$this->function_set;
		$tmp=str_replace("##element##",int_array_to_php_array($elements),$tmp);
//		echo "$tmp";
		$res_query_set=eval('return '.$tmp.';');
		return $res_query_set;
	}
	
	/**
	 * Retirer des éléments.
	 * @param integer[] $elements Identifiants des données à supprimer de l'association.
	 * @return bool true si effectu, false si echec.
	 */
	function delElements($elements){
		$tmp=$this->function_del;
		$tmp=str_replace("##element##",int_array_to_php_array($elements),$tmp);
		$res_query_del=eval('return '.$tmp.';');
		return $res_query_del;
	}
		
}

/**
 * Objet de gestion des données pour une liste de selection HTML avec ajout et suppression de la liste. 
 * Cette classe complete la classe SelectList avec un objet SelectList contenant les données à retirer de l'objet SelectListOut.
 * Elle correspond à la liste contenant les données non associées (OUT).
 */
class SelectListOut extends SelectList{
	
	var $selectListIn;
	
	/**
	 * Constructeur.
	 * 
	 * @param string $function_get Fonction de remplissage des données
	 * @param string $title Titre de la liste de séléction
	 * @param string $selectName Nom de l'objet HTML (name)
	 * @param string $selectIsDisabled Désactivation du select
	 * @param string $function_set Fonction d'ajout de données
	 * @param string $function_del Fonction de suppression de données
	 * @param object SelectListIn Objet contenant les données à retirer de la liste.
	 */
	function SelectListOut($function_get, $title,$selectName,$selectIsDisabled,$selectListIn,$selectOnClick=""){
		parent::SelectList($function_get, $title,$selectName,$selectIsDisabled,$selectOnClick);
		$this->selectListIn=$selectListIn;
	}
	
	/**
	 * Obtenir les éléments du select, qui sont les élements de la liste moins ceux de la liste $selectListIn.
	 * @return mixed array Un tableau contenant le resultat de la fonction
	 */
	function getElements(){
		$tmp=parent::getElements();
		foreach(parent::getElements() as $out_ind => $out_values){
			foreach($this->selectListIn->getElements() as $in_ind => $in_values){
				if($out_values[0]==$in_values[0]){
					unset($tmp[$out_ind]);
				}
			}
		}
		return $tmp;
	}
}
?>