<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @param var {IN_TITLE}
 * @param var {IN_SELECT_NAME}
 * @param var {IN_SELECT_DISABLED}
 * @param var {BLOCK_LINE_IN}
 * @param var {OUT_TITLE}
 * @param var {OUT_SELECT_NAME}
 * @param var {OUT_SELECT_DISABLED}
 * @param var {BLOCK_LINE_OUT}
 * 
 * @param block_target {$block_target}
 */
class guiSelectListAddRemove extends PageComponent{
	
	
	/**
	 * Constructeur.
	 * @param string $block_target Bloc cible dans lequel on veut afficher ce PageComponent
	 * @param object SelectListAddRemove $selectListAddRemove Les sous Modules du Module
	 * @param string $module_root Chemin racine des fichiers de templates (TPL)
	 * @param string $templates Les fichiers de Templates
	 * @param integer $id Identifiant pour permettre l'affichage de plusieurs de cet objet dans une meme page
	 */
	function guiSelectListAddRemove($block_target,$selectListAddRemove,$module_root=null,$templates=null,$id=null){
		global $root;
		parent::PageComponent($module_root,$templates);
		
		
//		print_rr($selectListAddRemove);
		$gui_in=new guiSelectList('select_list_in','in',$selectListAddRemove->getIn(),$root."lib_graphique/selects/selectList/templates/tpl",array('select_list_in' => 'gui_select_list.tpl'));
		$this->setComponent('select_list_in',$gui_in);
		
		$gui_out=new guiSelectList('select_list_out','out',$selectListAddRemove->getOut(),$root."lib_graphique/selects/selectList/templates/tpl",array('select_list_out' => 'gui_select_list.tpl'));
		$this->setComponent('select_list_out',$gui_out);
		
		$val['SELECT_IN']='in';
		$val['SELECT_OUT']='out';
		$val['OBJ_LIST_ADD_REMOVE']=exportObject($selectListAddRemove,'DROITS_LIST_ADD_REMOVE_'.$id);
		$val['SELECT_LIST_ADD_SUBMIT_VALUE']=FORM_11;
		$val['SELECT_LIST_REMOVE_SUBMIT_VALUE']=FORM_42;
		$this->set_var($val);
		
	}
}
?>