<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
*	Selection d'une heure.
*	Cette page propose 3 selects permettant le choix d'un nombre d'heures, de minutes ou de secondes.
*	
*	@param string	$hms_form_name				Indique le nom du formulaire, facultatif.			
*	@param string	$hms_select_heure_name		Valeur initiale des heures (de 0 � 19)
*	@param integer	$hms_select_heure_value		Nom du select pour les heures 			
*	@param string	$hms_select_minute_name		Nom du select pour les minutes (de 0 � 60)
*	@param integer	$hms_select_minute_value	Valeur initiale des minutes
*	@param string	$hms_select_seconde_name	Nom du select pour les secondes (de 0 � 60)
*	@param integer	$hms_select_seconde_value	Valeur initiale des secondes					
*	
*	@param bool $hms_units: si true affichage des unit�s des lib�ll�s complets (Heure(s),Minute(s),Seconde(s)), pas affich� si � false (par d�faut).
*	@param bool $hms_columns: si true affichage des �l�ments dans des colonnes de tableau (balises <td></td>),  � false par d�faut).
*	@param bool $hms_disable_selects : si true, on desactive les select, false par d�faut.
*	@author remi cocquet
*
*	@package lib_graphique_selects
*/

/*PRATIQUE! � copier/coller puis modifier les valeurs si besoin
$hms_form_name="formduree";
$hms_select_heure_name="h$row_etap[0]";
$hms_select_heure_value=$tabhms["heure"];			
$hms_select_minute_name="m$row_etap[0]";
$hms_select_minute_value=$tabhms["minute"];
$hms_select_seconde_name="s$row_etap[0]";
$hms_select_seconde_value=$tabhms["seconde"];
$hms_units=true;
$hms_columns=false;
$hms_disable_selects=false;
include("$chemin_bo/lib_graphique/selects/selectHMS.php");
*/
//-------------------------------------------------
//			FONCTIONS
//-------------------------------------------------
if(!function_exists('add_zero')){
	function add_zero($num){
	        if($num<10)
	                $num='0'.$num;
	        return $num;
	}
}
//-------------------------------------------------
//			TEST DES VARIABLES
//-------------------------------------------------
if (empty ($hms_select_heure_name) || !isset ($hms_select_heure_value) || empty ($hms_select_minute_name) || !isset ($hms_select_minute_value) ) {
	print ("Tous les parametres requis pour le fichier \"selectHMS.php\"ne sont pas correctement initialisees:<BR>
			hms_select_heure_name=$hms_select_heure_name<BR> hms_select_heure_value=$hms_select_heure_value<BR> hms_select_minute_name=$hms_select_minute_name<BR> hms_select_minute_value=$hms_select_minute_value<BR> hms_select_seconde_name=$hms_select_seconde_name<BR> hms_select_seconde_value=$hms_select_seconde_value<BR>");
	exit ();
}

if($hms_disable_selects)$disabled="disabled";
else $disabled="";
//-------------------------------------------------
//			FORMULAIRE
//-------------------------------------------------
if(!empty($hms_form_name))print ("<form name=\"$hms_form_name\"  method=\"get\">");

//-------------------------------------------------
//			SELECT HEURES
//-------------------------------------------------
if($hms_columns)print("<td align=\"center\" nowrap>");
print("<select name=\"$hms_select_heure_name\" $disabled>");
for ($h = 0; $h < 24; $h++) {
	if ($hms_select_heure_value == $h)
		print ("<option value=\"$h\" selected>".add_zero($h)."</option>");
	else
		print ("<option value=\"$h\">".add_zero($h)."</option>");
}
if($hms_units)$hms_unit=$MSG_263;
print ("</select>&nbsp;$hms_unit&nbsp;&nbsp;&nbsp;&nbsp;");
if($hms_columns)print("</td><td align=\"center\" nowrap>");						
//-------------------------------------------------
//			SELECT MINUTES
//-------------------------------------------------						
print("<select name=\"$hms_select_minute_name\" $disabled>");

for ($m = 0; $m < 60; $m++) {
	if ($hms_select_minute_value == $m)
		print ("<option value=\"$m\" selected>".add_zero($m)."</option>");
	else
		print ("<option value=\"$m\">".add_zero($m)."</option>");
}
if($hms_units)$hms_unit=$MSG_262;
print ("</select>&nbsp;$hms_unit&nbsp;&nbsp;&nbsp;&nbsp;");
if($hms_columns)print("</td>");	
//-------------------------------------------------
//			SELECT SECONDES
//-------------------------------------------------
if(!empty ($hms_select_seconde_name) ){
	if($hms_columns)print("<td align=\"center\" nowrap>");
	print("<select name=\"$hms_select_seconde_name\" $disabled>");
	
	for ($s = 0; $s < 60; $s++) {
		if ($hms_select_seconde_value == $s)
			print ("<option value=\"$s\" selected>".add_zero($s)."</option>");
		else
			print ("<option value=\"$s\">".add_zero($s)."</option>");
	}
	if($hms_units)$hms_unit=$MSG_261;
	print ("</select>&nbsp;$hms_unit&nbsp;&nbsp;&nbsp;&nbsp;");
	if($hms_columns)print("</td>");
}	
//-------------------------------------------------
//				FIN FORMULAIRE
//-------------------------------------------------
if(!empty($hms_form_name))print ("</form>");
?>