<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
*	Selection d'une date.
*	Cette page propose 3 selects permettant le choix du jour, du mois ou de l'anne.
*	
*	@param string	$jma_form_name				Indique le nom du formulaire, facultatif.			
*	@param string	$jma_select_jour_name		Valeur initiale du jour (de 1  31)
*	@param integer	$jma_select_jour_value		Nom du select pour les jours 			
*	@param string	$jma_select_mois_name		Nom du select pour les mois 
*	@param integer	$jma_select_mois_value	Valeur initiale des mois (de 1  12)
*	@param string	$jma_select_annee_name	Nom du select pour les annes
*	@param integer	$jma_select_annee_value	Valeur initiale des annes	(a configurer)
*	@param integer	$jma_select_annee_min	Valeur minimale des annes	(a configurer)	
*	@param integer	$jma_select_annee_max	Valeur maximale des annes	(a configurer)					
*	
*	@param bool $jma_columns: si true affichage des lments dans des colonnes de tableau (balises <td></td>),   false (par dfaut).
*	
*	@author remi cocquet
*
*	@package lib_graphique_selects
*/

/*PRATIQUE!  copier/coller puis modifier les valeurs si besoin
$jma_form_name="formdeb";
$jma_select_jour_name="jour";
$jma_select_jour_value=$jma_tab['mday'];			
$jma_select_mois_name="mois";
$jma_select_mois_value=$jma_tab["month"];
$jma_select_annee_name="annee";
$jma_select_annee_value=$jma_tab["year"];
$jma_select_annee_min=$jma_tab['year'];
$jma_select_annee_max=$jma_tab['year']+20;
$jma_columns=false;
include("$chemin_bo/lib_graphique/selects/selectJMA.php");
*/

//-------------------------------------------------
//			TEST DES VARIABLES
//-------------------------------------------------
if (empty ($jma_select_jour_name) || !isset ($jma_select_jour_value) || empty ($jma_select_mois_name) || !isset ($jma_select_mois_value) || empty ($jma_select_annee_name) || !isset ($jma_select_annee_value)) {
	print ("Tous les parametres requis pour le fichier \"selectJMA.php\"ne sont pas correctement initialisees:<BR>
			jma_select_jour_name=$jma_select_jour_name<BR> jma_select_jour_value=$jma_select_jour_value<BR> jma_select_mois_name=$jma_select_mois_name<BR> jma_select_mois_value=$jma_select_mois_value<BR> jma_select_annee_name=$jma_select_annee_name<BR> jma_select_annee_value=$jma_select_annee_value<BR>");
	exit ();
}

//-------------------------------------------------
//			FORMULAIRE
//-------------------------------------------------
if(!empty($jma_form_name))print ("<form name=\"$jma_form_name\"  method=\"get\">");
//-------------------------------------------------
//			SELECT ANNEES
//-------------------------------------------------
print("<select name=\"$jma_select_jour_name\" onchange=\"JMAvalidationDate('$jma_select_annee_name','$jma_select_mois_name','$jma_select_jour_name')\">");

for ($j = 1; $j < 32; $j++) {
	if ($jma_select_jour_value == $j)
		print ("<option value=\"$j\" selected>$j</option>");
	else
		print ("<option value=\"$j\">$j</option>");
}
print ("</select>&nbsp;&nbsp;&nbsp;&nbsp;");
if($jma_columns)print("</td><td align=\"center\" nowrap>");						
//-------------------------------------------------
//			SELECT MOIS
//-------------------------------------------------						
print("<select name=\"$jma_select_mois_name\" onchange=\"JMAvalidationDate('$jma_select_annee_name','$jma_select_mois_name','$jma_select_jour_name')\">");

for ($m = 1; $m < 13; $m++) {
	if ($jma_select_mois_value == $m)
		print ("<option value=\"$m\" selected>$m</option>");
	else
		print ("<option value=\"$m\">$m</option>");
}
print ("</select>&nbsp;&nbsp;&nbsp;&nbsp;");
if($jma_columns)print("</td><td align=\"center\" nowrap>");	

//-------------------------------------------------
//			SELECT JOURS
//-------------------------------------------------
if($jma_columns)print("<td align=\"center\" nowrap>");

print("<select name=\"$jma_select_annee_name\" onchange=\"JMAvalidationDate('$jma_select_annee_name','$jma_select_mois_name','$jma_select_jour_name')\">");

for ($a = $jma_select_annee_min; $a  < $jma_select_annee_max+1; $a ++) {
	if ($jma_select_annee_value == $a )
		print ("<option value=\"$a\" selected>$a</option>");
	else
		print ("<option value=\"$a\">$a</option>");
}
print ("</select>&nbsp;&nbsp;&nbsp;&nbsp;");

if($jma_columns)print("</td>");	
//-------------------------------------------------
//				FIN FORMULAIRE
//-------------------------------------------------
if(!empty($jma_form_name))print ("</form>");
?>