<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fonctions javascript ncessaire au script selec_JMA.php.
 * 
 * @package lib_graphique_selects
 */


/**
 * Fonction qui vrifie et corrige si besoin la date
 * obtenue  partir de 3 select.
 * Un message est affich si la date saisie n'existe pas.
 * 
 * @param string : nom du select pour l'annee
 * @param string : nom du select pour le mois
 * @param string : nom du select pour le jour
 * 
 * @return bool : true si la date a t modifie, false sinon
 */
print("
function JMAvalidationDate(JMAselect_annee, JMAselect_mois, JMAselect_jour) {

	var annee=parseInt(document.getElementsByName(JMAselect_annee)[0].value);
	var mois=parseInt(document.getElementsByName(JMAselect_mois)[0].value);
	var jour=parseInt(document.getElementsByName(JMAselect_jour)[0].value);
	
	//On cre la date correspondante. Attention, les mois sont talonns de 0  11
	var nouvelle_date = new Date(annee,mois-1,jour);

	//correction du bug de l'an 2000 , on n'a pas toujours 4 chiffres pour l'anne selon les navigateurs, on corrige donc.
	cor_annee = nouvelle_date.getYear();
	if ((Math.abs(cor_annee)+'').length < 4) cor_annee = (Math.abs(cor_annee) + 1900)

	//On verifie si la date saisie et la date cre sont les memes
	var ok = (nouvelle_date.getDate() == jour) && (nouvelle_date.getMonth() == (mois-1)) && (cor_annee == annee);
	
	if(!ok){
		//on corrige
		alert('La date '+annee+'/'+mois+'/'+jour+' n\'existe pas.\\nElle va donc tre corrige par : '+cor_annee+'/'+(nouvelle_date.getMonth()+1)+'/'+nouvelle_date.getDate());
		document.getElementsByName(JMAselect_annee)[0].value=cor_annee;
		document.getElementsByName(JMAselect_mois)[0].value=(nouvelle_date.getMonth()+1);
		document.getElementsByName(JMAselect_jour)[0].value=nouvelle_date.getDate();
	}
		
	return (ok)
}");

?>
