<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Objet de gestion des données pour une liste de selection HTML. 
 * 
 * La fonction utilisée dans cet objet doit renvoyer un resultat sql.
 *  
 */
class SelectList{
	
	var $function_get;
	var $title;
	var $selectName;
	var $selectIsDisabled;
	var $selectOnClick;
	
	/**
	 * Constructeur.
	 * 
	 * @param string $function_get Fonction de remplissage des données
	 * @param string $title Titre de la liste de séléction
	 * @param string $selectName Nom de l'objet HTML (name)
	 * @param string $selectIsDisabled Désactivation du select
	 */
	function SelectList($function_get, $title,$selectName,$selectIsDisabled="",$selectOnClick=""){
		$this->function_get=$function_get;
		$this->title=$title;
		$this->selectName=$selectName;
		$this->selectIsDisabled=$selectIsDisabled;
		$this->selectOnClick=$selectOnClick;
		
	} 
	
	/**
	 * @return string Titre de la liste de séléction
	 */
	function getTitle(){
		return $this->title;
	}
	
	/**
	 * @return Nom de l'objet HTML (name)
	 */ 
	function getSelectName(){
		return $this->selectName;
	} 
	
	/**
	 * Dsactivation de l'objet HTML (name)
	 */
	function getSelectIsDisabled(){
		return $this->selectIsDisabled;
	} 
	
	
	/**
	 * Obtenir la fonction javascript dclenche sur la selection d'un lment.
	 * @return string La fonction javascript
	 */
	function getSelectOnClick(){
		return $this->selectOnClick;
	} 
	
	/**
	 * Obtenir les éléments de la liste de selection
	 * @return mixed array Un tableau contenant le resultat de la fonction
	 */
	function getElements(){
		$tab=array();
		$res_query_get=eval('return '.$this->function_get.';');
		while ($row = @pg_fetch_row($res_query_get)) {
				$tab[] = $row;	
		}
		return $tab;
	}
	
}

?>