<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

class guiSelectTheme extends PageComponent{
	function guiSelectTheme($block_target,$module_root,$templates,$select_name='id_theme',$selected_id=null,$disabled=false,$on_change=""){
		global $MSG_117,$MSG_215;
		parent::PageComponent($module_root,$templates);
		$val['THEME_SELECTION_LIBELLE']=$MSG_117;
		$val['THEME_SELECTION_DEFAULT']=$MSG_215;
		if(empty($selected_id))$val['DEFAULT_THEME_SELECTED']=' selected="selected"';
		$val['THEME_SELECTION_NAME']=$select_name;
//		echo "\$selected_id=$selected_id";
		$this->set_block($block_target,'block_themes','block_theme');
		$res_themes=get_plateforme_themes();
		$nb_themes=pg_num_rows($res_themes);
		for($i=0;$i<$nb_themes;$i++){
			$row=pg_fetch_row($res_themes);
			$tmp_theme=get_ams_libelles($row[1]);
        	$row[1]=get_ams_libelle($tmp_theme,50);
			$this->set_block_var('THEME_ID',$row[0]);
			$this->set_block_var('THEME_LIBELLE',$row[1]);
			if($row[0]==$selected_id){
				$this->set_block_var('THEME_SELECTED',' selected="selected"');
			}else{
				$this->set_block_var('THEME_SELECTED','');
			}
		}
		
		if($disabled){
			$val['SELECT_DISABLED']='disabled="disabled"';
		}		
		if(!empty($on_change)){
			$val['SELECT_ON_CHANGE']=$on_change;
		}
		
		parent::set_var($val);

				
	}
}
?>