<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage des statistiques d'une formation d'un individu .
 * 
 * Affiche l'icone et le libll associ au type d'tape ainsi que les proprits spcifiques au type.
 */
 class guiStatsIndividuFormation extends PageComponent{
 	
 	function guiStatsIndividuFormation($block_target, $obj_stats,$module_root=null,$templates=null){
 		parent::PageComponent($module_root,$templates);
 		
		$gui_formation_temps =new guiStatsIndividuFormationTemps( 'formation_temps',$obj_stats,$module_root,array('formation_temps' => 'gui_stats_individu_formation_temps.tpl'));
		$this->setComponent( 'formation_temps',$gui_formation_temps);
		
		$gui_formation_etapes =new guiStatsIndividuFormationParcours( 'formation_parcours',$obj_stats->getProperty('obj_parcours'),$module_root,array('formation_parcours' => 'gui_stats_individu_formation_parcours.tpl'));
		$this->setComponent( 'formation_parcours',$gui_formation_etapes);
		
		//libll de la formation
		$val['FORMATION_LIBELLE_LABEL']=$obj_stats->getPropertyField('libelle',STATS_FIELD_LABEL);
		$val['FORMATION_LIBELLE']=$obj_stats->getPropertyField('libelle',STATS_FIELD_VALUE);

		//libll de la classe de l'individu pour la formation (1 seule pour l'instant)		
		$obj_classe_stats=$obj_stats->getPropertyField('classes',STATS_FIELD_VALUE);
		$obj_classe_stats=$obj_classe_stats[0];//(1 seule pour l'instant)
		$val['FORMATION_CLASSE_LABEL']=$obj_classe_stats->getPropertyField('libelle',STATS_FIELD_LABEL);
		$val['FORMATION_CLASSE']=$obj_classe_stats->getPropertyField('libelle',STATS_FIELD_VALUE);

		//dates de la formation		
		$val['FORMATION_DATES_LABEL']='';//seuls cas ou on met des messages car diffrent de libelle/valeur
		$val['FORMATION_DATES_DU']='';
		$val['FORMATION_DATES_AU']='';
		$val['FORMATION_DATE_DEBUT']=$obj_stats->getPropertyField('debut',STATS_FIELD_VALUE);
		$val['FORMATION_DATE_FIN']=$obj_stats->getPropertyField('fin',STATS_FIELD_VALUE);
		
		$this->set_var($val);
 	}
 }
?>