<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*
 * Created on Sep 25, 2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 
 /**
  * classe gnrique des filtres
  */
  class DataFilter{
  	
  	var $label;
  	var $name;
  	var $query;
  	var $type;
  	var $result;
  	var $disabled;
  	
  	/**
  	 * constructeur
  	 * @param integer : label
  	 * @param string : name
  	 * @param string : type
  	 * @param string : requete
  	 */
  	function DataFilter($label,$name,$type,$query='',$disabled=false){
  		$this->label=$label;
  	 	$this->name=$name;
  	 	$this->disabled=$disabled;
  	 	$this->type=$type;
  	 	if(!empty($query)){
			$this->query=$query;
			$this->result=pg_query($this->query);
  	 	}
	}
  	 
  	 /**
  	  * Obtenir le label
  	 */
 	function getLabel(){
  		return $this->label;
  	}
  	 
  	 /**
  	  * Obtenir le name
  	 */
  	function getName(){
  		return $this->name;
  	}
  	 
  	 /**
  	  * Obtenir le disabled
  	 */
  	function getDisabled(){
  		return $this->disabled;
  	}
  	 
  	 /**if(!empty($query)){
  	  * Obtenir le type
  	 */
  	function getType(){
  		return $this->type;
  	}
  	 
  	   /**
  	    * Nombre de lignes rsultat total
  	    */
  	function getNumRows(){
  		return pg_num_rows($this->result);	
  	}
  	    
  	function getResult(){
  		return $this->result;	
  	}
  	    
  	     /**
  	        * retourne un tableau contenant les attributs de l'objet qu'on va srialiser
  	       */
  	       
  	function __sleep(){
  		$this->result=null;
  	    return array("query","label","name","type","disabled");
  	}
  	       
  	/**
  	* affecte les resultat
  	*/
  	  
  	function __wakeup(){
  		if (!empty($this->query)){
  	    	$this->result=pg_query($this->query);	
  	    }
    }
}
?>