<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*
 * Created on Sep 25, 2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 
 /**
  * Gestion des filtres des donnes multilingues compltes
  * 
  */
class MultilingualFilterBox extends DataFilterBox{
	var $languageSelectionBox;
	
 //Dplac de DataFilterBox par RC
 	var $langueCourante;
  	
  		/**
  	 	* constructeur
  	 	* @param LanguageSelectionBox (slection des langues  afficher)
  	 	*/
  	function MultilingualFilterBox($languageSelectionBox,$label,$formname,$formaction,$submitname,$req,$fonction_page,$filters,$submitvalue,$submitdisabled=false){
  		parent::DataFilterBox($formname,$req,$fonction_page,$filters,$formaction,$submitname,$submitvalue,$submitdisabled);
  	 	$this->languageSelectionBox=$languageSelectionBox;	
//Dplac de DataFilterBox par RC
  	 	$this->langueCourante=null;
  	 }
  	 
  	 	/**
  	  	* Retourne l'objet languageSelectionBox
  	  	*/
  	 function &getLanguageSelectionBox(){
  	 	return $this->languageSelectionBox;
  	 }
  	 	
  	 	/**
  	 	 * Effectue les traitements lors de la validation de formulaire ou rechargement de page
  	 	 * @param string[] $tab Ce tableau contient les valeurs de l'objet LanguageSelectionBox puis un nombre variables de valeur pour les objets Filters et 2 valeurs fixes correspondant  l'Objet et au bouton submit    
  	 	 * 
  	 	 */
  	 function submit($tab){

  	 	// extrait  la premiere valeur du tableau
  	 	$tab_first=array_shift($tab);
  	 	 	
  	 	// Pour les traitements sur l'objet languageSelectionBox
  	 	// prepare un tableau de langue avec la langue courante en 1er
  	 	$tab_langue=array();
  	 	$tab_langue[]=$tab['langue'];
  	 	$tab_coche=explode(';',$tab_first);
  	 	while(list($cle,$valeur)=each($tab_coche)){
  	 		if(!in_array($valeur,$tab_langue))
  	 	 		$tab_langue[]=$valeur;
  	 	 }
  	 	 
  	 	$langue=$tab["langue"];
		$this->setLangueCourante($langue);
  	 	$this->languageSelectionBox->submit($tab_langue);
  	 	 	
  	 	 // appelle la methode submit du pere
  	 	 parent::submit($tab);
  	 }
  	 	 
  	   	 	
  	 	/**
  	 	 * Fonctions appeles lors de la srialisation et e la dsrialisation de l'objet
  	 	 */
  	 	       
       /**
        * efface les resultats
       */
       
     function __sleep(){
     	 //"langueCourante" Dplac de DataFilterBox par RC
     	return array_merge(array("languageSelectionBox","langueCourante"),parent::__sleep());
     }
       
       
       /**
        * affecte les resultat
        */
        
     function __wakeup(){
     	parent:: __wakeup();
     }
     
//Dplac de DataFilterBox par RC
    /**
 	 * Affecte l'attribut langueCourante
 	 * @param integer : langue
 	 */
	function setLangueCourante($langue){
 		$this->langueCourante=$langue;
 	}
 	     

//Dplac de DataFilterBox par RC
	/**
	 * Obtenir la langue courante
	 */
 	function getLangueCourante(){
 		return $this->langueCourante;
 	}

 	
//Dplac de DataFilterBox par RC
//	/**
//  	 *  Affectation de la variable queryResult
//  	 * @param array : tableau de parametres pour la query
//	 */
//  	function setQueryResult(){
//  		
//  		
//Modifi par RC
//  		$langue=$this->getLangueCourante();
//  	   	if(!empty($langue)){
//	  		$new_query=$this->query;
//	  	   	// recupre les variables necessaires
//	  	   	$type_message=$this->getTypeMessage();
//	  	   	// message
//			$message=$this->getMessage();
//			if(!empty($message)){
//				$message=addslashes(str_replace("'","''''",($this->getMessage())));
//			}
//			$message=string2sql($message);
//				
//	  	   	// remplace 
//	  	   	$new_query=str_replace("##1##",$langue,$new_query);			//"##langue##" remplac par ##1##
//	  	    $new_query=str_replace("##2##",$type_message,$new_query);    //"##type##" remplac par ##2##
//  	  		$new_query=str_replace("##3##",$message,$new_query);		 //"##message##" remplac par ##3##
//	  	   		
//	  	   	$this->queryResult=pg_query($new_query);// sans offset et limit	
//  	   	}
//  	   	else
//  	   		$this->queryResult=null;
//
//		$new_query=$this->query;
//		$values_ok=true;
//		foreach ($this->filters as $ind=>$filter){
//			$value=$filter->getValue();
//			if(!empty($value)){
//				$new_query=str_replace("##$ind##",$value,$new_query);
//			}else{
//				$values_ok=false;
//			}
//		}
//  	   	if($values_ok)$this->queryResult=pg_query($new_query);// sans offset et limit	
//  	} 	
  	
//Dplac de DataFilterBox et modifi par RC  	 
	/**
	 * Affectation de la variable queryResultPage
	 * @param array : tableau de parametres pour la fonction
	 */
  	function setQueryResultPage(){

  	   	// prpare le tableau des langues slectionnes
  	   	$language_selection_box=$this->getLanguageSelectionBox();
  	   	$tab_checked=$language_selection_box->getSelectedLanguages();
  	   	$tab_coche[]=$this->getLangueCourante();
		while(list($cle,$val)=each($tab_checked)){
			$cle+=1;
			if(!in_array($val,$tab_coche))
				$tab_coche[]=$val;	
		}
  	  
  	    $new_fonction=$this->fonctionPage;
		
  	   	$new_fonction=str_replace("##0##",int_array_to_php_array($tab_coche),$new_fonction); //ok

		// colonne et ordre
		$order=string2sql($this->getOrder());
		$colonne=$this->getColumn();
			
		// limit
		$limit=$this->getLimit();
		
		// offset
		$offset=$this->getOffset();
		
		$values_ok=true;
		foreach ($this->filters as $ind=>$filter){
			$value=$filter->getValue();
			if(!empty($value)){
				$new_fonction=str_replace("##$ind##",$value,$new_fonction);
			}else{
				$values_ok=false;
			}
		}
  	   
	  	// boucle sur les filters
  	   	$new_fonction=str_replace("##limit##",$limit,$new_fonction);//non limit
  	   	$new_fonction=str_replace("##num_champ##",$colonne,$new_fonction);//non
  	   	$new_fonction=str_replace("##classement##",$order,$new_fonction);//ok
  	   	$new_fonction=str_replace("##offset##",$offset,$new_fonction);//ok
  	   	if($values_ok){
  	   		eval("\$this->queryResultPage=$new_fonction;");	
  	   	}
  	}   
}
?>