<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*
 * Created on Sep 25, 2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 /**
  * Donnes du tableau  afficher
  * 
  */
class TableModel{
	var $dataFilter;
  	var $offset;
  	var $currentPage;
  	var $formName;
  	var $formAction;
  	var $columnLabelFunction;
  	var $queryResult;
  	var $lines_actions;
  	
  	/**
   	* constructeur
   	* @param object DataFilterBox $data_filter :contient toutes les infos (rsultat requete,noms des champs,les langues etc ...
   	* 
   	*/ 
	function TableModel($data_filter,$num_page,$formname,$formaction,$lines_actions){
	
 		$this->dataFilter=$data_filter;	 
 		$this->currentPage=$num_page;	
 		$this->formName=$formname;
 		$this->formAction=$formaction;
 		$this->lines_actions=$lines_actions;
 	}
  	
  	/**
   	* Affecte la variable offset (calcule avec la limit et la currentPage)
   	*/
 	function setOffset($offset){
 		$this->offset=$offset; 		 	
 	}
 	
 	/**
 	* Obtenir l'objet dataFilter
 	*/
 	function &getDataFilter(){
  		return $this->dataFilter;
  	}
  	
  	/**
  	 * Affecte l'objet dataFilter
  	*/ 
 	function setDataFilter($filter){
  		return $this->dataFilter=$filter;
  	}
  	
   	/**
    * positionner la valeur de la variable currentPage
  	* 
  	*/
  	function setPage($page){
  		$this->currentPage=$page;  
  		// calcul offset et le positionne
  		//limit
  		$limit=$this->dataFilter->getLimit();
  		$offset=($page-1)*$limit;
  		$this->dataFilter->setOffset($offset);		
  	}
  	
  	/**
  	 * Obtenir la page courante
  	 */
  	 // renommer par getCurrentPage pour respecter les conventions
  	 function getPageCourante(){
  	 	return $this->currentPage;
  	 }
  	 function getCurrentPage(){
  	 	return $this->currentPage;	
  	 }
  	
  	 function refresh(){
   		$this->dataFilter->setQueryResult();
   		$this->dataFilter->setQueryResultPage();
  	 }
  	 
  	/**
   	* Affecte les paramtres de tris
   	* 
   	*/
 	function setOrder($column,$order){
 		$this->dataFilter->setOrder($column,$order);
 	}
 
 
 	/**
 	 * Retourne le numro de colonne
 	 */
 	function getColumnId(){
 	 	//$this->$columnLabelFunction;
 	}
 	
 	
 	/**
 	 * 
 	 * Retourne le label d'une colonne
 	 */
 	function getColumnLabel($id_colonne){
 		if(func_num_args()==1){
//Modifi par RC, on utilise les noms de colonnes retournes par la requete
//	 		// recup fonction du type get_
//	 	 	$new_fonction=$this->columnLabelFunction;
//	 	 	// remplace ##column## par id_colonne
//	 	 	$new_fonction=str_replace("##column##",$id_colonne,$new_fonction);
//	 	 	// evalue
//	 	 	eval("\$new_fonction=$new_fonction;");
//	 	 	// execute
//	 	 	$res=$new_fonction;
//	 	 	// retourne le label
//	 	 	return pg_fetch_result($res,1);
			$result_page=$this->dataFilter->getQueryResultPage();
	 	 	if($result_page){
	 	 		return get_langue_message(strtoupper(pg_field_name($result_page,$id_colonne)),false);
	 	 	}
 		}
 		
		return null;
 	}
 	
 	
 	 /**
  	  * Rsultat de la requete
  	  */
  	function getQueryResult(){
  		return $this->queryResult;	
  	}
 	
 	
 	/**
  	*  Retourne le nombre de page
  	*/
  	function getNumPages(){
  		$this->refresh();
  		return ceil($this->dataFilter->getNumRows()/$this->dataFilter->getLimit());
  	}
  
 	 /**
   	* Effectue les traitements lors d'un rechargement de page
   	*/
	function submit($tab){
		// recup les objets data_filter et language_selection_box et les valeurs necessaires pour la requete
   		$data_filter=$this->getDataFilter();
   		$num_page=$tab['num_page'];
   		$num_column=$tab['num_column'];
   		// recup page courante
   		$page_courante=$this->getCurrentPage();
   		if($num_page!=$page_courante)
   			$this->setPage($num_page);
   		else{
   			$order=$data_filter->getOrder();	
   			if($order=='asc')
   				$order='desc';
   			else
   				$order='asc';
   			$this->setOrder($num_column,$order);
   		}
   		$this->dataFilter->setQueryResult();
   		$this->dataFilter->setQueryResultPage();
	}
   
   
	/**
    * efface les resultats
    */
    function __sleep(){
  		return array("offset","currentPage","dataFilter","formName","formAction","lines_actions");
	}
       
       
       
       
    /**
    * affecte les resultat
    */
    function  __wakeup(){
    }
    
     /**
  	 * Obtenir le nom du formulaire
  	 */
  	function getFormName(){
  		return $this->formName;	
  	}
  	 
  	  /**
  	  * Obtenir l'action du formulaire
  	  */
  	function getFormAction(){
  		return $this->formAction;	
  	}
  	
  	/**
  	 * Obtenir les diffrentes actions possibles pour une ligne rsultat
  	 */
  	function getLinesActions () {
		return $this->lines_actions;
	}
	
	/**
	 * Retourne un texte ams sans le code country 
	 * @param string : la chaine
	 * @return string : chaine
	 */
	 function get_ams_libelle_without_country_code($ams,$taille=50){
	 	global $ams_langue;	
	 	$tmp_reponse=$ams;
		if(!is_array($tmp_reponse)){
			$reponse=substr($tmp_reponse,0,$taille);
		}
    	//UNE OU PLUSIEURS AMS
    	else{
			//1 SEULE AMS
			if(count($tmp_reponse)==1){
				$cur_ams=$tmp_reponse[0];
				if($cur_ams[0]!=$ams_langue){
					$cur_ams=array($ams_langue,'');
				}
			}
			//PLUSIEURS AMS
			else{
				$trouve=false;					
				foreach($tmp_reponse as $indice => $tmp_rep){
					if($tmp_rep[0]==$ams_langue){
						$cur_ams=$tmp_rep;
						$trouve=true;
					}
				}
				if(!$trouve){
					$cur_ams=array($ams_langue,'');
			}
		}
		$reponse=substr($cur_ams[1],0,$taille);
		if(strlen($reponse)>$taille){
	    	$reponse.="...";
	    }
	    /*
		$res_langue=get_langue($cur_ams[0]);
        $cur_langue=pg_fetch_result($res_langue,0,3);
        
        if(!empty($cur_langue)){ //n'arrive jamaais
	    	$reponse.="(".get_country_code_primary($cur_langue).")";
        }
        
        else{
        	$reponse.="(X)";
        }
        */
        
	}
	return $reponse;	
	 }
       
}
?>