<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Les constantes
 */
 define("TABLE_MODEL_LINE_ID","id");
 define("TABLE_MODEL_LINE_LABEL","label");
 define("TABLE_MODEL_LINE_DATE","date");
 define("TABLE_MODEL_LINE_INPUT","input");
 define("TABLE_MODEL_LINE_NONE","none");
 
/**
 * Classe permettant de dfinir la struture (les types de gui a utiliser pour les colonnes)
 * des lignes d'un guiTableModel.
 * 
 */
class TableModelGuiLineStruct{
	var $special_columns;
 	var $default_columns_type;
 	
 	/**
 	 * Constructeur.
 	 * Permet de stocker la dfinition de structure.
 	 * @param string[] $special_columns_types Tableau ayant pour cl les indices des colonnes dont on veut spcifier le type et comme valeur la chaine du type
 	 * @param string $default_columns_type La chaine definisant le type de cellule ('label', 'input' ou 'none') par dfaut ('label' si non spcifi). 
 	 */	
 	 //modifier 'label' avec la constante approprie
 	function TableModelGuiLineStruct($special_columns_types, $default_columns_type=TABLE_MODEL_LINE_LABEL){
 		$this->special_columns_types=$special_columns_types;
 		$this->default_columns_type=$default_columns_type;
 	}
 	
 	/**
 	 * Obtenir le type de gui  utilier pour une colonne.
 	 * @param integer $column L'indice de la colonne du guiTableModel
 	 * @return string une chaine definisant le type de cellule ('label', 'input' ou 'none') 
 	 */
 	function getColumnType($column){
 		if(array_key_exists($column,$this->special_columns_types)){
 			return $this->special_columns_types["$column"];
 		}
 		else{
 			return $this->default_columns_type;
 		}
 	}
}
?>